/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport.grpc;

import com.siams.cv.monitor.transport.grpc.GrpcV1;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.stare.grpc.StareServiceGrpc;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public abstract class GRPCSchedule
implements Deletable {
    protected GrpcV1 grpcV1;
    protected int interval;
    protected TimeUnit timeUnit;
    protected Timer timer;
    protected StareServiceGrpc.StareServiceStub stub;
    protected TimerTask timerTask = null;

    GRPCSchedule(GrpcV1 grpcV1, int interval, TimeUnit timeUnit) {
        this.grpcV1 = grpcV1;
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    void updateSchedule(int interval, TimeUnit timeUnit, TimerTask timerTask) {
        this.interval = interval;
        this.timeUnit = timeUnit;
        int period = (int)TimeUnit.MILLISECONDS.convert(interval, timeUnit);
        this.timer = new Timer(true);
        this.timer.schedule(timerTask, 0L, (long)period);
    }

    @Override
    public void release() {
        this.releaseTimer();
    }

    void releaseTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }
}

