/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;

public class UISync {
    private static UISync instance;
    private LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque();
    private long frameRate = TimeUnit.NANOSECONDS.convert(25L, TimeUnit.MILLISECONDS);
    private long old = 0L;

    public UISync() {
        AnimationTimer animationTimer = new AnimationTimer(){

            public void handle(long now) {
                if (now - UISync.this.old > UISync.this.frameRate) {
                    UISync.this.old = now;
                    Runnable runnable = UISync.this.queue.poll();
                    if (runnable == null) {
                        return;
                    }
                    while (runnable != null) {
                        runnable.run();
                        runnable = UISync.this.queue.poll();
                    }
                }
            }
        };
        animationTimer.start();
    }

    public static UISync getInstance() {
        if (instance == null) {
            instance = new UISync();
        }
        return instance;
    }

    public boolean update(Runnable runnable) {
        return this.queue.add(runnable);
    }
}

