/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.StareClipboard;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.NewNodeAdded;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectPrepareToSave;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.model.node.ConnectionModel;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.ui.Zoomer;
import com.siams.cv.monitor.ui.content.container.MouseSelection;
import com.siams.cv.monitor.ui.content.container.UIDesktopSelectionGroup;
import com.siams.cv.monitor.ui.content.container.ViewerContainer;
import com.siams.cv.monitor.ui.factory.Connection;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.SmartLink;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIBlockContent;
import com.siams.cv.monitor.ui.factory.UIComment;
import com.siams.cv.monitor.ui.factory.UICommentContent;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UILinkAnchor;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.cv.monitor.viewers.ui.content.PlainTextViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Rectangle;
import net.algart.json.Jsons;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class Desktop
extends AnchorPane
implements Deletable {
    private final Logger logger = Logger.getLogger(Desktop.class);
    private static final App app = App.getInstance();
    private static final NodeStorage nodeStorage = NodeStorage.getInstance();
    private final CornerScroll cornerScroll = new CornerScroll();
    public static final String ID_NODE_BACKGROUND = "f82ac34d-4082-41d3-84a0-6329e383d53c";
    private static Desktop instance;
    private final double scaleFactor = 1.25;
    private final double maxScale = 8.0;
    private final double minScale = 0.2;
    private MouseSelection rectangleSelection;
    private UIDesktopSelectionGroup selectionGroup;
    @FXML
    private AnchorPane anchorPaneRoot;
    @FXML
    private Button buttonZoomOut;
    @FXML
    private Button buttonZoomIn;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private Group groupScrollPane;
    @FXML
    private StackPane stackPaneZoomable;
    @FXML
    private Group groupElements;
    @FXML
    private Rectangle rectangleBackground;
    @FXML
    private CubicCurve dragLink;
    private UILinkAnchor anchorToDrag;
    private ContextMenu contextMenu;
    private FxRunIndicator runIndicator;

    public static Desktop getInstance() {
        if (instance == null) {
            instance = new Desktop();
        }
        return instance;
    }

    private Desktop() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/Desktop.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
            this.initialize();
            this.initializeScrollPaneZoomable();
            this.initializeStackPane();
            this.initializeGrid();
            this.initializeMouseSelection();
            this.initializeContextMenu();
            this.initializeEvents();
            this.initializeSelectionGroup();
            this.initializeDragLink();
            this.initializeCornerScroll();
            this.subscribe();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeCornerScroll() {
        this.cornerScroll.initialize();
    }

    private void initialize() {
        this.buttonZoomIn.setTooltip((Tooltip)new StareTooltip("Zoom in desktop"));
        this.buttonZoomOut.setTooltip((Tooltip)new StareTooltip("Zoom out desktop"));
    }

    private void initializeScrollPaneZoomable() {
        this.scrollPane.viewportBoundsProperty().addListener((observable, oldValue, newValue) -> this.stackPaneZoomable.setMinSize(newValue.getWidth(), newValue.getHeight()));
        this.scrollPane.addEventFilter(KeyEvent.ANY, this::disableDefaultHomeEndScrollActions);
        this.scrollPane.setOnDragOver(this.cornerScroll::dragHandle);
        this.scrollPane.setOnDragDone(this.cornerScroll::disableScroll);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.cornerScroll::dragHandle);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_RELEASED, this.cornerScroll::disableScroll);
    }

    private void initializeStackPane() {
        this.stackPaneZoomable.setOnScroll(event -> {
            event.consume();
            if (event.getDeltaY() == 0.0) {
                return;
            }
            if (event.getDeltaY() > 0.0) {
                this.zoomIn();
            } else {
                this.zoomOut();
            }
        });
    }

    private void initializeGrid() {
        Rectangle rectangle;
        int step;
        this.rectangleBackground.setId(ID_NODE_BACKGROUND);
        Color color = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 0.5);
        int start = step = App.getInstance().getProject().getRoot().getGridSize();
        int end = (int)this.rectangleBackground.getWidth();
        ArrayList<Rectangle> grid = new ArrayList<Rectangle>();
        for (int x = start; x < end; x += step) {
            rectangle = new Rectangle((double)step, (double)end);
            rectangle.setX((double)x);
            rectangle.setY(0.0);
            rectangle.setFill((Paint)Color.TRANSPARENT);
            rectangle.setStroke((Paint)color);
            rectangle.setId(ID_NODE_BACKGROUND);
            rectangle.setMouseTransparent(true);
            grid.add(rectangle);
        }
        for (int y = start; y < end; y += step) {
            rectangle = new Rectangle((double)end, (double)step);
            rectangle.setX(0.0);
            rectangle.setY((double)y);
            rectangle.setFill((Paint)Color.TRANSPARENT);
            rectangle.setStroke((Paint)color);
            rectangle.setId(ID_NODE_BACKGROUND);
            rectangle.setMouseTransparent(true);
            grid.add(rectangle);
        }
        this.groupElements.getChildren().addAll(grid);
        this.groupElements.getChildren().remove((Object)this.dragLink);
        this.dragLink.setId(ID_NODE_BACKGROUND);
        this.groupElements.getChildren().add((Object)this.dragLink);
    }

    private void initializeMouseSelection() {
        this.rectangleSelection = new MouseSelection();
        this.groupElements.getChildren().add((Object)this.rectangleSelection.getSelectionRectangle());
        this.rectangleSelection.setEventHandlingNode((Node)this.rectangleBackground);
        this.rectangleSelection.getSelectionRectangle().setId(ID_NODE_BACKGROUND);
    }

    private void initializeContextMenu() {
        MenuItem menuItemScrollToStopLoopDataProcess = new MenuItem("Scroll to stop loop block");
        menuItemScrollToStopLoopDataProcess.setOnAction(event -> UserAction.scrollToStopLoopDataProcess());
        MenuItem menuItemAddComment = new MenuItem("Add comment block");
        menuItemAddComment.setOnAction(event -> UserAction.addUIComment());
        MenuItem menuItemPaste = new MenuItem("Paste");
        menuItemPaste.setOnAction(event -> {
            Point2D menuCoords = (Point2D)menuItemPaste.getUserData();
            Point2D desktopCoords = this.getDesktopCoordinate(menuCoords.getX(), menuCoords.getY());
            double x = desktopCoords.getX();
            double y = desktopCoords.getY();
            this.pasteChainFromClipboard(x, y);
        });
        MenuItem menuItemCut = new MenuItem("Cut");
        menuItemCut.setOnAction(event -> this.cutChainToClipboard());
        MenuItem menuItemCopy = new MenuItem("Copy");
        menuItemCopy.setOnAction(event -> this.copyChainToClipboard());
        MenuItem menuItemShowProjectConfiguration = new MenuItem("Show project configuration");
        menuItemShowProjectConfiguration.setOnAction(event -> this.showProjectConfiguration());
        this.contextMenu = new ContextMenu(new MenuItem[]{menuItemScrollToStopLoopDataProcess, menuItemAddComment, new SeparatorMenuItem(), menuItemCut, menuItemCopy, menuItemPaste, new SeparatorMenuItem(), menuItemShowProjectConfiguration});
        this.contextMenu.setAutoHide(true);
        this.scrollPane.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, event -> {
            if (app.isDesktopDragging()) {
                return;
            }
            event.consume();
            menuItemPaste.setUserData((Object)new Point2D(event.getX(), event.getY()));
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        });
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.contextMenu.hide());
    }

    private void showProjectConfiguration() {
        App app = App.getInstance();
        app.rqProjectConfiguration().whenComplete((text, err) -> {
            try {
                PlainTextViewerModel viewerModel = new PlainTextViewerModel();
                viewerModel.setTitle("Project configuration");
                PlainTextViewer viewer = (PlainTextViewer)ViewerFactory.create((ViewerKind)ViewerKind.PLAIN_TEXT, (ViewerModel)viewerModel);
                if (err == null) {
                    viewer.setJsonText(Jsons.toPrettyString((JsonObject)Jsons.toJson((String)text)));
                    viewer.enableTextFormatControlsProperty().set(true);
                } else {
                    viewer.setText(err.getMessage());
                }
                FxPlatform.RunFxThread(() -> ViewerContainer.createAndShow((Viewer)viewer));
            }
            catch (Throwable t) {
                String msg = String.format("Failed display project configuration, %s", t.getMessage());
                this.logger.error((Object)msg, t);
                StareNotification.showWarn((String)msg);
            }
        });
    }

    @Deprecated
    private void showChainSettings() {
        App app = App.getInstance();
        app.rqGetData("P/settings", String.class).whenComplete((text, t) -> {
            PlainTextViewerModel viewerModel = new PlainTextViewerModel();
            viewerModel.setTitle("Chain settings");
            PlainTextViewer viewer = (PlainTextViewer)ViewerFactory.create((ViewerKind)ViewerKind.PLAIN_TEXT, (ViewerModel)viewerModel);
            if (t == null) {
                viewer.setJsonText(Jsons.toPrettyString((JsonObject)Jsons.toJson((String)text)));
                viewer.enableTextFormatControlsProperty().set(true);
            } else {
                viewer.setText(t.getMessage());
            }
            FxPlatform.RunFxThread(() -> ViewerContainer.createAndShow((Viewer)viewer));
        });
    }

    private void initializeEvents() {
        this.rectangleBackground.addEventHandler(MouseEvent.MOUSE_CLICKED, this::handleUnselectNodes);
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::handleDesktopPanningBegin);
        this.addEventFilter(DragEvent.DRAG_OVER, this::handleUILinkDragging);
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this::handleDesktopPanningEnd);
    }

    private void initializeSelectionGroup() {
        this.selectionGroup = new UIDesktopSelectionGroup();
        this.selectionGroup.setRootGroup(this.groupElements);
        this.selectionGroup.setBackground(this.rectangleBackground);
    }

    private void initializeDragLink() {
        this.dragLink.getStyleClass().add((Object)"ui-link");
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @FXML
    void onZoomInClick(ActionEvent event) {
        this.zoomIn();
    }

    @FXML
    void onZoomOutClick(ActionEvent event) {
        this.zoomOut();
    }

    @FXML
    void onRootKeyReleased(KeyEvent event) {
        this.handleDesktopRootPaneKeyEvent(event);
    }

    @Subscribe
    public void onStareProjectPrepareToSave(StareProjectPrepareToSave event) {
        this.saveDesktopProjectPreference(app.getProject());
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        long t0 = System.currentTimeMillis();
        Project project = event.getProject();
        List nodes = project.getModels().stream().map(model -> nodeStorage.findFirst(model.getUuid())).filter(Optional::isPresent).map(Optional::get).map(StareNode::getNode).collect(Collectors.toList());
        long t1 = System.currentTimeMillis();
        Platform.runLater(() -> {
            long t2 = System.currentTimeMillis();
            this.removeAllNodes();
            if (nodes.size() > 0) {
                nodes.forEach(node -> {
                    try {
                        this.groupElements.getChildren().add(node);
                    }
                    catch (Throwable t) {
                        System.err.println(String.format("Failed add node %s: %s, %s", t.getMessage(), node.getClass().getName(), node.getId()));
                    }
                });
            }
            long t3 = System.currentTimeMillis();
            double scale = project.getRoot().getScale();
            double desktopScrollH = project.getRoot().getDesktop().getScrollH();
            double desktopScrollV = project.getRoot().getDesktop().getScrollV();
            this.groupElements.setScaleX(scale);
            this.groupElements.setScaleY(scale);
            if (desktopScrollH >= 0.0 && desktopScrollV >= 0.0) {
                this.scrollPane.setVvalue(desktopScrollV);
                this.scrollPane.setHvalue(desktopScrollH);
            }
            long t4 = System.currentTimeMillis();
            this.requestFocus();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded project find add nodes %d ms", t1 - t0));
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded waiting run later %d ms", t2 - t1));
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded remove all / add nodes %d ms", t3 - t2));
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded group set scale %d ms", t4 - t3));
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded request focus %d ms", System.currentTimeMillis() - t4));
                this.logger.debug((Object)String.format("[Profiler] Desktop.onStareProjectLoaded %d ms", System.currentTimeMillis() - t0));
            }
        });
    }

    @Subscribe
    public void onNewNodeAdded(NewNodeAdded event) {
        StareNode node = event.getNode();
        FxPlatform.RunFxThread(() -> this.addNode(node));
        FxPlatform.RunFxThread(() -> ((Desktop)this).requestFocus());
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
        FxPlatform.RunFxThread(() -> {
            List<StareNode> selected = event.getSelected();
            this.updateStyleOfSelectedNodeAndConnectedLinks(selected);
            if (selected.size() == 0) {
                this.selectionGroup.clear();
            } else {
                this.selectionGroup.setObjects(selected);
            }
        });
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        FxPlatform.RunFxThread(() -> {
            String searchId = event.getUuid().toString();
            this.groupElements.getChildren().removeIf(node -> {
                String id = node.getId();
                if (id != null) {
                    return id.equals(searchId);
                }
                return false;
            });
        });
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public static WritableImage getDefaultEmptyImage() {
        Image empty = new Image(Desktop.class.getResourceAsStream("empty-image.jpg"));
        return new WritableImage(empty.getPixelReader(), (int)empty.getWidth(), (int)empty.getHeight());
    }

    public static WritableImage getDefaultMultichannelImage() {
        Image empty = new Image(Desktop.class.getResourceAsStream("multichannel-image.jpg"));
        return new WritableImage(empty.getPixelReader(), (int)empty.getWidth(), (int)empty.getHeight());
    }

    public Point2D getDesktopCenter() {
        double centerX = 0.5 * this.scrollPane.getWidth();
        double centerY = 0.5 * this.scrollPane.getHeight();
        return this.getDesktopCoordinate(centerX, centerY);
    }

    private Point2D getDesktopCoordinate(double x, double y) {
        double scale = app.getProject() != null ? app.getProject().getRoot().getScale() : 1.0;
        double maxWidth = this.rectangleBackground.getWidth();
        double maxHeight = this.rectangleBackground.getHeight();
        double width = this.scrollPane.getWidth() / scale;
        double height = this.scrollPane.getHeight() / scale;
        double h = this.scrollPane.getHvalue();
        double v = this.scrollPane.getVvalue();
        double xMin = (maxWidth - width) * h;
        double yMin = (maxHeight - height) * v;
        double desktopX = xMin + x / scale;
        double desktopY = yMin + y / scale;
        return new Point2D(desktopX, desktopY);
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.cornerScroll.disableScroll();
    }

    public double getScaleFactor() {
        return 1.25;
    }

    public double getMaxScale() {
        return 8.0;
    }

    public double getMinScale() {
        return 0.2;
    }

    public CubicCurve getDragLink() {
        return this.dragLink;
    }

    public void setAnchorToDrag(UILinkAnchor anchor) {
        this.anchorToDrag = anchor;
    }

    public UILinkAnchor getAnchorToDrag() {
        return this.anchorToDrag;
    }

    public void removeUILinkAnchor(UILinkAnchor anchor) {
        if (this.anchorToDrag == anchor) {
            this.anchorToDrag = null;
        }
    }

    public void changeViewportFocus(Point2D scrollerOffset, Bounds nodeBounds) {
        this.changeViewportFocus(this.scrollPane, app.getProject().getRoot().getScale(), scrollerOffset, nodeBounds);
    }

    public Point2D nodeToGroup(Node node, ConvertStrategy strategy) {
        double scale = app.getProject().getRoot().getScale();
        Bounds boundsGroup = this.groupElements.localToScene(this.groupElements.getBoundsInLocal());
        Bounds boundsNode = node.localToScene(node.getBoundsInLocal());
        double groupX = 0.0;
        double groupY = 0.0;
        double nodeX = 0.0;
        double nodeY = 0.0;
        groupX = boundsGroup.getMinX();
        groupY = boundsGroup.getMinY();
        switch (strategy.ordinal()) {
            case 0: {
                nodeX = boundsNode.getMinX();
                nodeY = boundsNode.getMinY();
                break;
            }
            case 1: {
                nodeX = boundsNode.getMaxX();
                nodeY = boundsNode.getMaxY();
                break;
            }
            case 2: {
                nodeX = boundsNode.getMinX();
                nodeY = boundsNode.getMinY() + (boundsNode.getMaxY() - boundsNode.getMinY()) * 0.5;
                break;
            }
            case 3: {
                nodeX = boundsNode.getMaxX();
                nodeY = boundsNode.getMinY() + (boundsNode.getMaxY() - boundsNode.getMinY()) * 0.5;
                break;
            }
            case 4: {
                nodeX = boundsNode.getMinX() + (boundsNode.getMaxX() - boundsNode.getMinX()) * 0.5;
                nodeY = boundsNode.getMinY() + (boundsNode.getMaxY() - boundsNode.getMinY()) * 0.5;
            }
        }
        return new Point2D((nodeX - groupX) / scale, (nodeY - groupY) / scale);
    }

    private void handleDesktopRootPaneKeyEvent(KeyEvent event) {
        boolean isConsumed = true;
        switch (event.getCode()) {
            case DELETE: {
                UserAction.deleteSelectedObjects(true);
                break;
            }
            case X: {
                if (!event.isControlDown()) break;
                this.cutChainToClipboard();
                break;
            }
            case C: {
                if (!event.isControlDown()) break;
                this.copyChainToClipboard();
                break;
            }
            case V: {
                if (!event.isControlDown()) break;
                Point2D center = this.getDesktopCenter();
                this.pasteChainFromClipboard(center.getX(), center.getY());
                break;
            }
            case A: {
                if (!event.isControlDown()) break;
                UserAction.selectAllNodes();
                break;
            }
            default: {
                isConsumed = false;
            }
        }
        if (isConsumed) {
            event.consume();
        }
    }

    private void cutChainToClipboard() {
        this.runIndicator.progress(StareClipboard.cutSelectedObjects(), "Cut...").whenComplete((v, t) -> {
            if (t != null) {
                String error = String.format("Failed cut selected objects: %s", t.getMessage());
                this.logger.warn((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        });
    }

    private void copyChainToClipboard() {
        System.out.println("ctrl+C");
        this.runIndicator.progress(StareClipboard.copySelectedObjects(), "Copy...").whenComplete((v, t) -> {
            if (t != null) {
                String error = String.format("Failed copy selected objects: %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        });
    }

    private void pasteChainFromClipboard(double x, double y) {
        this.runIndicator.progress(StareClipboard.pasteObjects(x, y), "Paste...").whenComplete((v, t) -> {
            if (t != null) {
                String error = String.format("Failed past objects: %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        });
    }

    private void handleDesktopPanningBegin(MouseEvent event) {
        if (!this.dragLink.isVisible()) {
            app.setDesktopDragging(true);
        }
    }

    private void handleDesktopPanningEnd(ContextMenuEvent event) {
        app.setDesktopDragging(false);
    }

    private void handleUILinkDragging(DragEvent event) {
        Point2D currentPoint = this.groupElements.sceneToLocal(event.getSceneX(), event.getSceneY());
        Point2D startPoint = new Point2D(this.dragLink.getStartX(), this.dragLink.getStartY());
        Connection.setUpLink(this.dragLink, startPoint, currentPoint);
        if (this.anchorToDrag != null) {
            this.anchorToDrag.setLayoutX(currentPoint.getX());
            this.anchorToDrag.setLayoutY(currentPoint.getY());
            this.anchorToDrag.getConnectedLinks().forEach(Connection::render);
        }
    }

    private void handleUnselectNodes(MouseEvent event) {
        EventTarget target = event.getTarget();
        if (!(target instanceof Node)) {
            return;
        }
        Node node = (Node)target;
        String id = node.getId();
        if (id == null) {
            return;
        }
        if (!id.equals(ID_NODE_BACKGROUND)) {
            return;
        }
        switch (event.getButton()) {
            case PRIMARY: {
                if (event.getClickCount() != 1 || !event.isStillSincePress()) break;
                UserAction.unselectedNodes();
                app.setIntrospectObject(null);
                this.selectionGroup.clear();
                return;
            }
        }
        event.consume();
    }

    private void disableDefaultHomeEndScrollActions(KeyEvent event) {
        boolean eventConsume = false;
        switch (event.getCode()) {
            case HOME: 
            case END: {
                eventConsume = true;
            }
        }
        if (eventConsume) {
            event.consume();
        }
    }

    private void zoomIn() {
        this.zoom(1.25);
    }

    private void zoomOut() {
        this.zoom(0.8);
    }

    private void zoom(double scaleFactor) {
        double scale = app.getProject().getRoot().getScale();
        if (!this.isScaleAllowed(scale *= scaleFactor)) {
            return;
        }
        app.getProject().getRoot().setScale(scale);
        Point2D scrollOffset = Zoomer.figureScrollOffset((Node)this.groupScrollPane, this.scrollPane);
        this.groupElements.setScaleX(scale);
        this.groupElements.setScaleY(scale);
        Zoomer.repositionScroller((Node)this.groupScrollPane, this.scrollPane, scaleFactor, scrollOffset);
    }

    private boolean isScaleAllowed(double scale) {
        return this.getMinScale() <= scale && scale <= this.getMaxScale();
    }

    private void updateStyleOfSelectedNodeAndConnectedLinks(List<StareNode> selected) {
        LinkedList connectedLinks = new LinkedList();
        LinkedList detachedLinks = new LinkedList();
        HashSet connectedBlocks = new HashSet();
        nodeStorage.find(Connection.class).forEach(connection -> {
            connection.getStyleClass().removeAll((Object[])new String[]{"connected"});
            AtomicBoolean isConnected = new AtomicBoolean(false);
            UUID srcUuid = ((ConnectionModel)connection.getNodeModel()).getSrcPortUuid();
            UUID destUuid = ((ConnectionModel)connection.getNodeModel()).getDestPortUuid();
            nodeStorage.findFirst(srcUuid).ifPresent(stareNode -> {
                if (UILinkAnchor.class.isAssignableFrom(stareNode.getClass())) {
                    detachedLinks.add(connection);
                } else if (UIPort.class.isAssignableFrom(stareNode.getClass())) {
                    UIBlock neighborBlock = ((UIPort)stareNode).getUIBlock();
                    if (selected.stream().anyMatch(node -> node.getUuid().equals(neighborBlock.getUuid()))) {
                        connectedBlocks.add(neighborBlock);
                        isConnected.set(true);
                    }
                }
            });
            if (!isConnected.get()) {
                nodeStorage.findFirst(destUuid).ifPresent(stareNode -> {
                    if (UILinkAnchor.class.isAssignableFrom(stareNode.getClass())) {
                        detachedLinks.add(connection);
                    } else if (UIPort.class.isAssignableFrom(stareNode.getClass())) {
                        UIBlock neighborBlock = ((UIPort)stareNode).getUIBlock();
                        if (selected.stream().anyMatch(node -> node.getUuid().equals(neighborBlock.getUuid()))) {
                            connectedBlocks.add(neighborBlock);
                            isConnected.set(true);
                        }
                    }
                });
            }
            if (isConnected.get()) {
                connection.getStyleClass().add((Object)"connected");
                connectedLinks.add(connection);
            } else {
                connection.toFront();
            }
        });
        nodeStorage.find(UIBlock.class).forEach(uiBlock1 -> {
            Node node = uiBlock1.getNode();
            node.getStyleClass().removeAll((Object[])new String[]{"selected"});
            node.toFront();
        });
        connectedBlocks.forEach(uiBlock -> uiBlock.getNode().toFront());
        nodeStorage.find(UIComment.class).forEach(uiComment -> uiComment.getNode().toFront());
        selected.forEach(stareNode -> {
            if (UIBlock.class.isAssignableFrom(stareNode.getClass())) {
                UIBlock uiBlock = (UIBlock)stareNode;
                Node node = uiBlock.getNode();
                node.getStyleClass().add((Object)"selected");
                node.toFront();
            }
        });
        connectedLinks.forEach(Node::toFront);
        detachedLinks.forEach(Node::toFront);
        nodeStorage.find(UILinkAnchor.class).forEach(Node::toFront);
    }

    private void removeAllNodes() {
        this.groupElements.getChildren().removeIf(node -> {
            String id = node.getId();
            if (id == null) {
                return true;
            }
            return !id.equals(ID_NODE_BACKGROUND);
        });
    }

    private void changeViewportFocus(ScrollPane scroller, double scale, Point2D scrollerOffset, Bounds nodeBounds) {
        double viewPortWidth = scroller.getViewportBounds().getWidth();
        double viewPortHeight = scroller.getViewportBounds().getHeight();
        double Rw = this.rectangleBackground.getBoundsInParent().getWidth();
        double Rh = this.rectangleBackground.getBoundsInParent().getHeight();
        double hScroll = ((scrollerOffset.getX() + nodeBounds.getWidth() / 2.0) * scale - viewPortWidth / 2.0) / (Rw * scale - viewPortWidth);
        double vScroll = ((scrollerOffset.getY() + nodeBounds.getHeight() / 4.0) * scale - viewPortHeight / 2.0) / (Rh * scale - viewPortHeight);
        scroller.setHvalue(hScroll);
        scroller.setVvalue(vScroll);
    }

    private void addNode(StareNode stareNode) {
        Node node = stareNode.getNode();
        if (UIBlockContent.class.isAssignableFrom(node.getClass())) {
            this.addNewBlock(stareNode);
        } else if (UILink.class.isAssignableFrom(node.getClass())) {
            this.addNewUILink((UILink)stareNode);
        } else if (UILinkAnchor.class.isAssignableFrom(node.getClass())) {
            this.addNewUILinkAnchor((UILinkAnchor)stareNode);
        } else if (UICommentContent.class.isAssignableFrom(node.getClass())) {
            this.addNewUIComment(stareNode);
        } else if (SmartLink.class.isAssignableFrom(node.getClass())) {
            this.addNewSmartLink((SmartLink)stareNode);
        } else {
            System.out.println(String.format("Unknown javafx node: %s", node.getClass()));
        }
    }

    private void addNewBlock(StareNode stareNode) {
        Node node = stareNode.getNode();
        this.groupElements.getChildren().add((Object)node);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"UIBlock added to pane");
        }
        Point2D scrollPaneCenter = this.getDesktopCenter();
        double layoutX = scrollPaneCenter.getX();
        double layoutY = scrollPaneCenter.getY();
        Model model = stareNode.getNodeModel();
        if (UIBlockModel.class.isAssignableFrom(model.getClass())) {
            UIBlockModel uiBlockModel = (UIBlockModel)model;
            double x = uiBlockModel.getLayoutX();
            double y = uiBlockModel.getLayoutY();
            if (x > 0.0 && y > 0.0) {
                layoutX = x;
                layoutY = y;
            }
        }
        node.setLayoutX(layoutX);
        node.setLayoutY(layoutY);
    }

    private void addNewUILink(UILink uiLink) {
        boolean result = this.groupElements.getChildren().add((Object)uiLink);
        uiLink.render();
        assert (result) : "Group elements can't add new UILink component";
    }

    private void addNewUILinkAnchor(UILinkAnchor uiLinkAnchor) {
        this.groupElements.getChildren().add((Object)uiLinkAnchor);
    }

    private void addNewUIComment(StareNode stareNode) {
        Node node = stareNode.getNode();
        this.groupElements.getChildren().add((Object)node);
    }

    private void addNewSmartLink(SmartLink smartLink) {
        this.groupElements.getChildren().add((Object)smartLink);
        smartLink.render();
    }

    public void saveDesktopProjectPreference(Project project) {
        project.getRoot().setScale(this.groupElements.getScaleX());
        project.getRoot().getDesktop().setScrollH(this.scrollPane.getHvalue());
        project.getRoot().getDesktop().setScrollV(this.scrollPane.getVvalue());
    }

    public void setRunIndicator(FxRunIndicator runIndicator) {
        this.runIndicator = runIndicator;
    }

    public FxRunIndicator getRunIndicator() {
        return this.runIndicator;
    }

    private class CornerScroll
    extends AnimationTimer {
        private long lastVerticalFrame = 0L;
        private long lastHorizontalFrame = 0L;
        private boolean verticalScroll = false;
        private boolean horizontalScroll = false;
        static final double distanceThreshold = 20.0;
        private Direction verticalDirection;
        private Direction horizontalDirection;
        double hScrollFactor;
        double vScrollFactor;
        final double speedPixPerSecond = 500.0;
        final double nanoToSecFactor = 1.0E-9;

        CornerScroll() {
        }

        void initialize() {
            this.hScrollFactor = (Desktop.this.scrollPane.getHmax() - Desktop.this.scrollPane.getHmin()) / Desktop.this.rectangleBackground.getWidth();
            this.vScrollFactor = (Desktop.this.scrollPane.getVmax() - Desktop.this.scrollPane.getVmin()) / Desktop.this.rectangleBackground.getHeight();
        }

        private void startStop() {
            if (this.verticalScroll || this.horizontalScroll) {
                this.start();
            } else {
                this.stop();
            }
        }

        private void enableScroll(Direction direction) {
            switch (direction.ordinal()) {
                case 0: 
                case 1: {
                    this.verticalDirection = direction;
                    this.verticalScroll = true;
                    break;
                }
                case 2: 
                case 3: {
                    this.horizontalDirection = direction;
                    this.horizontalScroll = true;
                }
            }
            this.startStop();
        }

        private void disableVerticalScroll() {
            this.lastVerticalFrame = 0L;
            this.verticalScroll = false;
            this.startStop();
        }

        private void disableHorizontalScroll() {
            this.lastHorizontalFrame = 0L;
            this.horizontalScroll = false;
            this.startStop();
        }

        private void disableScroll() {
            this.disableVerticalScroll();
            this.disableHorizontalScroll();
        }

        void disableScroll(DragEvent event) {
            this.disableScroll();
        }

        void disableScroll(MouseEvent event) {
            this.disableScroll();
        }

        public void handle(long now) {
            double scrollDistance;
            double distancePixels;
            double speed;
            if (this.lastVerticalFrame == 0L) {
                this.lastVerticalFrame = now;
            }
            if (this.lastHorizontalFrame == 0L) {
                this.lastHorizontalFrame = now;
            }
            if (this.verticalScroll) {
                speed = 500.0 / app.getProject().getRoot().getScale();
                distancePixels = speed * (double)(now - this.lastVerticalFrame) * 1.0E-9;
                scrollDistance = distancePixels * this.hScrollFactor;
                Desktop.this.scrollPane.setVvalue(Desktop.this.scrollPane.getVvalue() + this.verticalDirection.factor * scrollDistance);
                this.lastVerticalFrame = now;
            }
            if (this.horizontalScroll) {
                speed = 500.0 / app.getProject().getRoot().getScale();
                distancePixels = speed * (double)(now - this.lastHorizontalFrame) * 1.0E-9;
                scrollDistance = distancePixels * this.vScrollFactor;
                Desktop.this.scrollPane.setHvalue(Desktop.this.scrollPane.getHvalue() + this.horizontalDirection.factor * scrollDistance);
                this.lastHorizontalFrame = now;
            }
        }

        void dragHandle(double mouseX, double mouseY) {
            double viewportWidth = Desktop.this.scrollPane.getViewportBounds().getWidth();
            double viewportHeight = Desktop.this.scrollPane.getViewportBounds().getHeight();
            if (0.0 < mouseY && mouseY < 20.0) {
                Desktop.this.cornerScroll.enableScroll(Direction.UP);
            } else if (mouseY < viewportHeight && viewportHeight - mouseY < 20.0) {
                Desktop.this.cornerScroll.enableScroll(Direction.DOWN);
            } else {
                Desktop.this.cornerScroll.disableVerticalScroll();
            }
            if (0.0 < mouseX && mouseX < 20.0) {
                Desktop.this.cornerScroll.enableScroll(Direction.LEFT);
            } else if (mouseX < viewportWidth && viewportWidth - mouseX < 20.0) {
                Desktop.this.cornerScroll.enableScroll(Direction.RIGHT);
            } else {
                Desktop.this.cornerScroll.disableHorizontalScroll();
            }
        }

        void dragHandle(DragEvent event) {
            this.dragHandle(event.getX(), event.getY());
        }

        void dragHandle(MouseEvent event) {
            this.dragHandle(event.getX(), event.getY());
        }
    }

    public static enum ConvertStrategy {
        MIN,
        MAX,
        LEFT,
        RIGHT,
        CENTER;

    }

    static enum Direction {
        UP(-1.0),
        DOWN(1.0),
        LEFT(-1.0),
        RIGHT(1.0);

        private final double factor;

        private Direction(double factor) {
            this.factor = factor;
        }
    }
}

