/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.statistic.Duration;
import com.siams.cv.monitor.model.statistic.Statistic;
import java.util.UUID;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class FunctionStatistic {
    private IntegerProperty order;
    private StringProperty uuid;
    private StringProperty objectUuid;
    private StringProperty name;
    private DoubleProperty durationLast;
    private DoubleProperty durationAverage;
    private DoubleProperty durationMin;
    private DoubleProperty durationMax;
    private DoubleProperty durationRange;
    private StringProperty error;
    private StringProperty category;
    private long epoch = 0L;

    public String toString() {
        CharSequence[] info = new String[]{String.format("#: %d", this.order.intValue()), String.format("name: \"%s\"", this.name.getValueSafe()), String.format("uuid: \"%s\"", this.objectUuid.getValueSafe()), String.format("error: \"%s\"", this.error.getValueSafe())};
        return String.join((CharSequence)", ", info);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (IIdentifiable.class.isAssignableFrom(obj.getClass())) {
            return this.getObjectUuid().equals(((IIdentifiable)obj).getUuid());
        }
        return false;
    }

    public int hashCode() {
        return this.getObjectUuid().hashCode();
    }

    FunctionStatistic(Statistic stat) {
        this.uuid = this.createUuidProperty(stat);
        this.objectUuid = this.createObjectUuidProperty(stat);
        this.order = this.createOrderProperty(stat);
        this.name = this.createNameProperty(stat);
        this.error = this.createErrorProperty(stat);
        this.category = this.createCategoryProperty(stat);
        Duration duration = stat.getDuration();
        this.durationLast = this.createDurationLastProperty(duration);
        this.durationAverage = this.createDurationAverageProperty(duration);
        this.durationMin = this.createDurationMinProperty(duration);
        this.durationMax = this.createDurationMaxProperty(duration);
        this.durationRange = this.createDurationRangeProperty(duration);
    }

    private DoubleProperty createDurationLastProperty(Duration duration) {
        return new SimpleDoubleProperty(duration.getLast());
    }

    private DoubleProperty createDurationAverageProperty(Duration duration) {
        return new SimpleDoubleProperty(duration.getAverage());
    }

    private DoubleProperty createDurationMinProperty(Duration duration) {
        return new SimpleDoubleProperty(duration.getMin());
    }

    private DoubleProperty createDurationMaxProperty(Duration duration) {
        return new SimpleDoubleProperty(duration.getMax());
    }

    private DoubleProperty createDurationRangeProperty(Duration duration) {
        return new SimpleDoubleProperty(duration.getRange());
    }

    private IntegerProperty createOrderProperty(Statistic stat) {
        return new SimpleIntegerProperty(stat.getOrder());
    }

    private StringProperty createNameProperty(Statistic stat) {
        if (!stat.getSystemName().isEmpty()) {
            return new SimpleStringProperty(String.format("%s [%s]", stat.getName(), stat.getSystemName()));
        }
        return new SimpleStringProperty(stat.getName());
    }

    private StringProperty createUuidProperty(Statistic stat) {
        return new SimpleStringProperty(stat.getId());
    }

    private StringProperty createObjectUuidProperty(Statistic stat) {
        return new SimpleStringProperty(stat.getObjectId());
    }

    private StringProperty createErrorProperty(Statistic stat) {
        return new SimpleStringProperty(stat.getErrorMessage());
    }

    private StringProperty createCategoryProperty(Statistic stat) {
        return new SimpleStringProperty(stat.getCategory());
    }

    public StringProperty objectUuidProperty() {
        return this.objectUuid;
    }

    public UUID getObjectUuid() {
        return UUID.fromString((String)this.objectUuid.get());
    }

    public UUID getUuid() {
        return UUID.fromString((String)this.uuid.get());
    }

    public void setStatistic(Statistic stat) {
        if (this.epoch == 0L || this.epoch < stat.getModified()) {
            this.epoch = stat.getModified();
            Duration duration = stat.getDuration();
            this.order.setValue((Number)stat.getOrder());
            this.error.setValue(stat.getErrorMessage());
            this.category.setValue(stat.getCategory());
            this.durationLast.setValue((Number)(1000.0 * duration.getLast()));
            this.durationAverage.setValue((Number)(1000.0 * duration.getAverage()));
            this.durationMin.setValue((Number)(1000.0 * duration.getMin()));
            this.durationMax.setValue((Number)(1000.0 * duration.getMax()));
            this.durationRange.setValue((Number)(1000.0 * duration.getRange()));
        }
    }

    public IntegerProperty orderProperty() {
        return this.order;
    }

    public int getOrder() {
        return this.order.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return this.name.getValueSafe();
    }

    public StringProperty categoryProperty() {
        return this.category;
    }

    public String gtCategory() {
        return this.category.getValueSafe();
    }

    public double getDurationLast() {
        return this.durationLast.get();
    }

    public DoubleProperty durationLastProperty() {
        return this.durationLast;
    }

    public double getDurationAverage() {
        return this.durationAverage.get();
    }

    public DoubleProperty durationAverageProperty() {
        return this.durationAverage;
    }

    public double getDurationMin() {
        return this.durationMin.get();
    }

    public DoubleProperty durationMinProperty() {
        return this.durationMin;
    }

    public double getDurationMax() {
        return this.durationMax.get();
    }

    public DoubleProperty durationMaxProperty() {
        return this.durationMax;
    }

    public double getDurationRange() {
        return this.durationRange.get();
    }

    public DoubleProperty durationRangeProperty() {
        return this.durationRange;
    }

    public StringProperty errorProperty() {
        return this.error;
    }

    public String getError() {
        return this.error.getValueSafe();
    }
}

