/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoading;
import com.siams.cv.monitor.message.StatisticResultReady;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.content.container.FunctionStatistic;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxPlatform;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class FunctionsList
extends AnchorPane
implements Deletable {
    private final Logger logger = Logger.getLogger(FunctionsList.class);
    private static final App app = App.getInstance();
    private static final IIDStorage iidStorage = IIDStorage.getInstance();
    private static FunctionsList instance;
    private final Set<Statistic> throttleStatistics = new HashSet<Statistic>();
    private ObservableList<FunctionStatistic> data = FXCollections.observableArrayList();
    private FilteredList<FunctionStatistic> filteredData = new FilteredList(this.data);
    private SortedList<FunctionStatistic> sorterFilteredData = new SortedList(this.filteredData);
    final PublishSubject<Statistic> statisticSubject = PublishSubject.create();
    @FXML
    private ToggleButton buttonStatistics;
    @FXML
    private TableColumn<FunctionStatistic, Integer> columnOrder;
    @FXML
    private TableColumn<FunctionStatistic, String> columnObjectUuid;
    @FXML
    private TableColumn<FunctionStatistic, Double> columnDurationLast;
    @FXML
    private TableColumn<FunctionStatistic, Double> columnDurationAverage;
    @FXML
    private TableColumn<FunctionStatistic, Double> columnDurationMin;
    @FXML
    private TableColumn<FunctionStatistic, Double> columnDurationMax;
    @FXML
    private TableColumn<FunctionStatistic, Double> columnDurationRange;
    @FXML
    private TableColumn<FunctionStatistic, String> columnError;
    @FXML
    private TableColumn<FunctionStatistic, String> columnName;
    @FXML
    private TableColumn<FunctionStatistic, String> columnCategory;
    @FXML
    private TableView<FunctionStatistic> tableViewStatistic;
    @FXML
    private Button buttonClear;
    @FXML
    private Button buttonPrev;
    @FXML
    private Button buttonNext;
    @FXML
    private TextField textFieldFilter;

    public static FunctionsList getInstance() {
        if (instance == null) {
            instance = new FunctionsList();
        }
        return instance;
    }

    private FunctionsList() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/FunctionsList.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
            this.initializeTable();
            this.initializeColumns();
            this.initializeButtons();
            this.restorePreference();
            this.initializeFilter();
            this.initializeData();
            this.subscribe();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeData() {
        this.data.addListener(c -> {
            boolean disableButtons = this.data.size() <= 2;
            this.buttonPrev.setDisable(disableButtons);
            this.buttonNext.setDisable(disableButtons);
        });
    }

    private void initializeFilter() {
        this.textFieldFilter.setOnAction(e -> this.filteredData.setPredicate(statistic -> {
            String query = this.textFieldFilter.getText().toLowerCase();
            String id = statistic.getObjectUuid().toString().toLowerCase();
            String name = statistic.getName().toLowerCase();
            return id.contains(query) || name.contains(query);
        }));
    }

    private void initializeThrottling() {
        this.statisticSubject.throttleLatest(1L, TimeUnit.SECONDS, false).subscribe(o -> Platform.runLater(() -> {
            Set<Statistic> set = this.throttleStatistics;
            synchronized (set) {
                for (Statistic stat : this.throttleStatistics) {
                    FunctionStatistic functionStat = this.data.stream().filter(s -> s.getUuid().equals(stat.getUuid())).findFirst().orElseGet(() -> {
                        FunctionStatistic s = new FunctionStatistic(stat);
                        this.data.add((Object)s);
                        return s;
                    });
                    functionStat.setStatistic(stat);
                }
                this.throttleStatistics.clear();
            }
            this.tableViewStatistic.sort();
            if (this.buttonPrev.isDisable()) {
                this.buttonPrev.setDisable(false);
                this.buttonNext.setDisable(false);
            }
        }));
    }

    private void initializeColumns() {
        this.columnOrder.setCellValueFactory((Callback)new PropertyValueFactory("order"));
        this.columnCategory.setCellValueFactory((Callback)new PropertyValueFactory("category"));
        this.columnObjectUuid.setCellValueFactory((Callback)new PropertyValueFactory("objectUuid"));
        this.columnError.setCellValueFactory((Callback)new PropertyValueFactory("error"));
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnDurationLast.setCellValueFactory((Callback)new PropertyValueFactory("durationLast"));
        this.columnDurationAverage.setCellValueFactory((Callback)new PropertyValueFactory("durationAverage"));
        this.columnDurationMin.setCellValueFactory((Callback)new PropertyValueFactory("durationMin"));
        this.columnDurationMax.setCellValueFactory((Callback)new PropertyValueFactory("durationMax"));
        this.columnDurationRange.setCellValueFactory((Callback)new PropertyValueFactory("durationRange"));
        Callback customDoubleFormattingCellFactory = param -> new TableCell<FunctionStatistic, Double>(this){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    this.setText(String.format("%.1f", item));
                } else {
                    this.setText(null);
                }
            }
        };
        this.columnDurationLast.setCellFactory(customDoubleFormattingCellFactory);
        this.columnDurationAverage.setCellFactory(customDoubleFormattingCellFactory);
        this.columnDurationMin.setCellFactory(customDoubleFormattingCellFactory);
        this.columnDurationMax.setCellFactory(customDoubleFormattingCellFactory);
        this.columnDurationRange.setCellFactory(customDoubleFormattingCellFactory);
    }

    private void initializeTable() {
        MenuItem miDeleteBlock = new MenuItem("Delete");
        miDeleteBlock.setOnAction(e -> {
            FunctionStatistic selectedItem = (FunctionStatistic)this.tableViewStatistic.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            UUID id = selectedItem.getObjectUuid();
            Optional opt = NodeStorage.getInstance().findFirst(id);
            if (!opt.isPresent()) {
                throw new RuntimeException("Unimplemented");
            }
            UserAction.deleteObject((IIdentifiable)opt.get(), true);
        });
        MenuItem miCopyInformation = new MenuItem("Copy");
        miCopyInformation.setOnAction(e -> {
            FunctionStatistic item = (FunctionStatistic)this.tableViewStatistic.getSelectionModel().getSelectedItem();
            ClipboardContent content = new ClipboardContent();
            content.putString(item.toString());
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        MenuItem miCopyUuid = new MenuItem("Copy uuid");
        miCopyUuid.setOnAction(e -> {
            FunctionStatistic item = (FunctionStatistic)this.tableViewStatistic.getSelectionModel().getSelectedItem();
            ClipboardContent content = new ClipboardContent();
            content.putString(item.getObjectUuid().toString());
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        MenuItem miCopyError = new MenuItem("Copy error");
        miCopyError.setOnAction(e -> {
            FunctionStatistic item = (FunctionStatistic)this.tableViewStatistic.getSelectionModel().getSelectedItem();
            ClipboardContent content = new ClipboardContent();
            content.putString(item.getError());
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        ContextMenu menu = new ContextMenu(new MenuItem[]{miDeleteBlock, miCopyInformation, miCopyUuid, miCopyError});
        this.tableViewStatistic.setContextMenu(menu);
        this.tableViewStatistic.setItems(this.sorterFilteredData);
        this.tableViewStatistic.setEditable(false);
        this.sorterFilteredData.comparatorProperty().bind((ObservableValue)this.tableViewStatistic.comparatorProperty());
        this.tableViewStatistic.setOnMouseClicked(event -> {
            event.consume();
            if (event.getButton() == MouseButton.PRIMARY) {
                FunctionStatistic selectedStatisticEntry = (FunctionStatistic)this.tableViewStatistic.getFocusModel().getFocusedItem();
                if (selectedStatisticEntry == null) {
                    return;
                }
                UUID uid = selectedStatisticEntry.getObjectUuid();
                NodeStorage.getInstance().findFirst(uid, UIBlock.class).ifPresent(UserAction::focusObject);
            }
        });
        this.tableViewStatistic.setOnKeyReleased(event -> {
            boolean isConsume = true;
            switch (event.getCode()) {
                case DELETE: {
                    UserAction.deleteSelectedObjects(true);
                    break;
                }
                case UP: {
                    FunctionStatistic selectedStatisticEntry = (FunctionStatistic)this.tableViewStatistic.getFocusModel().getFocusedItem();
                    UUID uid = selectedStatisticEntry.getObjectUuid();
                    NodeStorage.getInstance().findFirst(uid, UIBlock.class).ifPresent(UserAction::focusObject);
                    break;
                }
                case DOWN: {
                    FunctionStatistic selectedStatisticEntry = (FunctionStatistic)this.tableViewStatistic.getFocusModel().getFocusedItem();
                    UUID uid = selectedStatisticEntry.getObjectUuid();
                    NodeStorage.getInstance().findFirst(uid, UIBlock.class).ifPresent(UserAction::focusObject);
                    break;
                }
                default: {
                    isConsume = false;
                }
            }
            if (isConsume) {
                event.consume();
            }
        });
    }

    private void initializeButtons() {
        this.buttonClear.setTooltip((Tooltip)new StareTooltip("Clear blocks table"));
        this.buttonPrev.setTooltip((Tooltip)new StareTooltip("Previous block"));
        this.buttonNext.setTooltip((Tooltip)new StareTooltip("Next block"));
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.savePreference();
        this.release();
    }

    @Subscribe
    public void onStatisticResultReady(StatisticResultReady event) {
        Statistic stat = event.getStatistic();
        FxPlatform.RunFxThread(() -> {
            FunctionStatistic functionStat = this.data.stream().filter(fs -> fs.getUuid().toString().equals(stat.getId())).findFirst().orElseGet(() -> {
                FunctionStatistic s = new FunctionStatistic(stat);
                this.data.add((Object)s);
                return s;
            });
            functionStat.setStatistic(stat);
        });
    }

    @Subscribe
    public void onStareProjectLoading(StareProjectLoading event) {
        this.clear();
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        FxPlatform.RunFxThread(() -> {
            UUID removedId = event.getUuid();
            this.data.removeIf(statistic -> statistic.getObjectUuid().equals(removedId));
        });
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
    }

    public void scrollToItem(UUID itemId) {
        FxPlatform.RunFxThread(() -> {
            ObservableList items = this.tableViewStatistic.getItems();
            int len = items.size();
            for (int i = 0; i < len; ++i) {
                if (!((FunctionStatistic)items.get(i)).getObjectUuid().equals(itemId)) continue;
                this.tableViewStatistic.getSelectionModel().select(i);
                this.tableViewStatistic.scrollTo(i);
            }
        });
    }

    @FXML
    void onButtonClearClick(ActionEvent event) {
        this.clear();
    }

    @FXML
    void onPreviousBlock(ActionEvent event) {
        int selectedStatisticIndex = this.tableViewStatistic.getFocusModel().getFocusedIndex();
        selectedStatisticIndex = selectedStatisticIndex == 0 ? this.tableViewStatistic.getItems().size() - 1 : --selectedStatisticIndex;
        FunctionStatistic selectedStatisticEntry = (FunctionStatistic)this.tableViewStatistic.getItems().get(selectedStatisticIndex);
        if (selectedStatisticEntry == null) {
            return;
        }
        UUID uid = selectedStatisticEntry.getObjectUuid();
        NodeStorage.getInstance().findFirst(uid, UIBlock.class).ifPresent(UserAction::focusObject);
    }

    @FXML
    void onNextBlock(ActionEvent event) {
        int selectedStatisticIndex = this.tableViewStatistic.getFocusModel().getFocusedIndex();
        selectedStatisticIndex = selectedStatisticIndex == this.tableViewStatistic.getItems().size() - 1 ? 0 : ++selectedStatisticIndex;
        FunctionStatistic selectedStatisticEntry = (FunctionStatistic)this.tableViewStatistic.getItems().get(selectedStatisticIndex);
        if (selectedStatisticEntry == null) {
            return;
        }
        UUID uid = selectedStatisticEntry.getObjectUuid();
        NodeStorage.getInstance().findFirst(uid, UIBlock.class).ifPresent(UserAction::focusObject);
    }

    public ObservableList<FunctionStatistic> getData() {
        return this.data;
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void clear() {
        List<UUID> ids = this.data.stream().map(FunctionStatistic::getUuid).collect(Collectors.toList());
        this.data.clear();
        ids.forEach(App::rqRemoveStatistic);
    }

    private void restorePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(FunctionsList.class);
            String orderColumnId = preferences.get("orderColumn.id", "columnOrder");
            String orderColumnSortType = preferences.get("orderColumn.sortType", "ASCENDING");
            this.columnOrder.setPrefWidth(Double.parseDouble(preferences.get("columnOrder.width", "50")));
            this.columnObjectUuid.setPrefWidth(Double.parseDouble(preferences.get("columnUuid.width", "50")));
            this.columnDurationAverage.setPrefWidth(Double.parseDouble(preferences.get("executionAverage.width", "75")));
            this.columnDurationMin.setPrefWidth(Double.parseDouble(preferences.get("columnDurationMin.width", "75")));
            this.columnDurationMax.setPrefWidth(Double.parseDouble(preferences.get("columnDurationMax.width", "75")));
            this.columnDurationRange.setPrefWidth(Double.parseDouble(preferences.get("columnDurationRange.width", "75")));
            this.columnError.setPrefWidth(Double.parseDouble(preferences.get("columnError.width", "250")));
            this.columnName.setPrefWidth(Double.parseDouble(preferences.get("columnName.width", "100")));
            this.columnCategory.setPrefWidth(Double.parseDouble(preferences.get("columnCategory.width", "100")));
            this.tableViewStatistic.getColumns().stream().filter(column -> column.getId().equals(orderColumnId)).findFirst().ifPresent(column -> {
                column.setSortType(TableColumn.SortType.valueOf((String)orderColumnSortType));
                this.tableViewStatistic.getSortOrder().clear();
                this.tableViewStatistic.getSortOrder().add(column);
            });
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void savePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(FunctionsList.class);
            ObservableList orders = this.tableViewStatistic.getSortOrder();
            if (orders.size() == 1) {
                TableColumn orderColumn = (TableColumn)orders.get(0);
                preferences.put("orderColumn.id", orderColumn.getId());
                preferences.put("orderColumn.sortType", orderColumn.getSortType().toString());
            }
            preferences.put("columnOrder.width", String.valueOf(this.columnOrder.getWidth()));
            preferences.put("columnUuid.width", String.valueOf(this.columnObjectUuid.getWidth()));
            preferences.put("columnDurationAverage.width", String.valueOf(this.columnDurationAverage.getWidth()));
            preferences.put("columnDurationMin.width", String.valueOf(this.columnDurationMin.getWidth()));
            preferences.put("columnDurationMax.width", String.valueOf(this.columnDurationMax.getWidth()));
            preferences.put("columnDurationRange.width", String.valueOf(this.columnDurationRange.getWidth()));
            preferences.put("columnError.width", String.valueOf(this.columnError.getWidth()));
            preferences.put("columnName.width", String.valueOf(this.columnName.getWidth()));
            preferences.put("columnCategory.width", String.valueOf(this.columnCategory.getWidth()));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

