/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

class NodeStorageLog
extends AnchorPane {
    private static NodeStorageLog instance;
    private static final NodeStorage nodeStorage;
    private ObservableList<NodeItem> data = FXCollections.observableArrayList();
    private FilteredList<NodeItem> filteredData = new FilteredList(this.data, s -> true);
    @FXML
    private TableView<NodeItem> tableView;
    @FXML
    private TableColumn<NodeItem, String> columnValue;
    @FXML
    private Button buttonUpdate;
    @FXML
    private TextField textFieldFilter;

    @FXML
    void onButtonUpdateClick(ActionEvent event) {
        this.data.clear();
        nodeStorage.getAll().forEach(node -> {
            NodeItem item = new NodeItem(this);
            item.setName(String.format("%s, uuid: %s", node.getClass(), node.getUuid().toString()));
            this.data.add((Object)item);
        });
    }

    @FXML
    void onFilterChange(ActionEvent event) {
        this.filteredData.setPredicate(item -> item.getName().toLowerCase().contains(this.textFieldFilter.getText().toLowerCase()));
    }

    public static NodeStorageLog getInstance() {
        if (instance == null) {
            instance = new NodeStorageLog();
        }
        return instance;
    }

    private NodeStorageLog() {
        this.initialize();
    }

    private void initialize() {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/com/siams/cv/monitor/ui/content/container/NodeStorageLog.fxml");
            CustomFXMLLoader.loadElement((Object)((Object)this), (URL)url);
            this.initializeTable();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeTable() {
        this.tableView.setItems(this.filteredData);
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("name"));
    }

    static {
        nodeStorage = NodeStorage.getInstance();
    }

    public class NodeItem {
        private StringProperty name = new SimpleStringProperty((Object)this, "");

        public void setName(String value) {
            this.nameProperty().set((Object)value);
        }

        public String getName() {
            return (String)this.nameProperty().get();
        }

        NodeItem(NodeStorageLog this$0) {
        }

        public StringProperty nameProperty() {
            return this.name;
        }
    }
}

