/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.controls.autobox.AutoBox;
import com.siams.controls.autobox.AutoBoxConverter;
import com.siams.controls.autobox.AutoBoxFilterPredicateBuilder;
import com.siams.controls.autobox.AutoBoxItemNodeBuilder;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.controlsfx.control.CheckComboBox;

final class UILibraryFilter
extends GridPane
implements Deletable,
UIPreference {
    @FXML
    private Button btnClearSearchQuery;
    @FXML
    private Button btnScrollToModel;
    @FXML
    private Button btnClearSearchMode;
    @FXML
    private ToggleButton tbExpandFilter;
    @FXML
    private HBox hBoxQueryInputContainer;
    @FXML
    private Button btnShowItems;
    @FXML
    private ComboBox<SearchMode> cbSearchMode;
    private CheckComboBox<String> ccbTagNames;
    private AutoBoxFunctions abFunctions;
    private Consumer<WorkerType> modelSelectedListener = null;
    private FilterChangeListener filterChangeListener = null;

    UILibraryFilter() {
        this.initialize();
    }

    private void initialize() {
        this.initializeRoot();
        this.initializeControls();
    }

    private void initializeRoot() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initializeControls() {
        this.initializeToggleButtonExpandFilter();
        this.initializeAutoBoxFunctions();
        this.initializeComboBoxSearchMode();
        this.initializeCheckComboBoxTagNames();
        this.initializeButtonClearQuery();
        this.initializeButtonClearSearchMode();
        this.initializeButtonScrollTo();
        this.initializeButtonShowItems();
    }

    private void initializeToggleButtonExpandFilter() {
        this.tbExpandFilter.setOnAction(event -> this.showExtendedSearch(this.tbExpandFilter.isSelected()));
        this.tbExpandFilter.setTooltip((Tooltip)new StareTooltip("Show/Hide search options"));
    }

    private void initializeAutoBoxFunctions() {
        this.abFunctions = new AutoBoxFunctions();
        this.abFunctions.setMaxVisibleResults(20);
        this.abFunctions.setPromptText("Functions search...");
        this.abFunctions.addItemChangeListener(selectedModel -> {
            if (this.modelSelectedListener != null) {
                this.modelSelectedListener.accept((WorkerType)selectedModel);
            }
        });
        this.hBoxQueryInputContainer.getChildren().add(0, (Object)this.abFunctions);
        HBox.setHgrow((Node)this.abFunctions, (Priority)Priority.ALWAYS);
    }

    private void initializeComboBoxSearchMode() {
        this.cbSearchMode.getItems().addAll((Object[])SearchMode.values());
        this.cbSearchMode.setValue((Object)SearchMode.ANY_OF);
        this.cbSearchMode.setOnAction(event -> {
            if (this.filterChangeListener != null) {
                this.filterChangeListener.onFilterChange(this.getSearchMode(), this.getSelectedTagNames());
            }
        });
        this.cbSearchMode.setTooltip((Tooltip)new StareTooltip("Select search mode"));
    }

    private void initializeCheckComboBoxTagNames() {
        this.ccbTagNames = new CheckComboBox();
        this.ccbTagNames.setMinWidth(-1.0);
        this.ccbTagNames.setMinHeight(-1.0);
        this.ccbTagNames.setPrefWidth(-1.0);
        this.ccbTagNames.setPrefHeight(-1.0);
        this.ccbTagNames.setMaxWidth(Double.MAX_VALUE);
        this.ccbTagNames.setMaxHeight(-1.0);
        this.add((Node)this.ccbTagNames, 1, 1);
        this.ccbTagNames.getCheckModel().getCheckedItems().addListener(c -> {
            if (this.filterChangeListener != null) {
                this.filterChangeListener.onFilterChange(this.getSearchMode(), this.getSelectedTagNames());
            }
        });
    }

    private void initializeButtonClearQuery() {
        this.btnClearSearchQuery.setOnAction(event -> this.clearSearchQuery());
        this.btnClearSearchQuery.setTooltip((Tooltip)new StareTooltip("Clear search query"));
    }

    private void initializeButtonClearSearchMode() {
        this.btnClearSearchMode.setOnAction(event -> this.clearSearchMode());
        this.btnClearSearchMode.setTooltip((Tooltip)new StareTooltip("Clear filter tags"));
    }

    private void initializeButtonScrollTo() {
        this.btnScrollToModel.setOnAction(event -> UserAction.scrollToModel());
        this.btnScrollToModel.setTooltip((Tooltip)new StareTooltip("Scroll to current selected model (F7)"));
    }

    private void initializeButtonShowItems() {
        this.btnShowItems.setOnAction(event -> this.abFunctions.showItemsList());
        this.btnShowItems.setTooltip((Tooltip)new StareTooltip("Show items"));
    }

    public void clearSearchMode() {
        this.ccbTagNames.getCheckModel().clearChecks();
    }

    public void clearSearchQuery() {
        this.abFunctions.clear();
    }

    public void setFocus(UserAction.Focus focus) {
        switch (focus) {
            case REGISTERED_COMPONENT_FILTER: {
                this.abFunctions.requestFocus();
            }
        }
    }

    public void setFilterChangeListener(FilterChangeListener filterChangeListener) {
        this.filterChangeListener = filterChangeListener;
    }

    public SearchMode getSearchMode() {
        return (SearchMode)((Object)this.cbSearchMode.getValue());
    }

    public List<String> getSelectedTagNames() {
        return this.ccbTagNames.getCheckModel().getCheckedItems();
    }

    public void restorePreference() {
    }

    public void savePreference() {
    }

    @Override
    public void release() {
    }

    void setDataProcessModels(List<WorkerType> models) {
        this.abFunctions.getItems().clear();
        this.abFunctions.getItems().addAll(models);
        TreeSet tagNames = new TreeSet();
        models.forEach(model -> tagNames.addAll(model.getStructure().getTags()));
        this.ccbTagNames.getItems().clear();
        this.ccbTagNames.getItems().setAll(tagNames);
    }

    void setModelSelectedListener(Consumer<WorkerType> listener) {
        this.modelSelectedListener = listener;
    }

    void addTags(List<String> extraTags) {
        for (String tag : extraTags) {
            this.ccbTagNames.getCheckModel().check((Object)tag);
        }
    }

    void clearTags(List<String> excessTags) {
        for (String tag : excessTags) {
            this.ccbTagNames.getCheckModel().clearCheck((Object)tag);
        }
    }

    private void showExtendedSearch(boolean value) {
        this.cbSearchMode.setVisible(value);
        this.cbSearchMode.setManaged(value);
        this.ccbTagNames.setVisible(value);
        this.ccbTagNames.setManaged(value);
        this.btnClearSearchMode.setVisible(value);
        this.btnClearSearchMode.setManaged(value);
    }

    static interface FilterChangeListener {
        public void onFilterChange(SearchMode var1, List<String> var2);
    }

    private class AutoBoxFunctions
    extends AutoBox<WorkerType>
    implements AutoBoxConverter<WorkerType>,
    AutoBoxFilterPredicateBuilder<WorkerType>,
    AutoBoxItemNodeBuilder<WorkerType> {
        AutoBoxFunctions() {
            this.setFilteredPredicate(this);
            this.setModelConverter(this);
            this.setNodeBuilder(this);
        }

        public String modelToString(WorkerType model) {
            return model.getStructure().getCorrectedName();
        }

        public Predicate<WorkerType> build(String query) {
            return model -> {
                Set modelTags = model.getStructure().getTags();
                SearchMode searchMode = (SearchMode)((Object)((Object)UILibraryFilter.this.cbSearchMode.getSelectionModel().getSelectedItem()));
                if (!UILibraryFilter.this.ccbTagNames.getCheckModel().isEmpty()) {
                    ObservableList selectedTags = UILibraryFilter.this.ccbTagNames.getCheckModel().getCheckedItems();
                    switch (searchMode.ordinal()) {
                        case 1: {
                            boolean noneMatch = selectedTags.stream().noneMatch(modelTags::contains);
                            if (!noneMatch) break;
                            return false;
                        }
                        case 0: {
                            if (modelTags.containsAll((Collection<?>)selectedTags)) break;
                            return false;
                        }
                    }
                }
                String whatToFind = query.toLowerCase();
                String modelName = model.getStructure().getName();
                String languageDetails = model.getStructure().getLanguageDetails();
                return modelName.toLowerCase().contains(whatToFind) || languageDetails != null && languageDetails.toLowerCase().contains(whatToFind);
            };
        }

        public Node build(WorkerType model) {
            Label modelName = new Label(model.getStructure().getName());
            Label packageName = new Label(model.getStructure().getCorrectedCategory());
            packageName.setFont(Font.font((double)10.0));
            packageName.setTextFill((Paint)Color.GRAY);
            return new VBox(new Node[]{modelName, packageName});
        }

        void showItemsList() {
            String query = this.getText();
            if (!query.isEmpty()) {
                this.displayResult(this.filter(query));
            }
        }

        protected List<WorkerType> filter(String query) {
            String queryLowerCase = query.toLowerCase();
            ArrayList<WorkerType> sorted = new ArrayList<WorkerType>(super.filter(query));
            sorted.sort((o1, o2) -> {
                boolean isStartWithQuery2;
                String name1 = o1.getStructure().getName().toLowerCase();
                String name2 = o2.getStructure().getName().toLowerCase();
                boolean isStartWithQuery1 = name1.startsWith(queryLowerCase);
                if (isStartWithQuery1 != (isStartWithQuery2 = name2.startsWith(queryLowerCase))) {
                    return isStartWithQuery1 ? -1 : 1;
                }
                return name1.compareToIgnoreCase(name2);
            });
            return sorted;
        }
    }

    public static enum SearchMode {
        ALL_OF,
        ANY_OF;

    }
}

