/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.GlobalHotKeys;
import com.siams.cv.monitor.message.NodeModelChanged;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectPrepareToSave;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.IViewerContainer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ViewerContainer
implements IViewerContainer,
UIPreference {
    private Stage window;
    private Scene scene;
    private ViewerContainerContent root;
    private Viewer viewer;
    private WindowShowing windowShowing;

    public static void createAndShow(Viewer viewer) {
        ViewerContainer container = new ViewerContainer();
        container.initialize();
        ViewerModel viewerModel = viewer.getViewerModel();
        viewerModel.setShowing(true);
        viewerModel.setReleaseCallback(container::release);
        viewerModel.setToFrontCallback(() -> {
            container.window.setIconified(false);
            container.window.setAlwaysOnTop(true);
            container.window.setAlwaysOnTop(false);
            container.window.requestFocus();
        });
        container.setViewer((Viewer<? extends ViewerModel>)viewer);
        container.show();
    }

    protected ViewerContainer() {
    }

    protected void initialize() {
        this.initializeShowingProperty();
        this.initializeWindow();
        this.setTitle(this.viewer != null ? this.viewer.getTitle() : "");
        this.initializeContent(this.viewer);
        this.initializeView();
        this.initializeControls();
        this.restorePreference();
        this.subscribe();
    }

    private void initializeShowingProperty() {
        this.windowShowing = new WindowShowing();
    }

    private void initializeWindow() {
        this.window = this.createWindow("");
        this.window.setMinWidth(100.0);
        this.window.setMinHeight(100.0);
    }

    private Stage createWindow(String title) {
        Stage window = new Stage();
        window.setTitle(title);
        window.initModality(Modality.NONE);
        window.setResizable(true);
        window.initStyle(StageStyle.DECORATED);
        window.setOnCloseRequest(event -> this.savePreference());
        window.showingProperty().addListener((ChangeListener)this.windowShowing);
        return window;
    }

    private void initializeContent(Viewer viewer) {
        this.root = new ViewerContainerContent();
        if (viewer != null) {
            this.viewer = viewer;
            viewer.embed((Pane)this.root.apViewerPlace);
        }
        this.scene = new Scene((Parent)this.root);
        this.scene.getStylesheets().add((Object)"viewer-container.css");
        GlobalHotKeys.initializeGlobalHotKeys(this.scene);
    }

    private void initializeControls() {
        this.root.tbPinUnpin.getStyleClass().add((Object)"unpinned");
        this.root.tbPinUnpin.selectedProperty().addListener((ob, o, pinned) -> {
            this.setButtonStyle((boolean)pinned);
            this.rebuildWindow((boolean)pinned);
        });
    }

    private void setButtonStyle(boolean pinned) {
        if (pinned) {
            this.root.tbPinUnpin.getStyleClass().remove((Object)"unpinned");
            this.root.tbPinUnpin.getStyleClass().add((Object)"pinned");
        } else {
            this.root.tbPinUnpin.getStyleClass().add((Object)"unpinned");
            this.root.tbPinUnpin.getStyleClass().remove((Object)"pinned");
        }
    }

    private void rebuildWindow(boolean pinned) {
        Stage currentWindow = this.window;
        double x = currentWindow.getX();
        double y = currentWindow.getY();
        double width = currentWindow.getWidth();
        double height = currentWindow.getHeight();
        Stage newWindow = this.createWindow(currentWindow.getTitle());
        if (pinned) {
            newWindow.initOwner((Window)App.getInstance().getMainStage());
        }
        newWindow.setX(x);
        newWindow.setY(y);
        newWindow.setWidth(width);
        newWindow.setHeight(height);
        newWindow.setScene(this.scene);
        newWindow.show();
        currentWindow.showingProperty().removeListener((ChangeListener)this.windowShowing);
        currentWindow.close();
        this.window = newWindow;
    }

    private void initializeView() {
        this.window.setScene(this.scene);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public void setTitle(String title) {
        this.window.setTitle(title);
    }

    public String getTitle() {
        return this.window.getTitle();
    }

    public void show() {
        if (!this.window.isShowing()) {
            this.window.show();
        } else {
            this.window.setIconified(false);
            this.window.toFront();
        }
    }

    public void hide() {
        this.window.hide();
    }

    public void setViewer(Viewer<? extends ViewerModel> viewer) {
        Objects.requireNonNull(viewer, "Viewer required");
        if (this.viewer != null) {
            this.viewer.release();
            this.viewer = null;
        }
        this.root.apViewerPlace.getChildren().clear();
        this.root.containerToolbar.getItems().retainAll((Object[])new Node[]{this.root.tbPinUnpin});
        this.window.setTitle(viewer.getTitle());
        viewer.embed((Pane)this.root.apViewerPlace);
        this.root.containerToolbar.getItems().addAll(1, (Collection)viewer.provideTools());
        this.viewer = viewer;
    }

    public void setOwnerWindow(Stage ownerWindow) {
    }

    public Optional<Viewer> getViewer() {
        return Optional.of(this.viewer);
    }

    @Subscribe
    public void onNodeModelChanged(NodeModelChanged event) {
        Model model = event.getNodeModel();
        if (!this.viewer.getId().equals(model.getUuid())) {
            return;
        }
        this.window.setTitle(((UIBlockModel)model).getCaption());
    }

    @Subscribe
    public void onStareProjectPrepareToSave(StareProjectPrepareToSave event) {
        this.savePreference();
        if (this.viewer != null) {
            this.viewer.savePreference();
        }
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public void release() {
        this.savePreference();
        if (this.viewer != null) {
            this.viewer.release();
            this.viewer = null;
        }
        this.window.showingProperty().removeListener((ChangeListener)this.windowShowing);
        this.window.close();
        this.windowShowing = null;
        this.window = null;
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public void savePreference() {
        this.putPreferredBoolean("isMaximized", this.window.isMaximized());
        this.putPreferredBoolean("isMinimized", this.window.isIconified());
        this.putPreferredDouble("width", this.window.getWidth());
        this.putPreferredDouble("height", this.window.getHeight());
        this.putPreferredDouble("x", this.window.isIconified() ? 0.0 : this.window.getX());
        this.putPreferredDouble("y", this.window.isIconified() ? 0.0 : this.window.getY());
        if (this.viewer != null) {
            this.viewer.savePreference();
        }
    }

    public void restorePreference() {
        this.window.setWidth(Math.max(this.getPreferredDouble("width", 800.0), 100.0));
        this.window.setHeight(Math.max(this.getPreferredDouble("height", 600.0), 100.0));
        this.window.setX(this.getPreferredDouble("x", 0.0));
        this.window.setY(this.getPreferredDouble("y", 0.0));
        this.window.setIconified(this.getPreferredBoolean("isMinimized", false));
        this.window.setMaximized(this.getPreferredBoolean("isMaximized", false));
        if (this.viewer != null) {
            this.viewer.restorePreference();
        }
    }

    public boolean isShowing() {
        return this.window.isShowing();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.window.showingProperty();
    }

    private class WindowShowing
    implements ChangeListener<Boolean> {
        private WindowShowing() {
        }

        public void changed(ObservableValue<? extends Boolean> ob, Boolean o, Boolean isShow) {
            if (!isShow.booleanValue()) {
                ViewerContainer.this.release();
            } else if (ViewerContainer.this.viewer != null) {
                ViewerContainer.this.viewer.onChangeStageShowingProperty(isShow);
            }
        }
    }

    private static class ViewerContainerContent
    extends VBox {
        private static final Logger logger = Logger.getLogger(ViewerContainerContent.class.getCanonicalName());
        @FXML
        private ToolBar containerToolbar;
        @FXML
        private ToggleButton tbPinUnpin;
        @FXML
        private AnchorPane apViewerPlace;

        private ViewerContainerContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
            }
            catch (IOException ex) {
                logger.severe(ex.getMessage());
            }
        }
    }
}

