/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.settings.block;

import com.siams.cv.monitor.entity.Settings;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.content.settings.block.AutoBlockSettings;
import com.siams.cv.monitor.ui.content.settings.block.BlockSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Deprecated
public class BlockSettingsFactory {
    private static final Logger logger = Logger.getLogger(BlockSettingsFactory.class);
    private static Map<UUID, BlockSettings> predefinedBlockSettings = new HashMap<UUID, BlockSettings>();

    public static BlockSettings create(WorkerType model, WorkerStructure workerStructure) {
        return BlockSettingsFactory.create(model.getType(), workerStructure);
    }

    public static BlockSettings create(UUID uuid, WorkerStructure workerStructure) {
        BlockSettings blockSettings = null;
        if (predefinedBlockSettings.containsKey(uuid)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"model has predefined settings");
            }
            blockSettings = predefinedBlockSettings.get(uuid);
            blockSettings.setStructure(workerStructure);
        } else {
            try {
                blockSettings = new AutoBlockSettings(workerStructure);
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Can't create auto block settings for model structure: %s", workerStructure.toString()));
                logger.error((Object)t.getMessage(), t);
            }
        }
        return blockSettings;
    }

    static {
        Reflections reflections = new Reflections("com.siams.cv.monitor.ui.content.settings.block", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(BlockSettings.class);
        for (Class clazz : classes) {
            if (clazz.isAnnotationPresent(Settings.class)) {
                try {
                    BlockSettings blockSettings = (BlockSettings)clazz.newInstance();
                    UUID uuid = UUID.fromString(clazz.getAnnotation(Settings.class).uuid());
                    predefinedBlockSettings.put(uuid, blockSettings);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("block settings annotation miss: " + clazz.toString());
        }
    }
}

