/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.windows;

import com.siams.cv.monitor.transport.grpc.GrpcTransport;
import com.siams.cv.monitor.ui.Initializable;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class ConnectionWindow
extends Stage {
    private static String host = GrpcTransport.DEFAULT_CONNECTION_HOST;
    private static int port = GrpcTransport.DEFAULT_CONNECTION_PORT;

    public ConnectionWindow() {
        this.setTitle("Connection");
        this.initModality(Modality.APPLICATION_MODAL);
        this.setResizable(false);
        this.setScene(new Scene((Parent)new ConnectionContent()));
    }

    class ConnectionContent
    extends Pane
    implements Initializable {
        @FXML
        private TextField portTextField;
        @FXML
        private Button cancelButton;
        @FXML
        private TextField hostTextField;
        @FXML
        private Button connectButton;

        @FXML
        void onSave(ActionEvent event) {
            host = this.hostTextField.getText();
            port = Integer.parseInt(this.portTextField.getText());
            try {
                Preferences preferences = Preferences.userNodeForPackage(ConnectionWindow.class);
                preferences.put("host", host);
                preferences.putInt("port", port);
                preferences.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            ConnectionWindow.this.close();
        }

        @FXML
        void onCancel(ActionEvent event) {
            ConnectionWindow.this.close();
        }

        public ConnectionContent() {
            try {
                URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/windows/ConnectionContent.fxml");
                CustomFXMLLoader.loadElement((Object)this, (URL)url);
                Preferences preferences = Preferences.userNodeForPackage(ConnectionWindow.class);
                this.hostTextField.setText(preferences.get("host", host));
                this.portTextField.setText(Integer.toString(preferences.getInt("port", port)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

