/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.node.UICommentModel;
import com.siams.cv.monitor.ui.DefaultNodeClickHandler;
import com.siams.cv.monitor.ui.DefaultNodeDragHandler;
import com.siams.cv.monitor.ui.NodeClickHandler;
import com.siams.cv.monitor.ui.NodeDragHandler;
import com.siams.cv.monitor.ui.factory.Block;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UICommentContent;
import com.siams.dialogs.DialogManager;
import com.siams.javafx.utils.FxPlatform;
import java.util.Objects;
import java.util.UUID;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public final class UIComment
extends Block<UICommentContent>
implements IIdentifiable,
Deletable {
    private UICommentModel model;
    private NodeClickHandler clickHandler;
    private NodeDragHandler dragHandler;

    public UIComment(UICommentModel model) {
        Objects.requireNonNull(model, "Valid model required");
        this.model = model;
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeResizeTriangle((Node)((UICommentContent)this.root).getResizeTriangle());
        this.subscribe();
    }

    @Override
    protected void initializeFxml() {
        this.root = new UICommentContent(this);
    }

    @Override
    protected void initializeStyle() {
        ((UICommentContent)this.root).getStyleClass().add((Object)"ui-comment");
    }

    @Override
    protected void initializeEvents() {
        super.initializeEvents();
        this.clickHandler = new UICommentClickHandler();
        this.dragHandler = new UICommentDragHandler();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
        ((UICommentContent)this.root).layoutBoundsProperty().addListener((ob, o, n) -> {
            this.model.setLayoutWidth(n.getWidth());
            this.model.setLayoutHeight(n.getHeight());
        });
    }

    public UUID getUuid() {
        return this.model.getUuid();
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public Model getNodeModel() {
        return this.model;
    }

    public String getComment() {
        return ((UICommentContent)this.root).getLabelComment().getText();
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
        FxPlatform.RunFxThread(() -> {
            UUID uuid = this.getUuid();
            this.setSelection(event.getSelected().stream().anyMatch(iid -> iid.getUuid().equals(uuid)));
        });
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.clickHandler != null) {
            this.clickHandler.release();
        }
        if (this.dragHandler != null) {
            this.dragHandler.release();
        }
    }

    private void onEditComment() {
        Label lblComment = ((UICommentContent)this.root).getLabelComment();
        DialogManager.showWideText((String)lblComment.getText(), (String)lblComment.getText(), (String)"Edit comment").ifPresent(text -> {
            this.model.setComment(text);
            lblComment.setText(text);
        });
    }

    private void setSelection(boolean selected) {
        ((UICommentContent)this.root).getStyleClass().removeAll((Object[])new String[]{"selected"});
        if (selected) {
            ((UICommentContent)this.root).getStyleClass().add((Object)"selected");
        }
    }

    private class UICommentClickHandler
    extends DefaultNodeClickHandler {
        private UICommentClickHandler() {
            super((Node)UIComment.this.root, UIComment.this);
        }

        @Override
        protected void onClick(MouseEvent event) {
            super.onClick(event);
            UIComment.this.setSelection(true);
        }

        @Override
        protected void onDoubleClick(MouseEvent event) {
            UIComment.this.onEditComment();
        }
    }

    private class UICommentDragHandler
    extends DefaultNodeDragHandler {
        private UICommentDragHandler() {
            super((Node)UIComment.this.root, UIComment.this);
        }

        @Override
        protected void onRelease(MouseEvent event) {
            super.onRelease(event);
            UIComment.this.model.setLayoutX(((UICommentContent)UIComment.this.root).getLayoutX());
            UIComment.this.model.setLayoutY(((UICommentContent)UIComment.this.root).getLayoutY());
        }
    }
}

