/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectPrepareToSave;
import com.siams.cv.monitor.model.node.AnchorType;
import com.siams.cv.monitor.model.node.PortDataType;
import com.siams.cv.monitor.model.node.UILinkAnchorModel;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.DefaultNodeClickHandler;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.LinkingMode;
import com.siams.cv.monitor.ui.factory.NodeChangePositionListener;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.javafx.utils.FxPlatform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.shape.Arc;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class UILinkAnchor
extends Arc
implements StareNode,
Deletable {
    private UILinkAnchorModel model;
    private UILinkAnchorClickHandler clickHandler;
    private Map<Runnable, NodeChangePositionListener> listeners = new HashMap<Runnable, NodeChangePositionListener>();

    public UILinkAnchor(UILinkAnchorModel model) {
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.initializeStyle();
        this.initializeShape();
        this.initializeLayout();
        this.initializeEvents();
        this.subscribe();
    }

    private void initializeStyle() {
        this.getStyleClass().add((Object)"ui-link-anchor");
    }

    private void initializeShape() {
        this.setRadiusX(10.0);
        this.setRadiusY(10.0);
        this.setLength(240.0);
        if (this.model.getAnchorType() == AnchorType.SRC) {
            this.setStartAngle(60.0);
        } else {
            this.setStartAngle(240.0);
        }
    }

    private void initializeLayout() {
        this.setLayoutX(this.model.getLayoutX());
        this.setLayoutY(this.model.getLayoutY());
    }

    private void initializeEvents() {
        this.setOnMouseDragged(Event::consume);
        this.setOnDragDetected(event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            event.consume();
            Desktop.getInstance().setAnchorToDrag(this);
            this.setMouseTransparent(true);
            this.toFront();
            this.startFullDrag();
            Dragboard db = this.startDragAndDrop(TransferMode.ANY);
            ClipboardContent content = new ClipboardContent();
            content.put((Object)UIPort.dragDataUuid, (Object)this.model.getUuid());
            content.put((Object)UIPort.dragDataLinkingMode, (Object)LinkingMode.ATTACH);
            db.setContent((Map)content);
        });
        this.setOnDragDone(event -> {
            this.setMouseTransparent(false);
            Desktop.getInstance().setAnchorToDrag(null);
        });
        this.clickHandler = new UILinkAnchorClickHandler((Node)this, this);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public UUID getUuid() {
        return this.model.getUuid();
    }

    @Override
    public Node getNode() {
        return this;
    }

    public UILinkAnchorModel getNodeModel() {
        return this.model;
    }

    public AnchorType getAnchorType() {
        return this.model.getAnchorType();
    }

    public List<UILink> getConnectedLinks() {
        LinkedList<UILink> connectedLinks = new LinkedList<UILink>();
        this.model.getConnectedLinksUuids().forEach(uuid -> NodeStorage.getInstance().findFirst((UUID)uuid, UILink.class).ifPresent(connectedLinks::add));
        return connectedLinks;
    }

    public PortDataType getDataType() {
        return this.model.getDataType();
    }

    public void setDataType(PortDataType dataType) {
        this.model.setDataTypeUuid(dataType.getUuid());
    }

    public void addLink(UILink uiLink) {
        this.model.getConnectedLinksUuids().add(uiLink.getUuid());
        if (this.model.getAnchorType() == AnchorType.SRC) {
            uiLink.setSrcAnchor(this);
            uiLink.getNodeModel().setSrcPortUuid(this.getUuid());
        } else if (this.model.getAnchorType() == AnchorType.DEST) {
            uiLink.setDestAnchor(this);
            uiLink.getNodeModel().setDestPortUuid(this.getUuid());
        }
    }

    public void removeLink(UILink uiLink) {
        this.removeLink(uiLink.getUuid());
    }

    public void removeLink(UUID linkUuid) {
        this.model.getConnectedLinksUuids().remove(linkUuid);
        if (this.model.getConnectedLinksUuids().isEmpty()) {
            App.removeFromStorage(this.getUuid());
        }
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        if (this.model.getConnectedLinksUuids().contains(event.getUuid())) {
            this.removeLink(event.getUuid());
        }
    }

    @Subscribe
    public void onStareProjectPrepareToSave(StareProjectPrepareToSave event) {
        this.model.setLayoutX(this.getLayoutX());
        this.model.setLayoutY(this.getLayoutY());
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.clickHandler != null) {
            this.clickHandler.release();
        }
    }

    @Override
    public void addChangePositionListener(Runnable listener) {
        NodeChangePositionListener portPositionListener = new NodeChangePositionListener(this.getNode(), listener);
        this.listeners.put(listener, portPositionListener);
    }

    @Override
    public void removeChangePositionListener(Runnable listener) {
        NodeChangePositionListener portPositionListener = this.listeners.get(listener);
        if (portPositionListener != null) {
            portPositionListener.release();
            this.listeners.remove(listener);
        }
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
        FxPlatform.RunFxThread(() -> {
            UUID uuid = this.getUuid();
            this.setSelection(event.getSelected().stream().anyMatch(iid -> iid.getUuid().equals(uuid)));
        });
    }

    private void setSelection(boolean isSelected) {
        this.getStyleClass().removeAll((Object[])new String[]{"selected"});
        if (isSelected) {
            this.getStyleClass().add((Object)"selected");
        }
    }

    private static class UILinkAnchorClickHandler
    extends DefaultNodeClickHandler {
        private UILinkAnchorClickHandler(Node eventConsumer, StareNode eventTarget) {
            super(eventConsumer, eventTarget);
        }

        @Override
        protected void onClick(MouseEvent event) {
            super.onClick(event);
        }
    }
}

