/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.menu;

import com.siams.cv.monitor.ui.menu.RecentFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public class RecentFiles {
    private Collection<RecentFile> files = new TreeSet<RecentFile>();
    private final int maxSize;

    public RecentFiles(int maxSize) {
        this.maxSize = maxSize;
    }

    public void addFile(RecentFile recentFile) {
        this.files.remove(recentFile);
        this.files.add(recentFile);
        this.adjustRecentFilesSize();
    }

    public void addFiles(List<RecentFile> recentFiles) {
        this.files.removeAll(recentFiles);
        this.files.addAll(recentFiles);
        this.adjustRecentFilesSize();
    }

    private void adjustRecentFilesSize() {
        if (this.files.size() > this.maxSize) {
            Iterator<RecentFile> it = this.files.iterator();
            int index = 0;
            while (it.hasNext()) {
                it.next();
                if (index >= this.maxSize) {
                    it.remove();
                }
                ++index;
            }
        }
    }

    public void removeFile(RecentFile recentFile) {
        this.files.remove(recentFile);
    }

    public Collection<RecentFile> getFiles() {
        return Collections.unmodifiableCollection(this.files);
    }

    public Optional<RecentFile> getFile(int index) {
        Iterator<RecentFile> it = this.files.iterator();
        int i = -1;
        RecentFile recentFile = null;
        while (it.hasNext()) {
            if (++i == index) {
                recentFile = it.next();
                break;
            }
            it.next();
        }
        return Optional.ofNullable(recentFile);
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

