/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.menu;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.BasePooling;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.dialogs.DialogManager;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.dialog.Editor;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import com.siams.stare.api.Command;
import com.siams.stare.api.ObjectStatus;
import com.siams.stare.api.data.SolutionApp;
import com.siams.stare.api.data.SolutionTemplate;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import org.apache.log4j.Logger;

public class ServerPanel
extends Editor<String>
implements Deletable {
    private ServerPanelContent root;
    private List<String> availableProjectUrls;
    private String selectedSession = null;
    private String selectedProject = null;
    private Logger logger = Logger.getLogger(ServerPanel.class);
    static Image imRemoveProject = new Image("icons/remove.png", true);
    private ProjectsPooling projectsExecutionStatusPooling = null;

    public ServerPanel() throws IOException {
        this.setTitle("Server admin panel");
        this.root = new ServerPanelContent();
        this.setDialogPaneContent((Node)this.root);
        this.setResizable(true);
        this.setMinSize(300.0, 200.0);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setResultConverter(buttonType -> {
            this.release();
            return buttonType == ButtonType.APPLY ? this.selectedProject : null;
        });
    }

    private ServerPanel(List<String> urls) throws IOException {
        this.availableProjectUrls = urls;
        this.setTitle("Manage projects on server side");
        this.root = new ServerPanelContent();
        this.setDialogPaneContent((Node)this.root);
        this.setResizable(true);
        this.setMinSize(300.0, 200.0);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setResultConverter(buttonType -> {
            this.release();
            return buttonType == ButtonType.APPLY ? this.selectedProject : null;
        });
    }

    private void updateSolutionList() {
        this.root.pbSolutions.progress(this.initializeSolutionList(), "Updating...").exceptionally(t -> {
            this.logger.error((Object)"Failed update solution list", t);
            StareNotification.showWarn((String)"Failed update solution list");
            return null;
        });
    }

    private CompletableFuture<Void> initializeSolutionList() {
        App app = App.getInstance();
        this.root.clearSolutionList();
        return app.rqGetListUrls("/app").thenAccept(urls -> urls.forEach(solutionUrl -> app.rqGetData((String)solutionUrl, SolutionApp.class).thenAccept(solutionApp -> this.root.addSolutionApp(new SolutionAppNode((SolutionApp)solutionApp)))));
    }

    private CompletableFuture<Void> initializeSolutionTemplateList(String solutionId) {
        App app = App.getInstance();
        this.root.clearSolutionTemplateList();
        return app.rqGetListUrls(String.format("/app:%s/template", solutionId)).thenAccept(urls -> urls.forEach(templateUrl -> app.rqGetData((String)templateUrl, SolutionTemplate.class).thenAccept(solutionTemplate -> this.root.addSolutionTemplate(new SolutionTemplateNode(this, (SolutionTemplate)solutionTemplate)))));
    }

    private void updateSessionList() {
        this.root.pbProjects.progress(this.initializeSessionList(), "Updating sessions...").exceptionally(t -> {
            this.logger.error((Object)"Failed update session list", t);
            StareNotification.showWarn((String)"Failed update session list");
            return null;
        });
    }

    private void updateProjectList() {
        this.root.pbProjects.progress(this.initializeProjectList(), "Updating projects...").exceptionally(t -> {
            this.logger.error((Object)"Failed update project list", t);
            StareNotification.showWarn((String)"Failed update project list");
            return null;
        });
    }

    private CompletableFuture<Void> initializeSessionList() {
        App app = App.getInstance();
        this.root.clearSessionList();
        this.root.clearProjectList();
        return app.rqGetListUrls("/session").thenAccept(urls -> urls.forEach(sessionUrl -> this.root.addSession(new SessionNode((String)sessionUrl))));
    }

    private String getSelectedSession() {
        return this.selectedSession;
    }

    private CompletableFuture<Void> initializeProjectList() {
        App app = App.getInstance();
        String sessionUrl = this.getSelectedSession();
        this.root.clearProjectList();
        if (sessionUrl == null) {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.complete(null);
            return result;
        }
        return app.rqGetListUrls(String.format("%s/project", sessionUrl)).thenAccept(urls -> {
            if (urls == null) {
                throw new CompletionException(new Throwable("Fail to get list of server-side projects"));
            }
            urls.forEach(projectUrl -> this.root.addProject(new ProjectNode((String)projectUrl)));
        });
    }

    private void initializePooling() {
        this.projectsExecutionStatusPooling = new ProjectsPooling();
        this.projectsExecutionStatusPooling.startPooling();
    }

    @Override
    public void release() {
        if (this.projectsExecutionStatusPooling != null) {
            this.projectsExecutionStatusPooling.release();
        }
        this.root.getChildren().clear();
    }

    private void initializeProjectListProgressBar() {
        this.root.pbProjects = new FxRunIndicator();
        this.root.tbProjects.getItems().add((Object)this.root.pbProjects);
    }

    private void initializeSolutionListProgressBar() {
        this.root.pbSolutions = new FxRunIndicator();
        this.root.tbSolutions.getItems().add((Object)this.root.pbSolutions);
    }

    private void initializeBtnRefreshProjects() {
        this.root.btnRefreshProjects.setOnAction(action -> {
            this.updateSessionList();
            this.updateProjectList();
        });
    }

    private void initializeBtnRefreshSolutions() {
        this.root.btnRefreshSolutions.setOnAction(action -> this.updateSolutionList());
    }

    private void onSolutionAppSelected(SolutionApp solutionApp) {
        this.initializeSolutionTemplateList(solutionApp.id);
        this.root.updateSolutionDescription(solutionApp);
    }

    public class ProjectsPooling
    extends BasePooling {
        @Override
        public void startPooling() {
            super.startPooling("Server project editor pooling");
        }

        @Override
        protected CompletableFuture<Void> timerTask() {
            boolean hasProjectUrl;
            boolean bl = hasProjectUrl = !ServerPanel.this.availableProjectUrls.isEmpty();
            if (!hasProjectUrl) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                future.complete(null);
                return future;
            }
            return CompletableFuture.allOf((CompletableFuture[])ServerPanel.this.availableProjectUrls.stream().map(url -> ((CompletableFuture)App.getInstance().getStareApi().getObjectStatus(url).thenApply(status -> {
                ServerPanel.this.root.setStatus((String)url, (ObjectStatus)status);
                return 0;
            })).exceptionally(t -> {
                ServerPanel.this.logger.error((Object)"Failed get server project status", t);
                throw new CompletionException(new Throwable(t.getMessage()));
            })).toArray(CompletableFuture[]::new));
        }
    }

    private class ServerPanelContent
    extends StackPane
    implements Initializable {
        @FXML
        private VBox sessionList;
        @FXML
        private VBox projectsList;
        @FXML
        private Button btnRefreshProjects;
        @FXML
        private Button btnRefreshSolutions;
        @FXML
        private ToolBar tbProjects;
        @FXML
        private ToolBar tbSolutions;
        private FxRunIndicator pbProjects;
        private FxRunIndicator pbSolutions;
        @FXML
        private VBox solutionList;
        @FXML
        private VBox solutionTemplateList;
        @FXML
        private WebView webViewDescription;

        private ServerPanelContent() {
        }

        void setStatus(String projectUrl, ObjectStatus status) {
            FxPlatform.RunFxThread(() -> this.projectsList.getChildren().forEach(node -> {
                ProjectNode entry = (ProjectNode)((Object)((Object)node));
                if (entry.projectUrl.equals(projectUrl)) {
                    double progress = status == ObjectStatus.EXECUTING ? -1.0 : 1.0;
                    entry.projectProgress.setProgress(progress);
                }
            }));
        }

        private void addSession(SessionNode session) {
            FxPlatform.RunFxThread(() -> this.sessionList.getChildren().add((Object)session));
        }

        private void addProject(ProjectNode project) {
            FxPlatform.RunFxThread(() -> this.projectsList.getChildren().add((Object)project));
        }

        public void initialize(URL url, ResourceBundle resourceBundle) {
            ServerPanel.this.initializeBtnRefreshProjects();
            ServerPanel.this.initializeBtnRefreshSolutions();
            ServerPanel.this.initializeProjectListProgressBar();
            ServerPanel.this.initializeSolutionListProgressBar();
            ServerPanel.this.updateSessionList();
            ServerPanel.this.updateProjectList();
            ServerPanel.this.updateSolutionList();
        }

        public void addSolutionApp(SolutionAppNode solutionApp) {
            FxPlatform.RunFxThread(() -> this.solutionList.getChildren().add((Object)solutionApp));
        }

        public void addSolutionTemplate(SolutionTemplateNode solutionTemplateNode) {
            FxPlatform.RunFxThread(() -> this.solutionTemplateList.getChildren().add((Object)solutionTemplateNode));
        }

        void clearSolutionTemplateList() {
            FxPlatform.RunFxThread(() -> this.solutionTemplateList.getChildren().clear());
        }

        void clearSolutionList() {
            FxPlatform.RunFxThread(() -> this.solutionList.getChildren().clear());
        }

        void clearSessionList() {
            FxPlatform.RunFxThread(() -> {});
            this.sessionList.getChildren().clear();
        }

        void clearProjectList() {
            FxPlatform.RunFxThread(() -> this.projectsList.getChildren().clear());
        }

        void updateSolutionDescription(SolutionApp solutionApp) {
            FxPlatform.RunFxThread(() -> this.webViewDescription.getEngine().loadContent(solutionApp.description));
        }
    }

    private class ProjectNode
    extends HBox {
        String projectUrl;
        TextField tfUrl;
        ProgressIndicator projectProgress;
        Button btnInterruptProject;
        Button btnOpenProject;
        Button btnDeleteProject;

        ProjectNode(String projectUrl) {
            this.projectUrl = projectUrl;
            this.tfUrl = new TextField(projectUrl);
            this.tfUrl.setEditable(false);
            this.tfUrl.setOnMouseClicked(event -> {
                ServerPanel.this.selectedProject = projectUrl;
            });
            App.getInstance().rqGetDataIfExist(String.format("%s/property:chain.name", projectUrl), "[Untitled]").thenAccept(name -> FxPlatform.RunFxThread(() -> this.tfUrl.setText(String.format("%s (%s)", projectUrl, name))));
            this.projectProgress = new ProgressIndicator();
            this.projectProgress.setMaxSize(30.0, 30.0);
            this.projectProgress.setProgress(-1.0);
            this.projectProgress.setProgress(1.0);
            this.btnInterruptProject = new Button("Stop");
            this.btnInterruptProject.disableProperty().bind((ObservableValue)this.projectProgress.progressProperty().greaterThan(0.0));
            this.btnInterruptProject.setOnAction(event -> App.getInstance().getStareApi().executeCommand(projectUrl, Command.INTERRUPT).exceptionally(t -> {
                StareNotification.showWarn((String)"Failed interrupt project");
                ServerPanel.this.logger.error((Object)String.format("Failed interrupt project: %s", t.getMessage()), t);
                return null;
            }));
            this.btnOpenProject = new Button("Open");
            this.btnOpenProject.setDisable(App.getInstance().getProject().getUrl().equals(projectUrl));
            this.btnOpenProject.setOnAction(event -> {
                ServerPanel.this.release();
                ServerPanel.this.setResult(projectUrl);
            });
            ImageView graphic = new ImageView(imRemoveProject);
            graphic.setFitWidth(18.0);
            graphic.setFitHeight(18.0);
            this.btnDeleteProject = new Button();
            this.btnDeleteProject.setDisable(App.getInstance().getProject().getUrl().equals(projectUrl));
            this.btnDeleteProject.setGraphic((Node)graphic);
            this.btnDeleteProject.setOnAction(event -> {
                String currentProjectUrl = App.getInstance().getProject().getUrl();
                if (currentProjectUrl.equals(projectUrl)) {
                    StareNotification.showWarn((String)"Unable to remove current project");
                    return;
                }
                DialogManager.showYesNoQuery((String)"Remove project on server side. Are your sure?", (String)"Remove project").ifPresent(buttonType -> {
                    if (buttonType.equals(ButtonType.YES)) {
                        ((CompletableFuture)App.getInstance().getStareApi().remove(projectUrl).thenAccept(strings -> FxPlatform.RunFxThread(() -> ServerPanel.this.root.projectsList.getChildren().remove((Object)this)))).exceptionally(t -> {
                            StareNotification.showWarn((String)("Unable to remove project: " + projectUrl));
                            return null;
                        });
                    }
                });
            });
            if (projectUrl.equals(App.getInstance().getProject().getUrl())) {
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGREY, null, null)}));
            }
            this.getChildren().addAll((Object[])new Node[]{this.tfUrl, this.projectProgress, this.btnInterruptProject, this.btnOpenProject, this.btnDeleteProject});
            HBox.setHgrow((Node)this.tfUrl, (Priority)Priority.ALWAYS);
            this.setPadding(new Insets(2.0));
            this.setSpacing(5.0);
            this.setAlignment(Pos.CENTER_LEFT);
            this.setMinHeight(35.0);
        }
    }

    private class SessionNode
    extends HBox {
        private final String sessionUrl;

        SessionNode(String sessionUrl) {
            this.sessionUrl = sessionUrl;
            TextField tfUrl = new TextField(sessionUrl);
            tfUrl.setEditable(false);
            this.getChildren().addAll((Object[])new Node[]{tfUrl});
            HBox.setHgrow((Node)tfUrl, (Priority)Priority.ALWAYS);
            this.setPadding(new Insets(2.0));
            this.setSpacing(5.0);
            this.setAlignment(Pos.CENTER_LEFT);
            this.setMinHeight(35.0);
            this.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
                ServerPanel.this.selectedSession = sessionUrl;
                ServerPanel.this.initializeProjectList();
                event.consume();
            });
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGREY, null, null)}));
        }
    }

    private class SolutionTemplateNode
    extends HBox {
        final SolutionTemplate data;

        private SolutionTemplateNode(ServerPanel serverPanel, SolutionTemplate data) {
            this.data = data;
            this.initialize();
        }

        private void initialize() {
            this.setSpacing(5.0);
            Button btnOpen = this.createBtnOpen();
            TextField tfSolutionTemplateCaption = this.createTextFieldTemplateCaption();
            this.getChildren().addAll((Object[])new Node[]{tfSolutionTemplateCaption, btnOpen});
            HBox.setHgrow((Node)tfSolutionTemplateCaption, (Priority)Priority.ALWAYS);
        }

        private TextField createTextFieldTemplateCaption() {
            TextField textField = new TextField(this.data.caption);
            textField.setTooltip((Tooltip)new StareTooltip(this.data.id));
            textField.setEditable(false);
            return textField;
        }

        private Button createBtnOpen() {
            Button button = new Button("Open");
            button.setMinWidth(60.0);
            button.setMaxWidth(60.0);
            button.setOnAction(action -> UserAction.openSolutionTemplate(this.data.id));
            return button;
        }
    }

    private class SolutionAppNode
    extends HBox {
        final SolutionApp data;

        SolutionAppNode(SolutionApp data) {
            this.data = data;
            this.initialize();
        }

        private void initialize() {
            this.setSpacing(5.0);
            this.setWidth(Double.MAX_VALUE);
            this.setMaxWidth(Double.MAX_VALUE);
            Button btnOpen = this.createBtnOpen();
            Node tfSolutionCaption = this.createSolutionCaptionNode();
            tfSolutionCaption.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> ServerPanel.this.onSolutionAppSelected(this.data));
            this.getChildren().addAll((Object[])new Node[]{tfSolutionCaption, btnOpen});
            HBox.setHgrow((Node)tfSolutionCaption, (Priority)Priority.ALWAYS);
        }

        private Button createBtnOpen() {
            Button button = new Button("Open");
            button.setMinWidth(60.0);
            button.setMaxWidth(60.0);
            button.setOnAction(action -> UserAction.openSolution(this.data.id));
            return button;
        }

        private Node createSolutionCaptionNode() {
            TextField tfSolutionCaption = new TextField(this.data.caption);
            tfSolutionCaption.setEditable(false);
            tfSolutionCaption.setTooltip((Tooltip)new StareTooltip(this.data.id));
            tfSolutionCaption.setMaxWidth(Double.MAX_VALUE);
            return tfSolutionCaption;
        }
    }
}

