/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import org.bytedeco.javacpp.Loader;
import org.bytedeco.opencv.global.opencv_cudaimgproc;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.opencv_core.Mat;

public final class JavaCPPOpenCV40LinkageProblem {
    public static void main(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                System.out.printf("Usage: %s source_image%n", JavaCPPOpenCV40LinkageProblem.class.getName());
                return;
            }
            String sourceFile = args[0];
            Mat mat = opencv_imgcodecs.imread((String)sourceFile);
            GpuMat gpuMat = new GpuMat(mat.rows(), mat.cols(), mat.type());
            mat.copyTo(gpuMat);
            opencv_cudaimgproc.bilateralFilter((GpuMat)gpuMat, (GpuMat)gpuMat, (int)7, (float)32.0f, (float)5.0f);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            String path = Loader.cacheResource(opencv_cudaimgproc.class, (String)"windows-x86_64-gpu/jniopencv_cudaarithm.dll").getPath();
            new ProcessBuilder("D:\\Dependencies_x64_Release\\DependenciesGui.exe ", path).start().waitFor();
        }
    }
}

