/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SimpleGaussianPlusCloneSpeed {
    private static final int KERNEL_SIZE = 111;

    public static void main(String[] args) {
        System.out.println("OpenCL existence: " + opencv_core.haveOpenCL());
        System.out.println("OpenCL usage: " + opencv_core.useOpenCL());
        Size ksize = new Size(111, 111);
        for (int testCount = 0; testCount < 16; ++testCount) {
            System.out.printf("%nTest #%d%n", testCount);
            UMat m = new UMat(1024, 1024, opencv_core.CV_8UC3, new Scalar(0.0, 0.0, 0.0, 0.0));
            UMat result = new UMat();
            long t1 = System.nanoTime();
            opencv_imgproc.GaussianBlur((UMat)m, (UMat)result, (Size)ksize, (double)0.0);
            long t2 = System.nanoTime();
            UMat clone = m.clone();
            long t3 = System.nanoTime();
            System.out.printf("GaussianBlur: %.3f ms%nclone: %.3f ms%n", (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6);
            clone.close();
            result.close();
            m.close();
        }
    }
}

