/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public abstract class BaseImageViewerContent<T extends ViewerModel>
extends VBox
implements IBaseImageViewerContent,
UIPreference,
Initializable {
    @FXML
    protected Button btnResetZoom;
    @FXML
    protected AnchorPane apToolbarHolder;
    @FXML
    protected VBox vBoxZoomControls;
    @FXML
    protected ToggleButton tbPinUnpin;
    @FXML
    protected Canvas canvas;
    @FXML
    protected Rectangle highlighter;
    @FXML
    protected Button btnZoomOut;
    @FXML
    protected Button btnZoomIn;
    @FXML
    protected VBox viewerRoot;
    @FXML
    protected AnchorPane rasterContainer;
    @FXML
    protected AnchorPane apStatusBarHolder;
    protected MenuButton mbView;
    protected CheckMenuItem cmiZoomControls;
    protected CheckBox cbAutoContrast;
    private Runnable onBoundsChangedCallback;
    T viewerModel;

    public BaseImageViewerContent(T viewerModel) {
        this.viewerModel = viewerModel;
        try {
            CustomFXMLLoader.loadElement((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initializeMenuView();
        this.initializeCanvas();
    }

    protected void initializeMenuView() {
        this.mbView = new MenuButton("View");
        this.cmiZoomControls = new CheckMenuItem("Zoom controls");
        this.cmiZoomControls.setSelected(true);
        this.mbView.getItems().add((Object)this.cmiZoomControls);
    }

    protected void initializeCanvas() {
        this.canvas.getGraphicsContext2D().setImageSmoothing(false);
        this.canvas.getGraphicsContext2D().setFill((Paint)Color.IVORY);
        this.rasterContainer.layoutBoundsProperty().addListener((ob, o, n) -> {
            this.canvas.setWidth(n.getWidth());
            this.canvas.setHeight(n.getHeight());
            if (this.onBoundsChangedCallback != null) {
                this.onBoundsChangedCallback.run();
            }
        });
    }

    @Override
    public Pane getRasterContainer() {
        return this.rasterContainer;
    }

    @Override
    public Rectangle getHighlighter() {
        return this.highlighter;
    }

    @Override
    public Pane getRoot() {
        return this;
    }

    @Override
    public Pane getStatusBarHolder() {
        return this.apStatusBarHolder;
    }

    @Override
    public Node getZoomControls() {
        return this.vBoxZoomControls;
    }

    @Override
    public MenuButton getMenuView() {
        return this.mbView;
    }

    @Override
    public CheckMenuItem getCheckMenuItemZoomControls() {
        return this.cmiZoomControls;
    }

    @Override
    public Button getButtonZoomIn() {
        return this.btnZoomIn;
    }

    @Override
    public Button getButtonZoomOut() {
        return this.btnZoomOut;
    }

    @Override
    public Button getButtonResetZoom() {
        return this.btnResetZoom;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    public void restorePreference() {
        this.cmiZoomControls.setSelected(this.viewerModel.getDisplayZoomControls().booleanValue());
        this.tbPinUnpin.setSelected(this.viewerModel.getPinned().booleanValue());
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void setOnBoundsChangedCallback(Runnable onBoundsChangedCallback) {
        this.onBoundsChangedCallback = onBoundsChangedCallback;
    }
}

