/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

abstract class BaseImageViewerControls<T extends BaseImageViewer>
extends VBox
implements UIPreference {
    protected T viewer;
    @FXML
    protected HBox hBoxViewerKindSelector;
    @FXML
    protected RadioButton rbImage;
    @FXML
    protected RadioButton rbMask;
    @FXML
    protected RadioButton rbBoundaries;
    @FXML
    protected VBox vbOpacity;
    @FXML
    protected Slider sliderOpacity;
    @FXML
    protected TextField tfOpacity;

    void preprocessViewerImage() {
        ((Viewer)this.viewer).rerender();
        if (((RasterViewer)this.viewer).getViewerStateHandler() != null) {
            ((RasterViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
        }
    }

    BaseImageViewerControls(T viewer) {
        this.viewer = viewer;
    }

    public void init() {
        this.initializeRoot();
        this.registerOpacityPropertyListener();
        this.registerViewerKindChooser();
        this.initializeSliderOpacity();
        this.initializeTextFieldOpacity();
        this.restorePreference();
    }

    protected void initializeRoot() {
        try {
            CustomFXMLLoader.loadElement((Object)((Object)this));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void registerOpacityPropertyListener() {
        ((RasterViewer)this.viewer).getPropertyOpacity().addListener((observer, oldValue, newValue) -> {
            this.sliderOpacity.setValue(newValue.doubleValue());
            this.tfOpacity.setText(String.format("%.1f", newValue.doubleValue()));
        });
    }

    private void registerViewerKindChooser() {
        this.rbImage.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            String buttonId;
            switch (buttonId = ((RadioButton)newValue).getId()) {
                case "rbImage": {
                    ((BaseImageViewer)this.viewer).viewerStateHandler.onViewerKindChanged((BaseImageViewer)this.viewer, ViewerKind.IMAGE);
                    break;
                }
                case "rbMask": {
                    ((BaseImageViewer)this.viewer).viewerStateHandler.onViewerKindChanged((BaseImageViewer)this.viewer, ViewerKind.MASK);
                    break;
                }
                case "rbBoundaries": {
                    ((BaseImageViewer)this.viewer).viewerStateHandler.onViewerKindChanged((BaseImageViewer)this.viewer, ViewerKind.BOUNDARIES);
                    break;
                }
                default: {
                    System.out.println("Can't infer ViewerKind from RadioButton id: " + buttonId);
                }
            }
        });
    }

    private void initializeSliderOpacity() {
        this.sliderOpacity.setValue(((RasterViewer)this.viewer).getOpacity());
        this.sliderOpacity.valueProperty().addListener((observable, oldValue, newValue) -> {
            ((RasterViewer)this.viewer).setOpacity(newValue.doubleValue());
            if (((RasterViewer)this.viewer).getViewerStateHandler() != null) {
                ((RasterViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
            }
        });
    }

    private void initializeTextFieldOpacity() {
        this.tfOpacity.setText(String.valueOf(((RasterViewer)this.viewer).getOpacity()));
        this.tfOpacity.textProperty().addListener((observer, oldValue, newValue) -> {
            try {
                String txt = newValue.replace(",", ".");
                double value = Double.parseDouble(txt);
                if (0.0 <= value && value <= 1.0) {
                    ((RasterViewer)this.viewer).setOpacity(value);
                    if (((RasterViewer)this.viewer).getViewerStateHandler() != null) {
                        ((RasterViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    void enableFeature(BaseImageViewer.Feature feature, boolean enabled) {
        switch (feature) {
            case VIEWER_KIND: {
                if (this.hBoxViewerKindSelector == null) break;
                this.hBoxViewerKindSelector.setDisable(enabled);
                this.hBoxViewerKindSelector.setVisible(enabled);
                this.hBoxViewerKindSelector.setManaged(enabled);
                break;
            }
            case OPACITY: {
                if (this.vbOpacity == null) break;
                this.vbOpacity.setDisable(enabled);
                this.vbOpacity.setVisible(enabled);
                this.vbOpacity.setManaged(enabled);
            }
        }
    }
}

