/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.VoxelViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewRect;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.javafx.utils.FxPlatform;
import com.siams.stare.utils.SMatUtils;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.SplitPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.matrices.conversions.ExtractLayerWithDecreasingNumberOfDimensions;
import net.algart.multimatrix.MultiMatrix;

public class BaseVoxelViewer
extends BaseImageViewer<VoxelViewerModel> {
    private static final Logger logger = Logger.getLogger(BaseVoxelViewer.class.getCanonicalName());
    private BaseVoxelViewerContent root;
    private int sliceIndex = 0;
    private final ExtractLayerWithDecreasingNumberOfDimensions extractor = new ExtractLayerWithDecreasingNumberOfDimensions();
    private MultiMatrix matrix = null;
    private SMat extractedLayer = null;

    public BaseVoxelViewer(VoxelViewerModel viewerModel) {
        super(viewerModel);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        this.root.sliderSliceIndex.valueProperty().addListener((ob, o, n) -> {
            this.sliceIndex = n.intValue();
            this.root.sliderSliceIndex.setValue((double)this.sliceIndex);
            this.root.spinnerSliceIndex.getEditor().setText(String.valueOf(this.sliceIndex));
            this.renderImage(this.image);
            if (this.getViewerStateHandler() != null) {
                this.getViewerStateHandler().onViewerStateChanged();
            }
        });
        this.root.spinnerSliceIndex.setValueFactory(this.buildSpinnerFactory(100));
    }

    @Override
    public void initializeRoot() {
        this.root = new BaseVoxelViewerContent((VoxelViewerModel)this.viewerModel);
        this.root.setOnBoundsChangedCallback(() -> this.renderImage(this.image));
    }

    @Override
    public Pane provideControls() {
        return this.root.vbControlsContainer;
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        return null;
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.renderImageByteBufferDirectly();
    }

    @Override
    public void setViewerDataSource(ViewerDataSource viewerDataSource) {
        Objects.requireNonNull(viewerDataSource);
        if (this.viewerDataSource != null) {
            this.viewerDataSource.release();
        }
        this.viewerDataSource = viewerDataSource;
        this.viewerDataSource.addListener(this);
        this.getRasterData().ifPresent(sMat -> {
            this.matrix = sMat.toMultiMatrix(true);
            this.updateMaxSliceIndex((Data)sMat);
        });
    }

    @Override
    public void onChangeImageViewRect(ViewRect imageViewRect) {
        this.renderImage(this.image);
    }

    @Override
    public void renderImage(Image image) {
        long t1 = System.nanoTime();
        if (this.matrix == null) {
            return;
        }
        this.extractor.setLastCoordinate((long)this.sliceIndex);
        MultiMatrix slice = this.extractor.process(this.matrix);
        this.extractedLayer = SMat.of((MultiMatrix)slice);
        long t2 = System.nanoTime();
        image = RasterViewer.writableImageFromSMat(this.extractedLayer);
        if (image == null) {
            return;
        }
        this.setImage(image);
        long t3 = System.nanoTime();
        if (!this.imageViewRect.isDragHappened()) {
            this.getBaseContent().center();
        }
        this.drawImage(image);
        long t4 = System.nanoTime();
        logger.fine(String.format(Locale.US, "BaseVoxelViewer:renderImage %.3f ms = %.3f extract slice + %.3f buffered image + %.3f setImage", (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
    }

    private void renderImageByteBufferDirectly() {
        if (this.getRasterData().isEmpty()) {
            return;
        }
        SMat sMat = this.getRasterData().get();
        this.matrix = sMat.toMultiMatrix(true);
        SMat.Depth depth = sMat.getDepth();
        if (depth != SMat.Depth.U8) {
            logger.severe("Voxel matrix U8 depth required");
            this.image = null;
            return;
        }
        int dimCount = sMat.getDimCount();
        if (dimCount != 3) {
            logger.severe("Voxel matrix 3 dimension required");
            this.image = null;
            return;
        }
        long width = sMat.getDimX();
        if (width > Integer.MAX_VALUE) {
            logger.severe("Rendering matrix exceed max allowed width");
            this.image = null;
            return;
        }
        long height = sMat.getDimY();
        if (height > Integer.MAX_VALUE) {
            logger.severe("Rendering matrix exceed max allowed height");
            this.image = null;
            return;
        }
        int iwidth = (int)width;
        int iheight = (int)height;
        int channels = sMat.getNumberOfChannels();
        SMat slice = new SMat();
        ByteBuffer bb = sMat.getByteBuffer();
        int size = iwidth * iheight * channels;
        byte[] bytes = new byte[size];
        bb.position(iwidth * iheight * channels * this.sliceIndex);
        bb.get(bytes, 0, size);
        slice.setAll(new long[]{iwidth, iheight}, depth, channels, ByteBuffer.wrap(bytes), false);
        WritableImage result = RasterViewer.writableImageFromSMat(slice);
        this.setImage((Image)result);
        this.drawImage((Image)result);
    }

    @Override
    public void restorePreference() {
        this.root.splitPaneControls.setDividerPositions(new double[]{((VoxelViewerModel)this.viewerModel).getSplitterPosition()});
    }

    @Override
    public void savePreference() {
        ((VoxelViewerModel)this.viewerModel).setSplitterPosition(Double.valueOf(this.root.splitPaneControls.getDividerPositions()[0]));
    }

    @Override
    public double[] getPixelValue(int x, int y) {
        return SMatUtils.getPixelValue((Data)this.extractedLayer, (int)x, (int)y);
    }

    @Override
    public void onViewerDataReceived(ViewerData viewerData) {
        super.onViewerDataReceived(viewerData);
        this.getRasterData().ifPresent(sMat -> {
            this.matrix = sMat.toMultiMatrix(true);
            this.updateMaxSliceIndex((Data)sMat);
        });
    }

    private void updateMaxSliceIndex(Data data) {
        if (data != null && data.type() == DataType.MAT) {
            SMat sMat = (SMat)data;
            if (sMat.getDimCount() != 3) {
                return;
            }
            long max = sMat.getDim(2);
            if (max >= Integer.MAX_VALUE) {
                return;
            }
            FxPlatform.RunFxThread(() -> {
                int maxSlice = (int)max - 1;
                if (this.root.sliderSliceIndex.getMax() != (double)maxSlice) {
                    this.root.sliderSliceIndex.setMax((double)maxSlice);
                    this.root.sliderSliceIndex.setBlockIncrement(1.0);
                    this.root.spinnerSliceIndex.setValueFactory(this.buildSpinnerFactory(maxSlice));
                }
            });
        }
    }

    private SpinnerValueFactory buildSpinnerFactory(int maxSlice) {
        int startSlice = this.root.sliderSliceIndex.valueProperty().intValue();
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, maxSlice, startSlice, 1);
        valueFactory.valueProperty().addListener((ob, o, n) -> {
            this.sliceIndex = n;
            this.root.sliderSliceIndex.setValue((double)this.sliceIndex);
            this.renderImage(this.image);
        });
        return valueFactory;
    }

    public class BaseVoxelViewerContent
    extends BaseImageViewerContent<VoxelViewerModel> {
        @FXML
        VBox vbControlsContainer;
        @FXML
        Slider sliderSliceIndex;
        @FXML
        Spinner<Integer> spinnerSliceIndex;
        @FXML
        SplitPane splitPaneControls;

        BaseVoxelViewerContent(VoxelViewerModel viewerModel) {
            super(viewerModel);
        }

        @Override
        public Rectangle getHighlighter() {
            return this.highlighter;
        }

        @Override
        public Pane getRasterContainer() {
            return this.rasterContainer;
        }

        @Override
        public Pane getRoot() {
            return this;
        }

        @Override
        public Pane getStatusBarHolder() {
            return this.apStatusBarHolder;
        }

        @Override
        public Node getZoomControls() {
            return this.vBoxZoomControls;
        }

        @Override
        public CheckMenuItem getCheckMenuItemZoomControls() {
            return this.cmiZoomControls;
        }

        @Override
        public Button getButtonZoomIn() {
            return this.btnZoomIn;
        }

        @Override
        public Button getButtonZoomOut() {
            return this.btnZoomOut;
        }

        @Override
        public Button getButtonResetZoom() {
            return this.btnResetZoom;
        }

        @Override
        public void center() {
            double valX = Math.max((this.canvas.getWidth() - BaseVoxelViewer.this.image.getWidth() * BaseVoxelViewer.this.imageViewRect.getScale()) / 2.0, 0.0);
            double valY = Math.max((this.canvas.getHeight() - BaseVoxelViewer.this.image.getHeight() * BaseVoxelViewer.this.imageViewRect.getScale()) / 2.0, 0.0);
            BaseVoxelViewer.this.imageViewRect.setX(valX);
            BaseVoxelViewer.this.imageViewRect.setY(valY);
        }
    }
}

