/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ChartViewerModel;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import io.reactivex.annotations.NonNull;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SNumbers;
import org.controlsfx.control.CheckComboBox;

public abstract class ChartViewer
extends Viewer<ChartViewerModel> {
    protected static final Logger logger = Logger.getLogger(ChartViewer.class.getCanonicalName());
    protected ChartViewerContent root;
    protected double initialXLowerValue;
    protected double initialXUpperValue;
    protected double initialYLowerValue;
    protected double initialYUpperValue;
    protected ChartMouseHandler mouseHandler;
    protected BooleanProperty hideTicksProperty = new SimpleBooleanProperty(false);
    private IntegerProperty xAxisLabelsIndex = new SimpleIntegerProperty(0);
    private Point2D mouseActionStartPoint = Point2D.ZERO;
    private Point2D zoomRectLayoutShift = Point2D.ZERO;

    public ChartViewer(ChartViewerModel model) {
        super(model);
    }

    public void initialize() {
        this.initializeRoot();
        this.initializeControls();
        this.initializeChartTypeSelector();
    }

    private void initializeRoot() {
        this.root = new ChartViewerContent();
    }

    private void initializeChartTypeSelector() {
        ToggleGroup group = new ToggleGroup();
        this.root.rmiLine.setToggleGroup(group);
        this.root.rmiArea.setToggleGroup(group);
        this.root.rmiHist.setToggleGroup(group);
        group.selectedToggleProperty().addListener((ob, o, selected) -> this.viewerDataSource.getData().ifPresent(this::render));
    }

    @Override
    public void embed(Pane viewerContainer) {
        viewerContainer.getChildren().add((Object)this.root);
        PaneHelper.setAnchorZero((Node)this.root);
    }

    @Override
    public Pane provideControls() {
        return null;
    }

    @Override
    public Node provideView() {
        return this.root;
    }

    @Override
    public List<Node> provideTools() {
        return new LinkedList<CheckBox>(List.of(this.root.mbView, this.root.cbHideTicks));
    }

    protected abstract Node createScatterChart(SNumbers var1);

    protected abstract Node createLineChart(SNumbers var1);

    protected abstract Node createAreaChart(SNumbers var1);

    protected abstract Node createBarChart(SNumbers var1);

    protected abstract void initializeMouseHandler(Node var1);

    protected abstract Map<String, Double> cacheChartPosition(Node var1);

    protected abstract void restoreChartPosition(@NonNull Map<String, Double> var1, Node var2);

    @Override
    protected void initializeControls() {
        this.root.btnZoomIn.setOnAction(event -> this.mouseHandler.zoomIn());
        this.root.btnZoomOut.setOnAction(event -> this.mouseHandler.zoomOut());
        this.root.btnResetZoom.setOnAction(event -> this.mouseHandler.zoomReset());
        this.root.cbYAxisSelector.getCheckModel().getCheckedIndices().addListener(change -> this.viewerDataSource.getData().ifPresent(this::render));
        this.xAxisLabelsIndex.bind((ObservableValue)this.root.cbXAxisSelector.getSelectionModel().selectedItemProperty());
        this.xAxisLabelsIndex.addListener((ob, o, n) -> this.viewerDataSource.getData().ifPresent(this::render));
        this.hideTicksProperty.bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.root.cbHideTicks.selectedProperty()));
    }

    @Override
    public void setViewerDataSource(ViewerDataSource viewerDataSource) {
        super.setViewerDataSource(viewerDataSource);
        this.initializeAxisDataSelectors(viewerDataSource);
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.extractDefaultData(viewerData).ifPresent(numbersData -> {
            ObservableList children = this.root.apChartContainer.getChildren();
            Map<String, Double> cache = children.isEmpty() ? null : this.cacheChartPosition((Node)children.get(0));
            int sampleLength = numbersData.n();
            int numberOfSamples = numbersData.blockLength();
            int maxAllowDisplayData = 1000;
            SNumbers sNumbers = sampleLength > 1000 ? numbersData.blockRange(0, 1000) : numbersData;
            if (numberOfSamples < 1) {
                StareNotification.showWarn((String)"Not enough data to display the chart");
                return;
            }
            FxPlatform.RunFxThread(() -> {
                if (this.xAxisLabelsIndex.get() < 0) {
                    this.initialXLowerValue = 0.0;
                    this.initialXUpperValue = sampleLength - 1;
                } else {
                    this.initialXLowerValue = sNumbers.minInColumnRange(this.xAxisLabelsIndex.get(), 1, true);
                    this.initialXUpperValue = sNumbers.maxInColumnRange(this.xAxisLabelsIndex.get(), 1, true);
                }
                this.initialYLowerValue = sNumbers.min(true);
                this.initialYUpperValue = sNumbers.max(true);
                int value = this.xAxisLabelsIndex.get();
                Node chartNode = value >= 0 ? this.createScatterChart(sNumbers) : (this.root.rmiLine.isSelected() ? this.createLineChart(sNumbers) : (this.root.rmiArea.isSelected() ? this.createAreaChart(sNumbers) : this.createBarChart(sNumbers)));
                this.initializeMouseHandler(chartNode);
                if (cache != null) {
                    this.restoreChartPosition(cache, chartNode);
                }
                this.root.apChartContainer.getChildren().clear();
                this.root.apChartContainer.getChildren().add((Object)chartNode);
                PaneHelper.setAnchorZero((Node)chartNode);
            });
        });
    }

    protected void initializeMouseActions(Region handleNode) {
        handleNode.setOnScroll(event -> {
            if (event.getDeltaY() > 0.0) {
                this.mouseHandler.zoomIn();
            }
            if (event.getDeltaY() < 0.0) {
                this.mouseHandler.zoomOut();
            }
        });
        handleNode.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.mouseHandler.zoomReset();
            }
        });
        handleNode.setOnMousePressed(event -> {
            this.mouseActionStartPoint = new Point2D(event.getX(), event.getY());
            this.mouseHandler.onScrollStart();
            if (event.isControlDown()) {
                Node plot = (Node)event.getSource();
                Parent fullScreenChartNode = plot.getParent();
                Bounds plotShift = plot.getBoundsInParent();
                this.zoomRectLayoutShift = new Point2D(plotShift.getMinX(), plotShift.getMinY());
                this.root.zoomRect.setVisible(true);
                this.root.zoomRect.setManaged(true);
                this.root.zoomRect.setLayoutX(event.getX() + this.zoomRectLayoutShift.getX());
                this.root.zoomRect.setLayoutY(event.getY() + this.zoomRectLayoutShift.getY());
            }
        });
        handleNode.setOnMouseDragged(event -> {
            if (event.isControlDown()) {
                Point2D upperleft = new Point2D(Math.min(this.mouseActionStartPoint.getX(), event.getX()), Math.min(this.mouseActionStartPoint.getY(), event.getY()));
                Point2D bottomRight = new Point2D(Math.max(this.mouseActionStartPoint.getX(), event.getX()), Math.max(this.mouseActionStartPoint.getY(), event.getY()));
                this.root.zoomRect.setLayoutX(upperleft.getX() + this.zoomRectLayoutShift.getX());
                this.root.zoomRect.setLayoutY(upperleft.getY() + this.zoomRectLayoutShift.getY());
                this.root.zoomRect.setWidth(bottomRight.getX() - upperleft.getX());
                this.root.zoomRect.setHeight(bottomRight.getY() - upperleft.getY());
            } else {
                double dragFractionX = (event.getX() - this.mouseActionStartPoint.getX()) / handleNode.getWidth();
                double dragFractionY = (event.getY() - this.mouseActionStartPoint.getY()) / handleNode.getHeight();
                this.mouseHandler.scrollXByFraction(dragFractionX);
                this.mouseHandler.scrollYByFraction(dragFractionY);
            }
        });
        handleNode.setOnMouseReleased(event -> {
            if (event.isControlDown()) {
                double layoutX = this.root.zoomRect.getLayoutX() - this.zoomRectLayoutShift.getX();
                double layoutY = this.root.zoomRect.getLayoutY() - this.zoomRectLayoutShift.getY();
                double leftFraction = layoutX / handleNode.getWidth();
                double rightFraction = (handleNode.getWidth() - layoutX - this.root.zoomRect.getWidth()) / handleNode.getWidth();
                double bottomFraction = (handleNode.getHeight() - layoutY - this.root.zoomRect.getHeight()) / handleNode.getHeight();
                double topFraction = layoutY / handleNode.getHeight();
                this.mouseHandler.zoomByRect(leftFraction, rightFraction, bottomFraction, topFraction);
            }
            this.root.zoomRect.setVisible(false);
            this.root.zoomRect.setManaged(false);
            this.root.zoomRect.setWidth(0.0);
            this.root.zoomRect.setHeight(0.0);
        });
    }

    protected ObservableList<XYChart.Series<Number, Number>> getLineChartData(SNumbers sNumbers) {
        int xAxisLabelsColumnIndex = this.xAxisLabelsIndex.getValue();
        Number[] xAxisLabels = xAxisLabelsColumnIndex < 0 ? (Number[])IntStream.range(0, sNumbers.n()).boxed().toArray(Number[]::new) : (sNumbers.isFloatingPoint() ? (Number[])DoubleStream.of(sNumbers.column(xAxisLabelsColumnIndex).toDoubleArray()).boxed().toArray(Number[]::new) : (Number[])LongStream.of(sNumbers.column(xAxisLabelsColumnIndex).toLongArray()).boxed().toArray(Long[]::new));
        return this.getChartData(sNumbers, xAxisLabels);
    }

    protected ObservableList<XYChart.Series<String, Number>> getBarChartData(SNumbers sNumbers) {
        String[] xAxisLabels = (String[])IntStream.range(0, sNumbers.n()).mapToObj(Integer::toString).toArray(String[]::new);
        return this.getChartData(sNumbers, xAxisLabels);
    }

    private <T> ObservableList<XYChart.Series<T, Number>> getChartData(SNumbers sNumbers, T[] xAxisValues) {
        int sampleLength = sNumbers.n();
        ObservableList selectedDataSamples = this.root.cbYAxisSelector.getCheckModel().getCheckedIndices();
        return selectedDataSamples.stream().map(sampleIndex -> {
            String sampleName = String.format("Line #%d", sampleIndex + 1);
            double[] sample = sNumbers.column(sampleIndex.intValue()).toDoubleArray();
            ObservableList data = IntStream.range(0, sampleLength).mapToObj(i -> new XYChart.Data(xAxisValues[i], (Object)sample[i])).collect(Collectors.toCollection(FXCollections::observableArrayList));
            return new XYChart.Series(sampleName, data);
        }).collect(Collectors.toCollection(FXCollections::observableArrayList));
    }

    protected double floorAxisRange(double axisLimit) {
        if (axisLimit < 0.0) {
            return -this.ceilAxisRange(-axisLimit);
        }
        if (axisLimit <= 1.0) {
            return 0.0;
        }
        int length = 0;
        while (axisLimit > 1.0) {
            ++length;
            axisLimit /= 10.0;
        }
        double value = Math.floor(axisLimit * 10.0);
        double multiplier = Math.pow(10.0, length - 1);
        return value * multiplier;
    }

    protected double ceilAxisRange(double axisLimit) {
        if (axisLimit < 0.0) {
            return -this.ceilAxisRange(-axisLimit);
        }
        if (axisLimit == 0.0) {
            return 0.0;
        }
        if (axisLimit <= 1.0) {
            return 1.0;
        }
        int length = 0;
        while (axisLimit > 1.0) {
            ++length;
            axisLimit /= 10.0;
        }
        double value = Math.floor(Math.min(1.0, axisLimit + 0.1) * 10.0);
        double multiplier = Math.pow(10.0, length - 1);
        return value * multiplier;
    }

    private Optional<SNumbers> extractDefaultData(ViewerData viewerData) {
        Map<String, Data> map;
        SNumbers sNumbers = null;
        if (viewerData != null && (map = viewerData.getData()) != null) {
            for (String name : map.keySet()) {
                Data data = map.get(name);
                if (data == null || !SNumbers.class.isAssignableFrom(data.getClass())) continue;
                sNumbers = (SNumbers)data;
            }
        }
        return Optional.ofNullable(sNumbers);
    }

    private void initializeAxisDataSelectors(ViewerDataSource viewerDataSource) {
        viewerDataSource.getData().flatMap(this::extractDefaultData).ifPresent(sNumbers -> {
            int numberOfSamples = sNumbers.getBlockLength();
            StringConverter<Integer> strToIntConverterWithNone = new StringConverter<Integer>(this){

                public String toString(Integer integer) {
                    return integer < 0 ? "None" : integer.toString();
                }

                public Integer fromString(String s) {
                    return Integer.valueOf(s);
                }
            };
            ObservableList xSelectorItems = IntStream.range(-1, numberOfSamples).boxed().collect(Collectors.toCollection(FXCollections::observableArrayList));
            this.root.cbXAxisSelector.setCellFactory(arg_0 -> this.lambda$initializeAxisDataSelectors$19((StringConverter)strToIntConverterWithNone, arg_0));
            this.root.cbXAxisSelector.setConverter((StringConverter)strToIntConverterWithNone);
            this.root.cbXAxisSelector.setItems(xSelectorItems);
            this.root.cbXAxisSelector.getSelectionModel().select(0);
            ObservableList ySelectorItems = IntStream.range(0, numberOfSamples).boxed().collect(Collectors.toCollection(FXCollections::observableArrayList));
            this.root.cbYAxisSelector.getItems().addAll((Collection)ySelectorItems);
            this.root.cbYAxisSelector.getCheckModel().check(0);
        });
    }

    private /* synthetic */ ListCell lambda$initializeAxisDataSelectors$19(final StringConverter strToIntConverterWithNone, ListView integerListView) {
        return new ListCell<Integer>(this){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(strToIntConverterWithNone.toString((Object)item));
                }
            }
        };
    }

    private static class ChartViewerContent
    extends VBox {
        @FXML
        protected AnchorPane rasterContainer;
        @FXML
        private AnchorPane apChartContainer;
        @FXML
        private Rectangle zoomRect;
        @FXML
        private VBox vBoxZoomControls;
        @FXML
        protected Button btnZoomIn;
        @FXML
        protected Button btnZoomOut;
        @FXML
        private Button btnResetZoom;
        @FXML
        private VBox vBoxSettingsPanel;
        @FXML
        private ComboBox<Integer> cbXAxisSelector;
        @FXML
        private CheckComboBox<Integer> cbYAxisSelector;
        protected MenuButton mbView;
        private RadioMenuItem rmiLine;
        private RadioMenuItem rmiArea;
        private RadioMenuItem rmiHist;
        private CheckBox cbHideTicks;

        private ChartViewerContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
                this.initializeMenuView();
                this.initializeHideTicksAction();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
        }

        private void initializeMenuView() {
            this.rmiLine = new RadioMenuItem("Line");
            this.rmiArea = new RadioMenuItem("Area");
            this.rmiHist = new RadioMenuItem("Histogram");
            this.rmiLine.setSelected(true);
            this.rmiHist.setVisible(false);
            Menu menuChartType = new Menu("Chart type");
            menuChartType.getItems().addAll((Object[])new MenuItem[]{this.rmiLine, this.rmiArea, this.rmiHist});
            CheckMenuItem cmiZoomControls = new CheckMenuItem("Zoom controls");
            cmiZoomControls.setSelected(true);
            cmiZoomControls.selectedProperty().addListener((ob, o, selected) -> {
                this.vBoxZoomControls.setVisible(selected.booleanValue());
                this.vBoxZoomControls.setManaged(selected.booleanValue());
            });
            CheckMenuItem cmiSettingsPanel = new CheckMenuItem("Settings panel");
            cmiSettingsPanel.setSelected(true);
            cmiSettingsPanel.selectedProperty().addListener((ob, o, selected) -> {
                this.vBoxSettingsPanel.setVisible(selected.booleanValue());
                this.vBoxSettingsPanel.setManaged(selected.booleanValue());
            });
            this.mbView = new MenuButton("View");
            this.mbView.getItems().addAll((Object[])new MenuItem[]{menuChartType, cmiZoomControls, cmiSettingsPanel});
        }

        private void initializeHideTicksAction() {
            this.cbHideTicks = new CheckBox("Hide ticks");
        }
    }

    protected static interface ChartMouseHandler {
        public void zoomIn();

        public void zoomOut();

        public void zoomReset();

        default public void onScrollStart() {
        }

        public void scrollXByFraction(double var1);

        public void scrollYByFraction(double var1);

        public void zoomByRect(double var1, double var3, double var5, double var7);
    }
}

