/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ImageBorderViewerModel;
import com.siams.cv.monitor.model.viewer.ImageMaskViewerModel;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.CompareViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.cv.monitor.viewers.ui.content.ViewerStateHandler;
import com.siams.dialogs.DialogManager;
import com.siams.general.Deletable;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.algart.executors.api.data.SMat;

public abstract class CompareViewer
extends BaseImageViewer<CompareViewerModel>
implements ViewerStateHandler {
    private static final Logger logger = Logger.getLogger(CompareViewer.class.getCanonicalName());
    protected CompareViewerContent root;
    protected List<BaseImageViewer> viewers = new ArrayList<BaseImageViewer>();
    private Model.ModelChangeListener modelChangeListener = model -> {
        this.buildViewers();
        this.buildAccordionLayers();
    };

    public static CompareViewer instantiateWithDataSourceFactory(CompareViewerModel viewerModel, final Function<BlockViewerModel, ViewerDataSource> dataSourceFactory) {
        CompareViewer compareViewer = new CompareViewer(viewerModel){

            @Override
            protected ViewerDataSource createDataSource(BlockViewerModel blockModel) {
                return (ViewerDataSource)dataSourceFactory.apply(blockModel);
            }
        };
        compareViewer.initialize();
        return compareViewer;
    }

    protected CompareViewer(CompareViewerModel viewerModel) {
        super(viewerModel);
        viewerModel.addModelChangeListener(this.modelChangeListener);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.buildViewers();
    }

    @Override
    public void initializeRoot() {
        this.root = new CompareViewerContent();
        this.root.setOnBoundsChangedCallback(() -> this.renderImage(this.image));
        this.root.setCenteringStrategy(() -> {
            this.calculateMaxImageSize();
            double valX = (this.root.getCanvas().getWidth() - this.imageViewRect.getImageWidth() * this.imageViewRect.getScale()) / 2.0;
            double valY = (this.root.getCanvas().getHeight() - this.imageViewRect.getImageHeight() * this.imageViewRect.getScale()) / 2.0;
            this.imageViewRect.setX(valX);
            this.imageViewRect.setY(valY);
        });
        this.root.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.isAltDown()) {
                try {
                    int id = Integer.parseInt(keyEvent.getCode().getChar());
                    this.focusBenchmarkPoint(id);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public Pane provideControls() {
        Accordion accordion = this.root.getControlsContainer();
        AnchorPane wrap = new AnchorPane(new Node[]{accordion});
        PaneHelper.setAnchorZero((Node)accordion);
        return wrap;
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        return null;
    }

    @Override
    public List<Node> provideTools() {
        return List.of(this.root.getMenuView());
    }

    public <T extends BaseImageViewer> Optional<T> findViewer(UUID uid, Class<T> clazz) {
        return CollectionsUtils.findFirst(this.viewers, viewer -> viewer.getId().equals(uid), clazz);
    }

    @Override
    public void onChangeStageShowingProperty(Boolean showing) {
        if (showing.booleanValue()) {
            this.restorePreference();
        }
    }

    @Override
    public void onViewerDataReceived(ViewerData viewerData) {
    }

    @Override
    public void onViewerStateChanged() {
        for (BaseImageViewer viewer : this.viewers) {
            viewer.renderImage(viewer.image);
        }
        this.renderImage(null);
    }

    @Override
    public void onViewerKindChanged(BaseImageViewer viewer, ViewerKind newKind) {
        ImageViewerModel newModel = switch (newKind) {
            case ViewerKind.IMAGE -> new ImageViewerModel();
            case ViewerKind.BOUNDARIES -> new ImageBorderViewerModel();
            case ViewerKind.MASK -> new ImageMaskViewerModel();
            default -> throw new IllegalArgumentException(String.format("Failed change viewer kind, unsupported kind: %s", newKind));
        };
        Object currentViewerModel = viewer.getViewerModel();
        if (BlockViewerModel.class.isAssignableFrom(currentViewerModel.getClass())) {
            BlockViewerModel currentBlockViewerModel = (BlockViewerModel)currentViewerModel;
            newModel.setBlockUuid(currentBlockViewerModel.getBlockUuid());
        }
        newModel.setTitle(currentViewerModel.getTitle());
        BaseImageViewer newViewer = (BaseImageViewer)ViewerFactory.create(newKind, (ViewerModel)newModel);
        if (newViewer != null) {
            newViewer.setViewerDataSource(viewer.getViewerDataSource());
            newViewer.getViewerDataSource().rqViewerData();
            this.replaceViewer(viewer, newViewer);
        }
    }

    public void rqViewerData() {
        for (Viewer viewer : this.viewers) {
            viewer.getViewerDataSource().rqViewerData();
        }
    }

    @Override
    public void renderImage(Image image) {
        long t1 = System.currentTimeMillis();
        this.drawImage(null);
        logger.fine(String.format("CompareViewer:renderImage (%d) ms", System.currentTimeMillis() - t1));
    }

    public boolean hasViewer(UUID viewerId) {
        return this.viewers.stream().anyMatch(viewer -> viewer.getId().equals(viewerId));
    }

    public void addViewer(BaseImageViewer viewer, String title) {
        this.addViewer(viewer, this.viewers.size(), title);
    }

    @Override
    public void restorePreference() {
        FxPlatform.RunFxThread(() -> {
            this.buildViewers();
            this.buildAccordionLayers();
            this.viewers.forEach(RasterViewer::restorePreference);
            this.enableZoomControls(((CompareViewerModel)this.viewerModel).getDisplayZoomControls());
            this.root.getSpWorkspace().setDividerPositions(new double[]{((CompareViewerModel)this.viewerModel).getSplitterPosition()});
        });
    }

    @Override
    public void savePreference() {
        super.savePreference();
        this.viewers.forEach(BaseImageViewer::savePreference);
        ((CompareViewerModel)this.viewerModel).setDisplayZoomControls(Boolean.valueOf(this.root.getCheckMenuItemZoomControls().isSelected()));
        ((CompareViewerModel)this.viewerModel).setSplitterPosition(Double.valueOf(this.root.getSpWorkspace().getDividerPositions()[0]));
    }

    @Override
    public void release() {
        super.release();
        for (BaseImageViewer viewer : this.viewers) {
            viewer.release();
        }
        ((CompareViewerModel)this.viewerModel).removeModelChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.image = null;
        this.root.getChildren().clear();
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    protected abstract ViewerDataSource createDataSource(BlockViewerModel var1);

    @Override
    protected void render(ViewerData viewerData) {
    }

    @Override
    protected void onRasterContainerClicked(MouseEvent event) {
        super.onRasterContainerClicked(event);
        if (event.isAltDown()) {
            double x = (event.getX() - this.imageViewRect.getX()) / this.imageViewRect.getScale();
            double y = (event.getY() - this.imageViewRect.getY()) / this.imageViewRect.getScale();
            Point2D point = new Point2D(x, y);
            DialogManager.showTextInput((String)"Add benchmark point number, #:", (String)"", (String)"Add benchmark point").ifPresent(userInput -> {
                try {
                    int id = Integer.parseInt(userInput);
                    ((CompareViewerModel)this.viewerModel).addBenchmarkPoint(id, point);
                    this.updateBenchmarkPointsMenu(id);
                    this.drawBenchmarkPoints();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    protected void updatePixelValue(int mouseX, int mouseY) {
        if (this.imageViewRect == null) {
            return;
        }
        int x = (int)(((double)mouseX - this.imageViewRect.getX()) / this.imageViewRect.getScale());
        int y = (int)(((double)mouseY - this.imageViewRect.getY()) / this.imageViewRect.getScale());
        this.statusBar.setCrd(x, y);
        for (int itViewer = this.viewers.size() - 1; itViewer >= 0; --itViewer) {
            BaseImageViewer imageViewer = this.viewers.get(itViewer);
            if (!imageViewer.isEnabled() || !(imageViewer.getOpacity() > 0.0)) continue;
            double[] values = imageViewer.getPixelValue(x, y);
            if (values == null) {
                this.statusBar.setStatus("Pixel value can't be displayed, data is null");
                return;
            }
            String format = "%.4f";
            String[] colorNames = new String[]{"R=", "G=", "B=", "\u03b1="};
            CharSequence[] pixelValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                pixelValues[i] = (values.length == 3 || values.length == 4 ? colorNames[i] : "") + String.format(Locale.US, "%.4f", values[i]);
            }
            this.statusBar.setStatus(String.join((CharSequence)", ", pixelValues));
            break;
        }
    }

    @Override
    protected void drawImage(Image image) {
        if (!this.imageViewRect.isDragHappened()) {
            this.root.center();
        }
        Canvas canvas = this.root.getCanvas();
        GraphicsContext context = canvas.getGraphicsContext2D();
        double finalX = this.imageViewRect.getX() + this.imageViewRect.getTranslateX();
        double finalY = this.imageViewRect.getY() + this.imageViewRect.getTranslateY();
        double scale = this.imageViewRect.getScale();
        context.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        for (BaseImageViewer viewer : this.viewers) {
            Image currentImage;
            if (!viewer.isEnabled() || (currentImage = viewer.image) == null) continue;
            double iw = currentImage.getWidth();
            double ih = currentImage.getHeight();
            context.setGlobalAlpha(viewer.getOpacity());
            context.drawImage(currentImage, 0.0, 0.0, iw, ih, finalX, finalY, iw * scale, ih * scale);
        }
        this.drawBenchmarkPoints();
    }

    private void replaceViewer(BaseImageViewer old, BaseImageViewer newer) {
        int index = ((CompareViewerModel)this.viewerModel).indexOf(old.getId());
        ((CompareViewerModel)this.viewerModel).removeViewerModelById(old.getId()).ifPresent(Deletable::release);
        ((CompareViewerModel)this.viewerModel).addViewerModel(index, newer.getViewerModel());
        Accordion accordion = this.root.getControlsContainer();
        ((TitledPane)accordion.getPanes().get(index)).setExpanded(true);
    }

    private void addViewer(BaseImageViewer viewer, int position, String title) {
        viewer.setViewerStateHandler(this);
        viewer.rerender();
        this.viewers.add(position, viewer);
        ((CompareViewerModel)this.viewerModel).addViewerModel(viewer.getViewerModel());
        TitledPane layerPane = this.createLayerTitledPane(viewer, title);
        Accordion accordion = this.root.getControlsContainer();
        accordion.getPanes().add(position, (Object)layerPane);
    }

    private void removeViewer(BaseImageViewer viewer) {
        ((CompareViewerModel)this.viewerModel).removeViewerModelById(viewer.getId()).ifPresent(Deletable::release);
    }

    private void calculateMaxImageSize() {
        double width = Double.MIN_VALUE;
        double height = Double.MIN_VALUE;
        for (BaseImageViewer viewer : this.viewers) {
            if (!viewer.getRasterData().isPresent()) continue;
            SMat sMat = viewer.getRasterData().get();
            width = Math.max((double)sMat.getDimX(), width);
            height = Math.max((double)sMat.getDimY(), height);
        }
        width = width == Double.MIN_VALUE ? 0.0 : width;
        height = height == Double.MIN_VALUE ? 0.0 : height;
        this.imageViewRect.setImageSize((int)width, (int)height);
    }

    private void buildViewers() {
        for (Viewer viewer : this.viewers) {
            viewer.savePreference();
            viewer.release();
        }
        this.viewers.clear();
        List viewerModels = ((CompareViewerModel)this.viewerModel).getViewerModels();
        CompletableFuture[] completableFutureArray = new CompletableFuture[viewerModels.size()];
        for (int i = 0; i < viewerModels.size(); ++i) {
            ViewerModel viewerModel = (ViewerModel)viewerModels.get(i);
            ViewerKind kind = ViewerKind.IMAGE;
            try {
                kind = ViewerKind.valueOf((String)viewerModel.getKind().toUpperCase());
            }
            catch (IllegalArgumentException t) {
                logger.severe(String.format("Unsupported viewer kind '%s' used 'IMAGE' by default", viewerModel.getKind()));
            }
            BaseImageViewer viewer = (BaseImageViewer)ViewerFactory.create(kind, viewerModel);
            if (viewer == null) continue;
            viewer.setViewerStateHandler(this);
            if (BlockViewerModel.class.isAssignableFrom(viewerModel.getClass())) {
                BlockViewerModel blockViewerModel = (BlockViewerModel)viewerModel;
                ViewerDataSource dataSource = this.createDataSource(blockViewerModel);
                viewer.setViewerDataSource(dataSource);
            }
            completableFutureArray[i] = viewer.getViewerDataSource().rqViewerData();
            viewer.restorePreference();
            this.viewers.add(viewer);
        }
        CompletableFuture<Void> awaitAllResults = CompletableFuture.allOf(completableFutureArray);
        try {
            awaitAllResults.get();
        }
        catch (Exception e) {
            StareNotification.showWarn((String)e.getMessage());
        }
    }

    private void buildAccordionLayers() {
        FxPlatform.RunFxThread(() -> {
            Accordion accordion = this.root.getControlsContainer();
            accordion.getPanes().clear();
            for (int position = 0; position < this.viewers.size(); ++position) {
                BaseImageViewer viewer = this.viewers.get(position);
                TitledPane layerPane = this.createLayerTitledPane(viewer, viewer.getTitle());
                accordion.getPanes().add(position, (Object)layerPane);
            }
        });
    }

    private TitledPane createLayerTitledPane(BaseImageViewer viewer, String title) {
        String viewerId = viewer.getId().toString();
        CheckBox cbEnabled = new CheckBox("enable");
        cbEnabled.setSelected(viewer.isEnabled());
        cbEnabled.selectedProperty().bindBidirectional((Property)viewer.getPropertyEnabled());
        cbEnabled.setOnAction(event -> {
            viewer.renderImage(viewer.getImage());
            this.renderImage(null);
        });
        Button btnRemoveLayer = new Button("x");
        btnRemoveLayer.setOnAction(event -> {
            this.removeViewer(viewer);
            this.renderImage(null);
        });
        HBox paneHeader = new HBox(5.0, new Node[]{cbEnabled, btnRemoveLayer});
        paneHeader.setAlignment(Pos.CENTER);
        TitledPane layerPane = new TitledPane(title, (Node)viewer.provideControls());
        layerPane.setAnimated(false);
        layerPane.setGraphicTextGap(10.0);
        layerPane.setId(viewerId);
        layerPane.setAlignment(Pos.CENTER_RIGHT);
        layerPane.setContentDisplay(ContentDisplay.RIGHT);
        layerPane.setGraphic((Node)paneHeader);
        layerPane.setOnDragDetected(event -> {
            if (this.root.getControlsContainer().getPanes().size() < 2) {
                return;
            }
            event.consume();
            layerPane.startFullDrag();
            Dragboard dragboard = layerPane.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ClipboardContent content = new ClipboardContent();
            content.putString(layerPane.getId());
            dragboard.setContent((Map)content);
        });
        layerPane.setOnDragOver(event -> {
            event.consume();
            if (!layerPane.getId().equals(event.getDragboard().getString())) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
        });
        layerPane.setOnDragDropped(event -> {
            event.consume();
            event.setDropCompleted(true);
            TitledPane movingLayer = (TitledPane)event.getGestureSource();
            TitledPane hoverLayer = (TitledPane)event.getGestureTarget();
            UUID movingViewerId = UUID.fromString(movingLayer.getId());
            UUID hoverViewerId = UUID.fromString(hoverLayer.getId());
            ((CompareViewerModel)this.viewerModel).swapViewerModels(movingViewerId, hoverViewerId);
        });
        return layerPane;
    }

    private void updateBenchmarkPointsMenu(int pointID) {
        MenuItem item2;
        ObservableList items = this.root.getMenuBenchmarkPoints().getItems();
        if (items.stream().anyMatch(item -> Integer.valueOf(pointID).equals(item.getUserData()))) {
            return;
        }
        MenuItem newPointItem = new MenuItem(String.format("Benchmark point #%d", pointID));
        newPointItem.setUserData((Object)pointID);
        newPointItem.setOnAction(event -> this.focusBenchmarkPoint(pointID));
        int insertIndex = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (item2 = (MenuItem)iterator.next()).getUserData() != null && (Integer)item2.getUserData() <= pointID) {
            ++insertIndex;
        }
        items.add(insertIndex, (Object)newPointItem);
    }

    private void drawBenchmarkPoints() {
        Canvas canvas = this.root.getCanvas();
        GraphicsContext context = canvas.getGraphicsContext2D();
        double finalX = this.imageViewRect.getX() + this.imageViewRect.getTranslateX();
        double finalY = this.imageViewRect.getY() + this.imageViewRect.getTranslateY();
        double scale = this.imageViewRect.getScale();
        int BENCHMARK_POINT_SIZE = scale > 1.0 ? 9 + (int)(Math.log(scale) / Math.log(2.0)) * 2 : 9 - (int)(Math.log(1.0 / scale) / Math.log(2.0)) * 2;
        context.save();
        for (int i = 0; i < 10; ++i) {
            Optional optPoint = ((CompareViewerModel)this.viewerModel).getBenchmarkPoint(i);
            if (!optPoint.isPresent()) continue;
            Point2D point = (Point2D)optPoint.get();
            double x = Math.floor(point.getX()) * scale + finalX;
            double y = Math.floor(point.getY()) * scale + finalY;
            context.setStroke((Paint)Color.WHITE);
            context.strokeRect(x, y, (double)BENCHMARK_POINT_SIZE, (double)BENCHMARK_POINT_SIZE);
            context.setStroke((Paint)Color.BLACK);
            context.strokeRect(x - 1.0, y - 1.0, (double)(BENCHMARK_POINT_SIZE + 2), (double)(BENCHMARK_POINT_SIZE + 2));
        }
        context.restore();
    }

    private void focusBenchmarkPoint(int pointID) {
        ((CompareViewerModel)this.viewerModel).getBenchmarkPoint(pointID).ifPresentOrElse(benchmarkPoint -> {
            double viewPortW = this.root.getRasterContainer().getWidth() * 0.5;
            double viewPortH = this.root.getRasterContainer().getHeight() * 0.5;
            double newX = benchmarkPoint.getX() * this.imageViewRect.getScale() - viewPortW;
            double newY = benchmarkPoint.getY() * this.imageViewRect.getScale() - viewPortH;
            this.imageViewRect.setX(-newX);
            this.imageViewRect.setY(-newY);
            this.drawImage(null);
        }, () -> StareNotification.showInfo((String)"No such benchmark point"));
    }
}

