/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class CompareViewerContent
extends VBox
implements IBaseImageViewerContent,
Initializable,
UIPreference {
    @FXML
    private SplitPane spWorkspace;
    @FXML
    private AnchorPane viewContainer;
    @FXML
    private Canvas canvas;
    @FXML
    private Rectangle highlighter;
    @FXML
    private VBox vBoxZoomControls;
    @FXML
    private Button btnZoomIn;
    @FXML
    private Button btnZoomOut;
    @FXML
    private Button btnResetZoom;
    @FXML
    private Accordion controlsContainer;
    @FXML
    private AnchorPane apStatusBarHolder;
    private MenuButton mbView;
    private CheckMenuItem cmiZoomControls;
    private Menu menuBenchmarkPoints;
    private Runnable centeringStrategy = null;
    private Runnable onBoundsChangedCallback = null;

    CompareViewerContent() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initializeCanvas();
        this.initializeMenuView();
        this.viewContainer.layoutBoundsProperty().addListener((ob, o, n) -> {
            this.canvas.setWidth(n.getWidth());
            this.canvas.setHeight(n.getHeight());
            if (this.onBoundsChangedCallback != null) {
                this.onBoundsChangedCallback.run();
            }
        });
    }

    private void initializeCanvas() {
        this.canvas.getGraphicsContext2D().setImageSmoothing(false);
        this.canvas.getGraphicsContext2D().setFill((Paint)Color.IVORY);
    }

    private void initializeMenuView() {
        this.cmiZoomControls = new CheckMenuItem("Zoom controls");
        this.cmiZoomControls.setSelected(true);
        MenuItem miBenchmarkHelp = new MenuItem("Help");
        miBenchmarkHelp.setOnAction(action -> this.onBenchmarkPointsHelpRequested());
        this.menuBenchmarkPoints = new Menu("Benchmark points");
        this.menuBenchmarkPoints.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), miBenchmarkHelp});
        this.mbView = new MenuButton("View");
        this.mbView.getItems().addAll((Object[])new MenuItem[]{this.cmiZoomControls, new SeparatorMenuItem(), this.menuBenchmarkPoints});
    }

    private void onBenchmarkPointsHelpRequested() {
        String helpText = "Do the Alt+LeftClick on the image to save clicked pixel as benchmark point.\n\nIn the prompt window type the number [0..9] of the saving benchmark point.\nYou can overwrite already saved points.\n\nPress Alt+#, where # is number of the benchmark point, to focus on the saved point.";
        Label hint = new Label("Do the Alt+LeftClick on the image to save clicked pixel as benchmark point.\n\nIn the prompt window type the number [0..9] of the saving benchmark point.\nYou can overwrite already saved points.\n\nPress Alt+#, where # is number of the benchmark point, to focus on the saved point.");
        hint.setFont(new Font(14.0));
        StackPane pane = new StackPane(new Node[]{hint});
        StackPane.setMargin((Node)hint, (Insets)new Insets(3.0));
        pane.setStyle("-fx-background-color: white;\n-fx-border-width: 1;\n-fx-border-color: darkgrey");
        Stage helpPopup = new Stage(StageStyle.UTILITY);
        helpPopup.setTitle("Benchmark points tutorial");
        helpPopup.setScene(new Scene((Parent)pane));
        helpPopup.initOwner(this.getScene().getWindow());
        helpPopup.show();
    }

    @Override
    public Rectangle getHighlighter() {
        return this.highlighter;
    }

    @Override
    public Pane getRasterContainer() {
        return this.viewContainer;
    }

    @Override
    public Pane getRoot() {
        return this;
    }

    @Override
    public Pane getStatusBarHolder() {
        return this.apStatusBarHolder;
    }

    @Override
    public Node getZoomControls() {
        return this.vBoxZoomControls;
    }

    @Override
    public MenuButton getMenuView() {
        return this.mbView;
    }

    @Override
    public CheckMenuItem getCheckMenuItemZoomControls() {
        return this.cmiZoomControls;
    }

    @Override
    public Button getButtonZoomIn() {
        return this.btnZoomIn;
    }

    @Override
    public Button getButtonZoomOut() {
        return this.btnZoomOut;
    }

    @Override
    public Button getButtonResetZoom() {
        return this.btnResetZoom;
    }

    public Accordion getControlsContainer() {
        return this.controlsContainer;
    }

    public SplitPane getSpWorkspace() {
        return this.spWorkspace;
    }

    public ObservableList<MenuItem> getViewMenuItems() {
        return this.mbView.getItems();
    }

    public Menu getMenuBenchmarkPoints() {
        return this.menuBenchmarkPoints;
    }

    public void setCenteringStrategy(Runnable centeringStrategy) {
        this.centeringStrategy = centeringStrategy;
    }

    public void setOnBoundsChangedCallback(Runnable onBoundsChangedCallback) {
        this.onBoundsChangedCallback = onBoundsChangedCallback;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void center() {
        if (this.centeringStrategy != null) {
            this.centeringStrategy.run();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> ((CompareViewerContent)this).restorePreference());
    }
}

