/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.CropViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.CropViewRect;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerStateHandler;
import com.siams.stare.utils.Rect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import net.algart.executors.api.data.SMat;

public class CropViewer
extends BaseImageViewer<CropViewerModel> {
    private static final Logger logger = Logger.getLogger(CropViewer.class.getCanonicalName());
    private static final double MIN_CROP_AREA_SIZE = 20.0;
    private CropViewerContent root;
    private Consumer<Map<String, Object>> saveCallback;

    public CropViewer(CropViewerModel model) {
        super(model);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.viewerStateHandler = new CropStateHandler();
        this.initializeCropArea();
    }

    @Override
    protected void initializeRoot() {
        this.root = new CropViewerContent((CropViewerModel)this.viewerModel);
        this.root.setOnBoundsChangedCallback(() -> this.renderImage(this.image));
    }

    @Override
    public void initializeImageViewRect() {
        this.imageViewRect = new CropViewRect();
    }

    private void initializeCropArea() {
        ((CropViewRect)this.imageViewRect).bindSelectionMode(this.root.tbSelectionMode.selectedProperty());
        ((CropViewRect)this.imageViewRect).setCropArea(this.root.cropArea);
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        System.err.println("Embedding logic not implemented for CropViewer");
        logger.warning("Embedding logic not implemented for CropViewer");
        return null;
    }

    @Override
    public List<Node> provideTools() {
        List<Node> baseTools = super.provideTools();
        baseTools.add((Node)this.root.btnSave);
        baseTools.add((Node)this.root.tbSelectionMode);
        return baseTools;
    }

    @Override
    protected void render(ViewerData viewerData) {
        SMat data = this.extractDefaultData(viewerData);
        Image image = this.preprocessImage(data);
        this.setImage(image);
        this.renderImage(image);
    }

    protected Image preprocessImage(SMat data) {
        return RasterViewer.writableImageFromSMat(data);
    }

    public void setSaveCallback(Consumer<Map<String, Object>> saveCallback) {
        this.saveCallback = saveCallback;
    }

    private class CropStateHandler
    implements ViewerStateHandler {
        private CropStateHandler() {
        }

        @Override
        public void onViewerStateChanged() {
            Rect imageCrop = ((CropViewRect)CropViewer.this.imageViewRect).getCropRect();
            double scale = CropViewer.this.imageViewRect.getScale();
            double screenX = imageCrop.getX() * scale + CropViewer.this.imageViewRect.getX() + CropViewer.this.imageViewRect.getTranslateX();
            double screenY = imageCrop.getY() * scale + CropViewer.this.imageViewRect.getY() + CropViewer.this.imageViewRect.getTranslateY();
            double screenWidth = imageCrop.getWidth() * scale;
            double screenHeight = imageCrop.getHeight() * scale;
            CropViewer.this.root.cropArea.setLayoutX(screenX);
            CropViewer.this.root.cropArea.setLayoutY(screenY);
            CropViewer.this.root.cropArea.setPrefWidth(screenWidth);
            CropViewer.this.root.cropArea.setPrefHeight(screenHeight);
        }

        @Override
        public void onViewerKindChanged(BaseImageViewer viewer, ViewerKind newKind) {
        }
    }

    private class CropViewerContent
    extends BaseImageViewerContent<CropViewerModel> {
        @FXML
        private Group groupCrop;
        @FXML
        private AnchorPane cropArea;
        @FXML
        private Rectangle ltControl;
        @FXML
        private Rectangle lbControl;
        @FXML
        private Rectangle rtControl;
        @FXML
        private Rectangle rbControl;
        private Button btnSave;
        private ToggleButton tbSelectionMode;
        private Rectangle draggedRectangle;
        private Bounds startBounds;

        CropViewerContent(CropViewerModel viewerModel) {
            super(viewerModel);
            this.initializeClipping();
            this.initializeButtons();
            this.initializeEvents();
        }

        private void initializeClipping() {
            Rectangle clipShape = new Rectangle();
            clipShape.widthProperty().bind((ObservableValue)this.rasterContainer.widthProperty());
            clipShape.heightProperty().bind((ObservableValue)this.rasterContainer.heightProperty());
            this.rasterContainer.setClip((Node)clipShape);
        }

        private void initializeButtons() {
            this.btnSave = new Button("Save crop");
            this.btnSave.setOnAction(event -> {
                Map<String, Object> properties = this.calculateCropParameters();
                CropViewer.this.saveCallback.accept(properties);
                this.getScene().getWindow().hide();
            });
            this.tbSelectionMode = new ToggleButton("Selection mode");
        }

        private void initializeEvents() {
            this.setupEvents((Node)this.ltControl);
            this.setupEvents((Node)this.lbControl);
            this.setupEvents((Node)this.rbControl);
            this.setupEvents((Node)this.rtControl);
            this.rasterContainer.addEventHandler(DragEvent.DRAG_OVER, event -> {
                event.consume();
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                if (this.draggedRectangle != null) {
                    this.resizeByControl((DragEvent)event);
                    logger.info(String.format("CA: x=%f y=%f %f:%f", this.cropArea.getLayoutX(), this.cropArea.getLayoutY(), this.cropArea.getWidth(), this.cropArea.getHeight()));
                }
            });
            this.rasterContainer.addEventHandler(DragEvent.DRAG_DROPPED, event -> {
                event.consume();
                if (this.draggedRectangle != null) {
                    this.draggedRectangle = null;
                    ((CropViewRect)CropViewer.this.imageViewRect).screenToRect();
                }
                event.setDropCompleted(true);
            });
            this.viewerRoot.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                event.consume();
                if (event.getCode().equals((Object)KeyCode.CONTROL)) {
                    this.tbSelectionMode.setSelected(true);
                }
            });
            this.viewerRoot.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                event.consume();
                if (event.getCode().equals((Object)KeyCode.CONTROL)) {
                    this.tbSelectionMode.setSelected(false);
                }
            });
        }

        private void setupEvents(Node cropControl) {
            cropControl.setOnDragDetected(event -> {
                Object source = event.getSource();
                this.draggedRectangle = (Rectangle)source;
                this.startBounds = new BoundingBox(this.cropArea.getLayoutX(), this.cropArea.getLayoutY(), this.cropArea.getWidth(), this.cropArea.getHeight());
                Dragboard dragboard = this.draggedRectangle.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                HashMap<DataFormat, String> m = new HashMap<DataFormat, String>();
                m.put(DataFormat.PLAIN_TEXT, this.draggedRectangle.getId());
                dragboard.setContent(m);
                event.consume();
            });
        }

        private void resizeByControl(DragEvent event) {
            double newLayoutX = this.cropArea.getLayoutX();
            double newLayoutY = this.cropArea.getLayoutY();
            double newWidth = this.cropArea.getWidth();
            double newHeight = this.cropArea.getHeight();
            double trX = CropViewer.this.imageViewRect.getTranslateX();
            double trY = CropViewer.this.imageViewRect.getTranslateY();
            switch (this.draggedRectangle.getId()) {
                case "ltControl": {
                    newLayoutX = Math.max(trX, event.getX());
                    newWidth = this.startBounds.getMinX() + this.startBounds.getWidth() - newLayoutX;
                    newLayoutY = Math.max(trY, event.getY());
                    newHeight = this.startBounds.getMinY() + this.startBounds.getHeight() - newLayoutY;
                    break;
                }
                case "rtControl": {
                    newWidth = event.getX() - this.cropArea.getLayoutX();
                    if (CropViewer.this.imageViewRect.screenToImageX(newLayoutX + newWidth) > CropViewer.this.imageViewRect.getImageWidth()) {
                        newWidth = CropViewer.this.imageViewRect.getImageWidth() - CropViewer.this.imageViewRect.screenToImageX(newLayoutX);
                        newWidth *= CropViewer.this.imageViewRect.getScale();
                    }
                    newLayoutY = Math.max(trY, event.getY());
                    newHeight = this.startBounds.getMinY() + this.startBounds.getHeight() - newLayoutY;
                    break;
                }
                case "rbControl": {
                    newWidth = event.getX() - this.cropArea.getLayoutX();
                    if (CropViewer.this.imageViewRect.screenToImageX(newLayoutX + newWidth) > CropViewer.this.imageViewRect.getImageWidth()) {
                        newWidth = CropViewer.this.imageViewRect.getImageWidth() - CropViewer.this.imageViewRect.screenToImageX(newLayoutX);
                        newWidth *= CropViewer.this.imageViewRect.getScale();
                    }
                    if (!(CropViewer.this.imageViewRect.screenToImageY(newLayoutY + (newHeight = event.getY() - this.cropArea.getLayoutY())) > CropViewer.this.imageViewRect.getImageHeight())) break;
                    newHeight = CropViewer.this.imageViewRect.getImageHeight() - CropViewer.this.imageViewRect.screenToImageY(newLayoutY);
                    newHeight *= CropViewer.this.imageViewRect.getScale();
                    break;
                }
                case "lbControl": {
                    newLayoutX = Math.max(trX, event.getX());
                    newWidth = this.startBounds.getMinX() + this.startBounds.getWidth() - newLayoutX;
                    newHeight = event.getY() - this.cropArea.getLayoutY();
                    if (!(CropViewer.this.imageViewRect.screenToImageY(newLayoutY + newHeight) > CropViewer.this.imageViewRect.getImageHeight())) break;
                    newHeight = CropViewer.this.imageViewRect.getImageHeight() - CropViewer.this.imageViewRect.screenToImageY(newLayoutY);
                    newHeight *= CropViewer.this.imageViewRect.getScale();
                    break;
                }
                default: {
                    logger.info("Try to resize cropArea by unknown Node.");
                }
            }
            if (newWidth < 20.0) {
                newWidth = 20.0;
                newLayoutX = this.cropArea.getLayoutX();
            }
            if (newHeight < 20.0) {
                newHeight = 20.0;
                newLayoutY = this.cropArea.getLayoutY();
            }
            if (CropViewer.this.imageViewRect.screenToImageX(newLayoutX) >= 0.0) {
                this.cropArea.setLayoutX(newLayoutX);
                this.cropArea.setPrefWidth(newWidth);
            }
            if (CropViewer.this.imageViewRect.screenToImageY(newLayoutY) >= 0.0) {
                this.cropArea.setLayoutY(newLayoutY);
                this.cropArea.setPrefHeight(newHeight);
            }
        }

        private Map<String, Object> calculateCropParameters() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Rect cropRect = ((CropViewRect)CropViewer.this.imageViewRect).getCropRect();
            double cropLeft = cropRect.getX();
            double cropTop = cropRect.getY();
            double cropRight = cropRect.getX2();
            double cropBottom = cropRect.getY2();
            boolean usePercent = false;
            properties.put("left", cropLeft);
            properties.put("top", cropTop);
            properties.put("width", cropRight - cropLeft);
            properties.put("height", cropBottom - cropTop);
            properties.put("right", cropRight);
            properties.put("bottom", cropBottom);
            properties.put("percents", false);
            return properties;
        }

        @Override
        public void center() {
            double valX = (this.canvas.getWidth() - CropViewer.this.image.getWidth() * CropViewer.this.imageViewRect.getScale()) / 2.0;
            double valY = (this.canvas.getHeight() - CropViewer.this.image.getHeight() * CropViewer.this.imageViewRect.getScale()) / 2.0;
            CropViewer.this.imageViewRect.setX(valX);
            CropViewer.this.imageViewRect.setY(valY);
        }
    }
}

