/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.converter.DoubleToString;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.ImageViewer;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import net.algart.executors.api.data.SMat;

class ImageViewerControls
extends BaseImageViewerControls<ImageViewer> {
    @FXML
    private CheckBox cbAutoContrast;
    @FXML
    private VBox vbRangeThreshold;
    @FXML
    private CheckBox cbRangeEnable;
    @FXML
    private CheckBox cbRangeInvert;
    @FXML
    private Spinner<Double> spRangeMin;
    @FXML
    private Spinner<Double> spRangeMax;
    @FXML
    private CheckBox cbRangeRawValues;

    ImageViewerControls(ImageViewer viewer) {
        super(viewer);
    }

    @Override
    public void init() {
        super.init();
        this.initializeAutoContrast();
        this.initializeRangeControls();
    }

    private void initializeAutoContrast() {
        this.cbAutoContrast.setOnAction(event -> {
            ((ImageViewer)this.viewer).setAutoContrastEnabled(this.cbAutoContrast.isSelected());
            this.preprocessViewerImage();
        });
    }

    private void initializeRangeControls() {
        this.cbRangeEnable.setOnAction(event -> {
            ((ImageViewer)this.viewer).setRangeEnabled(this.cbRangeEnable.isSelected());
            this.preprocessViewerImage();
        });
        this.cbRangeInvert.setOnAction(event -> {
            ((ImageViewer)this.viewer).setRangeInverted(this.cbRangeInvert.isSelected());
            this.preprocessViewerImage();
        });
        this.spRangeMin.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, 0.0, 0.05));
        this.spRangeMin.getValueFactory().setConverter((StringConverter)new DoubleToString());
        this.spRangeMin.valueProperty().addListener((observable, oldValue, newValue) -> {
            ((ImageViewer)this.viewer).setRangeMin((double)newValue);
            this.preprocessViewerImage();
        });
        this.spRangeMax.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, 0.5, 0.05));
        this.spRangeMax.getValueFactory().setConverter((StringConverter)new DoubleToString());
        this.spRangeMax.valueProperty().addListener((observable, oldValue, newValue) -> {
            ((ImageViewer)this.viewer).setRangeMax((double)newValue);
            this.preprocessViewerImage();
        });
        this.cbRangeRawValues.setOnAction(event -> {
            boolean isRawValues = this.cbRangeRawValues.isSelected();
            double currentMinValue = (Double)this.spRangeMin.getValue();
            double currentMaxValue = (Double)this.spRangeMax.getValue();
            if (isRawValues) {
                ((ImageViewer)this.viewer).getViewerDataSource().getData().flatMap(viewerData -> viewerData.get("output", SMat.class)).ifPresent(sMat -> {
                    double max;
                    double min;
                    double step = switch (sMat.getDepth()) {
                        case SMat.Depth.BIT -> {
                            min = 0.0;
                            max = 1.0;
                            yield 1.0;
                        }
                        case SMat.Depth.S8 -> {
                            min = -128.0;
                            max = 127.0;
                            yield 1.0;
                        }
                        case SMat.Depth.U8 -> {
                            min = 0.0;
                            max = 255.0;
                            yield 1.0;
                        }
                        case SMat.Depth.S16 -> {
                            min = -32768.0;
                            max = 32767.0;
                            yield 1.0;
                        }
                        case SMat.Depth.U16 -> {
                            min = 0.0;
                            max = 65535.0;
                            yield 1.0;
                        }
                        case SMat.Depth.S32 -> {
                            min = -2.147483648E9;
                            max = 2.147483647E9;
                            yield 1.0;
                        }
                        case SMat.Depth.F32, SMat.Depth.F64 -> {
                            min = 0.0;
                            max = Double.MAX_VALUE;
                            yield 0.05;
                        }
                        default -> throw new IllegalStateException("Unexpected SMat.Depth value: " + String.valueOf(sMat.getDepth()));
                    };
                    this.spRangeMin.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, currentMinValue, step));
                    this.spRangeMax.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, currentMaxValue, step));
                });
            } else {
                this.spRangeMin.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, currentMinValue, 0.05));
                this.spRangeMax.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, currentMaxValue, 0.05));
            }
            ((ImageViewer)this.viewer).setRangeRawValues(isRawValues);
            this.preprocessViewerImage();
        });
    }

    @Override
    void enableFeature(BaseImageViewer.Feature feature, boolean enabled) {
        super.enableFeature(feature, enabled);
        switch (feature) {
            case RANGE_THRESHOLD: {
                if (this.vbRangeThreshold == null) break;
                this.vbRangeThreshold.setManaged(enabled);
                this.vbRangeThreshold.setVisible(enabled);
                this.vbRangeThreshold.setDisable(enabled);
                break;
            }
            case AUTO_CONTRAST: {
                if (this.cbAutoContrast == null) break;
                this.cbAutoContrast.setManaged(enabled);
                this.cbAutoContrast.setVisible(enabled);
                this.cbAutoContrast.setDisable(enabled);
            }
        }
    }

    public void restorePreference() {
        ImageViewerModel imageViewerModel = (ImageViewerModel)((ImageViewer)this.viewer).getViewerModel();
        this.cbAutoContrast.setSelected(imageViewerModel.getAutoContrastEnabled().booleanValue());
        this.cbRangeEnable.setSelected(imageViewerModel.getSimpleThresholdEnabled().booleanValue());
        this.cbRangeInvert.setSelected(imageViewerModel.getSimpleThresholdInverted().booleanValue());
        this.cbRangeRawValues.setSelected(imageViewerModel.getSimpleThresholdRawValues().booleanValue());
        this.spRangeMin.getEditor().setText(imageViewerModel.getSimpleThresholdRangeMin().toString());
        this.spRangeMax.getEditor().setText(imageViewerModel.getSimpleThresholdRangeMax().toString());
    }

    public void savePreference() {
    }
}

