/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.general.Deletable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.algart.executors.api.data.Data;

public class ViewerData
implements Deletable {
    private final Map<String, Data> data;
    private final VisibleResultMetaData meta;

    public ViewerData(Map<String, Data> data) {
        this.data = data;
        this.meta = new VisibleResultMetaData();
    }

    public ViewerData(Map<String, Data> data, VisibleResultMetaData meta) {
        this.data = data;
        this.meta = meta;
    }

    public Optional<Data> get(String name) {
        Objects.requireNonNull(name, "Name required");
        return Optional.ofNullable(this.data.get(name));
    }

    public void setData(String name, Data data) {
        this.data.put(name, data);
    }

    public Map<String, Data> getData() {
        return this.data;
    }

    public VisibleResultMetaData getMeta() {
        return this.meta;
    }

    public <T extends Data> Optional<T> get(String name, Class<T> clazz) {
        if (this.data == null) {
            return Optional.empty();
        }
        Data value = this.data.get(name);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(clazz.isAssignableFrom(value.getClass()) ? value : null);
    }

    public void clear() {
        this.data.clear();
    }

    public void release() {
        this.clear();
    }

    public String toString() {
        return String.format("ViewerData model=%s", this.meta.getModel());
    }
}

