/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.sph;

import com.siams.cv.monitor.model.viewer.SphKindModel;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxColor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.apache.log4j.Logger;

final class SphViewerKind
extends VBox {
    private final Logger logger = Logger.getLogger(SphViewerKind.class);
    @FXML
    Label lblName;
    @FXML
    CheckBox cbVisible;
    @FXML
    ColorPicker colorPicker;
    private SphKindModel sphKindModel;
    private List<SphKindChangeListener> changeListeners = new ArrayList<SphKindChangeListener>();

    SphViewerKind(SphKindModel sphKindModel) {
        Objects.requireNonNull(sphKindModel);
        this.sphKindModel = sphKindModel;
        this.initialize();
    }

    private void initialize() {
        this.initializeRoot();
        this.initializeControls();
    }

    private void initializeRoot() {
        try {
            CustomFXMLLoader.loadElement((Object)((Object)this));
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initializeControls() {
        this.lblName.setText(this.sphKindModel.getName());
        this.cbVisible.setSelected(this.sphKindModel.getVisible().booleanValue());
        this.cbVisible.setOnAction(event -> {
            this.sphKindModel.setVisible(Boolean.valueOf(this.cbVisible.isSelected()));
            this.invokeListeners(this.sphKindModel, this.sphKindModel);
        });
        this.colorPicker.setValue((Object)FxColor.toFxColor((String)this.sphKindModel.getColor()));
        this.colorPicker.setOnAction(event -> {
            this.sphKindModel.setColor(((Color)this.colorPicker.getValue()).toString());
            this.invokeListeners(this.sphKindModel, this.sphKindModel);
        });
    }

    public void addListener(SphKindChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeListener(SphKindChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void invokeListeners(SphKindModel oldValue, SphKindModel newValue) {
        this.changeListeners.forEach(listener -> listener.changed(null, oldValue, newValue));
    }

    static interface SphKindChangeListener
    extends ChangeListener<SphKindModel> {
    }
}

