/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.tools;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTool;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Circle;

public class CircleSelectionTool
extends SelectionTool {
    private Circle viewNode = new Circle();
    private Point3D model = new Point3D(25.0, 25.0, 25.0);
    private double scale = 1.0;
    private Point2D mouseGestureStartPoint = Point2D.ZERO;
    private Point3D startShape;
    private ResizeStrategy resizeStrategy = ResizeStrategy.NONE;

    CircleSelectionTool(Pane handlePane) {
        super(handlePane);
        this.setDefaultSize();
        this.updateModel(new Point3D(0.0, 0.0, 0.0), this.getViewNodeShape());
        this.viewNode.setVisible(false);
        this.viewNode.setManaged(false);
        handlePane.getChildren().add((Object)this.viewNode);
        this.initializeActiveProperty();
        this.initializeActions();
    }

    @Override
    public Node getView() {
        return this.viewNode;
    }

    @Override
    public List<SimplePrimitive> getModel() {
        return List.of(new SimplePrimitive("x", this.model.getX()), new SimplePrimitive("y", this.model.getY()), new SimplePrimitive("radius", this.model.getZ()));
    }

    @Override
    public String getName() {
        return "Circle";
    }

    @Override
    public void onHandlePaneClicked(MouseEvent event) {
    }

    @Override
    public Point2D getModelPosition() {
        return new Point2D(this.model.getX(), this.model.getY());
    }

    @Override
    public void setViewPosition(Point2D position) {
        this.viewNode.setCenterX(position.getX());
        this.viewNode.setCenterY(position.getY());
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
        this.viewNode.setRadius(this.model.getZ() * scale);
    }

    private Point3D getViewNodeShape() {
        return new Point3D(this.viewNode.getCenterX(), this.viewNode.getCenterY(), this.viewNode.getRadius());
    }

    private void setDefaultSize() {
        this.viewNode.setCenterX(25.0);
        this.viewNode.setCenterY(25.0);
        this.viewNode.setRadius(25.0);
    }

    private void initializeActiveProperty() {
        this.active.addListener((ob, o, n) -> {
            this.viewNode.setVisible(n.booleanValue());
            this.viewNode.setManaged(n.booleanValue());
        });
    }

    private void initializeActions() {
        this.viewNode.setOnMouseMoved(event -> {
            event.consume();
            assert (this.viewNode == event.getSource());
            Bounds nodeBounds = this.viewNode.getBoundsInParent();
            double r = this.viewNode.getRadius();
            Point2D positionInsideWorkingNode = new Point2D(event.getX() - nodeBounds.getMinX() - r, event.getY() - nodeBounds.getMinY() - r);
            this.viewNode.getScene().setCursor(this.getCursorForMousePosition(positionInsideWorkingNode));
        });
        this.viewNode.setOnMouseExited(event -> {
            event.consume();
            this.viewNode.getScene().setCursor(Cursor.DEFAULT);
        });
        this.viewNode.setOnMousePressed(event -> {
            event.consume();
            assert (this.viewNode == event.getSource());
            Bounds nodeBounds = this.viewNode.getBoundsInParent();
            double r = this.viewNode.getRadius();
            Point2D positionInsideWorkingNode = new Point2D(event.getX() - nodeBounds.getMinX() - r, event.getY() - nodeBounds.getMinY() - r);
            this.mouseGestureStartPoint = new Point2D(event.getSceneX(), event.getSceneY());
            this.startShape = this.getViewNodeShape();
            this.resizeStrategy = this.getResizeStrategyForMousePosition(positionInsideWorkingNode);
        });
        this.viewNode.setOnMouseDragged(event -> {
            event.consume();
            double minViewNodeRadius = 10.0;
            double dx = event.getSceneX() - this.mouseGestureStartPoint.getX();
            double dy = event.getSceneY() - this.mouseGestureStartPoint.getY();
            double newX = this.startShape.getX() + dx * (double)this.resizeStrategy.x;
            double newY = this.startShape.getY() + dy * (double)this.resizeStrategy.y;
            double newR = Math.max(10.0, this.startShape.getZ() + dx * (double)this.resizeStrategy.r);
            this.viewNode.setCenterX(newX);
            this.viewNode.setCenterY(newY);
            this.viewNode.setRadius(newR);
        });
        this.viewNode.setOnMouseReleased(event -> {
            event.consume();
            this.updateModel(this.startShape, this.getViewNodeShape());
            this.resizeStrategy = ResizeStrategy.NONE;
        });
    }

    private void updateModel(Point3D shapeBefore, Point3D shapeAfter) {
        double dx = (shapeAfter.getX() - shapeBefore.getX()) / this.scale;
        double dy = (shapeAfter.getY() - shapeBefore.getY()) / this.scale;
        double dr = (shapeAfter.getZ() - shapeBefore.getZ()) / this.scale;
        this.model = this.model.add(dx, dy, dr);
        if (this.modelChangeListener != null) {
            this.modelChangeListener.accept(this.getModel());
        }
    }

    private ResizeStrategy getResizeStrategyForMousePosition(Point2D pos) {
        double THR = 10.0;
        if (pos.magnitude() <= this.viewNode.getRadius() - 10.0) {
            return ResizeStrategy.DRAG;
        }
        return ResizeStrategy.RESIZE;
    }

    private Cursor getCursorForMousePosition(Point2D pos) {
        double THR = 10.0;
        if (pos.magnitude() <= this.viewNode.getRadius() - 10.0) {
            return Cursor.MOVE;
        }
        int sector = this.calculateSector(pos);
        switch (sector) {
            case 1: {
                return Cursor.SW_RESIZE;
            }
            case 2: {
                return Cursor.S_RESIZE;
            }
            case 3: {
                return Cursor.SE_RESIZE;
            }
            case 4: {
                return Cursor.E_RESIZE;
            }
            case 5: {
                return Cursor.NE_RESIZE;
            }
            case 6: {
                return Cursor.N_RESIZE;
            }
            case 7: {
                return Cursor.NW_RESIZE;
            }
        }
        return Cursor.W_RESIZE;
    }

    private int calculateSector(Point2D pos) {
        int numberOfSectors = 8;
        Point2D oX = new Point2D(1.0, 0.0);
        Point2D oY = new Point2D(0.0, -1.0);
        double angleMagnitude = pos.angle(oX);
        double angleDirection = Math.signum(pos.dotProduct(oY));
        double angle = angleMagnitude * angleDirection;
        int azimuth = (int)angle + 180;
        int sectorLength = 45;
        int sectorsShift = 22;
        int sector = (azimuth + 22) / 45;
        return sector;
    }

    private static enum ResizeStrategy {
        RESIZE(0, 0, 1),
        DRAG(1, 1, 0),
        NONE(0, 0, 0);

        final int x;
        final int y;
        final int r;

        private ResizeStrategy(int x, int y, int r) {
            this.x = x;
            this.y = y;
            this.r = r;
        }
    }
}

