/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.tools;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTool;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Circle;

public class PointSelectionTool
extends SelectionTool {
    private static final double defaultRadius = 10.0;
    private final Circle viewNode = new Circle(10.0);
    private Point2D model = Point2D.ZERO;
    private double scale = 1.0;

    PointSelectionTool(Pane handlePane) {
        super(handlePane);
        this.viewNode.setMouseTransparent(true);
        this.viewNode.setVisible(false);
        this.viewNode.setManaged(false);
        handlePane.getChildren().add((Object)this.viewNode);
        this.initializeActiveProperty();
    }

    @Override
    public Node getView() {
        return this.viewNode;
    }

    @Override
    public List<SimplePrimitive> getModel() {
        return List.of(new SimplePrimitive("x", this.model.getX()), new SimplePrimitive("y", this.model.getY()));
    }

    @Override
    public String getName() {
        return "Point";
    }

    @Override
    public void onHandlePaneClicked(MouseEvent event) {
        if (!this.active.get()) {
            return;
        }
        if (!event.isStillSincePress()) {
            return;
        }
        Point2D newPosition = new Point2D(event.getX(), event.getY());
        Point2D posBefore = new Point2D(this.viewNode.getCenterX(), this.viewNode.getCenterY());
        this.setViewPosition(newPosition);
        this.updateModel(posBefore, newPosition);
    }

    @Override
    public Point2D getModelPosition() {
        return this.model;
    }

    @Override
    public void setViewPosition(Point2D position) {
        this.viewNode.setCenterX(position.getX());
        this.viewNode.setCenterY(position.getY());
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
    }

    private void initializeActiveProperty() {
        this.active.addListener((ob, o, n) -> {
            this.viewNode.setVisible(n.booleanValue());
            this.viewNode.setManaged(n.booleanValue());
        });
    }

    private void updateModel(Point2D positionBefore, Point2D positionAfter) {
        double dx = (positionAfter.getX() - positionBefore.getX()) / this.scale;
        double dy = (positionAfter.getY() - positionBefore.getY()) / this.scale;
        this.model = this.model.add(dx, dy);
        if (this.modelChangeListener != null) {
            this.modelChangeListener.accept(this.getModel());
        }
    }
}

