/*
 * Decompiled with CFR 0.152.
 */
package com.siams.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class CollectionsUtils {
    public static <T> List<T> remove(Collection<T> collection, Predicate<T> predicate) {
        return CollectionsUtils.remove(collection, predicate, null);
    }

    public static <V extends T, T> List<V> remove(Collection<T> collection, Predicate<V> predicate, Class<V> clazz) {
        ArrayList<T> removed = new ArrayList<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T obj = iterator.next();
            if (clazz != null && !clazz.isAssignableFrom(obj.getClass()) || predicate != null && !predicate.test(obj)) continue;
            removed.add(obj);
            iterator.remove();
        }
        return removed;
    }

    public static <V extends T, T> Optional<V> removeFirst(Collection<T> collection, Predicate<V> predicate, Class<V> clazz) {
        Object removed = null;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T obj = iterator.next();
            if (clazz != null && !clazz.isAssignableFrom(obj.getClass()) || predicate != null && !predicate.test(obj)) continue;
            removed = obj;
            iterator.remove();
            break;
        }
        return Optional.ofNullable(removed);
    }

    public static <T> Optional<T> removeFirst(Collection<T> collection, Predicate<T> predicate) {
        return CollectionsUtils.removeFirst(collection, predicate, null);
    }

    public static <V extends T, T> List<V> find(Collection<T> collection, Predicate<V> predicate, Class<V> clazz) {
        LinkedList<T> vals = new LinkedList<T>();
        for (T obj : collection) {
            if (clazz != null && !clazz.isAssignableFrom(obj.getClass()) || predicate != null && !predicate.test(obj)) continue;
            vals.add(obj);
        }
        return vals;
    }

    public static <V extends T, T> List<V> find(Collection<T> collection, Class<V> clazz) {
        return CollectionsUtils.find(collection, null, clazz);
    }

    public static <V extends T, T> Optional<V> findFirst(Collection<T> collection, Predicate<V> predicate, Class<V> clazz) {
        Object found = null;
        for (T obj : collection) {
            if (clazz != null && !clazz.isAssignableFrom(obj.getClass()) || predicate != null && !predicate.test(obj)) continue;
            found = obj;
            break;
        }
        return Optional.ofNullable(found);
    }

    public static <V extends T, T> Optional<V> findFirst(Collection<T> collection, Predicate<V> predicate) {
        return CollectionsUtils.findFirst(collection, predicate, null);
    }
}

