/*
 * Decompiled with CFR 0.152.
 */
package com.siams.collection;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class FixedSizeDeque<T> {
    protected ArrayDeque<T> qeque;
    protected final int maxCount;

    public FixedSizeDeque(int maxCount) {
        this.maxCount = maxCount;
        this.qeque = new ArrayDeque(maxCount);
    }

    public void add(T e) {
        this.qeque.remove(e);
        if (this.maxCount - this.qeque.size() <= 0) {
            this.qeque.removeLast();
        }
        this.qeque.addFirst(e);
    }

    public void addAll(List<T> list) {
        this.qeque.clear();
        for (T e : list) {
            this.add(e);
        }
    }

    public void addAll(T[] arr) {
        this.qeque.clear();
        for (T e : arr) {
            this.add(e);
        }
    }

    public void remove(T e) {
        this.qeque.remove(e);
    }

    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.qeque);
    }

    public Optional<T> getAt(int index) {
        Iterator<T> it = this.qeque.iterator();
        int i = -1;
        Object e = null;
        while (it.hasNext()) {
            if (++i == index) {
                e = it.next();
                break;
            }
            it.next();
        }
        return Optional.ofNullable(e);
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int size() {
        return this.qeque.size();
    }
}

