/*
 * Decompiled with CFR 0.152.
 */
package com.siams.javafx.utils;

import com.siams.notifications.StareNotification;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class FxTools {
    private static final Logger logger = Logger.getLogger(FxTools.class);

    public static void browseFileDirectory(Path path) {
        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
            Desktop.getDesktop().browseFileDirectory(path.toFile());
            return;
        }
        if (FxTools.browseFileDirectoryForWindows(path)) {
            return;
        }
        Path parent = path.getParent();
        String message = "Cannot open parent folder of path: " + (String)(parent == null ? "it is a root" : String.valueOf(parent) + " is not an existing folder");
        if (parent == null || !Files.isDirectory(parent, new LinkOption[0])) {
            logger.warn((Object)message);
            StareNotification.showWarn(message);
            return;
        }
        try {
            Desktop.getDesktop().open(parent.toFile());
        }
        catch (IOException e) {
            logger.error((Object)message, (Throwable)e);
            StareNotification.showWarn(message);
        }
    }

    private static boolean browseFileDirectoryForWindows(Path path) {
        if (FxTools.isWindows()) {
            try {
                Runtime.getRuntime().exec("explorer.exe /select," + String.valueOf(path.toAbsolutePath()));
                return true;
            }
            catch (Exception ex) {
                logger.warn((Object)("Cannot call Windows explorer.exe for " + String.valueOf(path)), (Throwable)ex);
            }
        }
        return false;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.toLowerCase().contains("windows");
    }
}

