/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.utils;

import com.siams.stare.utils.Rect;
import com.siams.stare.utils.SMatIterator;
import com.siams.stare.utils.SMatUnaryProcess;
import net.algart.executors.api.data.SMat;

public class SMatNonZeroIterator
extends SMatIterator {
    private boolean processZeroValue = false;

    public void setProcessZeroValue(boolean processZeroValue) {
        this.processZeroValue = processZeroValue;
    }

    public SMatNonZeroIterator(SMat sMat, Rect viewRect, SMatUnaryProcess unaryProcess) {
        super(sMat, viewRect, unaryProcess);
    }

    @Override
    void iterate() {
        if (this.isAbsolutePosition) {
            this.iterateOverAbsolutePosition();
        } else {
            this.iterateOverRelativePosition();
        }
    }

    @Override
    void iterateOverRelativePosition() {
        int x1 = (int)this.viewRect.getX();
        int y1 = (int)this.viewRect.getY();
        int x2 = (int)this.viewRect.getX2();
        int y2 = (int)this.viewRect.getY2();
        int channels = this.sMat.getNumberOfChannels();
        byte[] data = null;
        switch (this.sMat.getDepth()) {
            case U8: 
            case S8: {
                data = new byte[channels];
                break;
            }
            case U16: 
            case S16: {
                data = new byte[2 * channels];
                break;
            }
            case S32: 
            case F32: {
                data = new byte[4 * channels];
                break;
            }
            case F64: {
                data = new byte[8 * channels];
            }
        }
        if (data == null) {
            return;
        }
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int sMatX = x - this.sMatOffsetX;
                int sMatY = y - this.sMatOffsetY;
                this.byteIndex = this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (sMatY * this.imageWidth + sMatX) * channels;
                this.bb.position(this.byteIndex);
                this.bb.get(data);
                int hasVal = 0;
                for (byte b : data) {
                    hasVal |= b;
                }
                if (this.processZeroValue) {
                    if (hasVal != 0) continue;
                    this.unaryProcess.process(x, y, 0.0);
                    continue;
                }
                if (hasVal == 0) continue;
                this.unaryProcess.process(x, y, 0.0);
            }
        }
    }

    @Override
    void iterateOverAbsolutePosition() {
        int x1 = (int)this.viewRect.getX();
        int y1 = (int)this.viewRect.getY();
        int x2 = (int)this.viewRect.getX2();
        int y2 = (int)this.viewRect.getY2();
        int channels = this.sMat.getNumberOfChannels();
        switch (this.sMat.getDepth()) {
            case U8: 
            case S8: {
                this.iterateOverByteBuffer(x1, x2, y1, y2, channels);
                break;
            }
            case U16: 
            case S16: {
                this.iterateOverShortBuffer(x1, x2, y1, y2, channels);
                break;
            }
            case S32: {
                this.iterateOverIntBuffer(x1, x2, y1, y2, channels);
                break;
            }
            case F32: {
                this.iterateOverFloatBuffer(x1, x2, y1, y2, channels);
                break;
            }
            case F64: {
                this.iterateOverDoubleBuffer(x1, x2, y1, y2, channels);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported matrix depth");
            }
        }
    }

    private void iterateOverByteBuffer(int x1, int x2, int y1, int y2, int channels) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int idx = this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (y * this.imageWidth + x) * channels;
                int val = 0;
                for (int c = 0; c < channels; ++c) {
                    byte b = this.bb.get(idx + c);
                    val |= b << c * 8;
                }
                if (val == 0) {
                    if (!this.processZeroValue) continue;
                    this.unaryProcess.process(x, y, val);
                    continue;
                }
                this.unaryProcess.process(x, y, val);
            }
        }
    }

    private void iterateOverShortBuffer(int x1, int x2, int y1, int y2, int channels) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int idx = 2 * (this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (y * this.imageWidth + x) * channels);
                short val = 0;
                for (int c = 0; c < channels; ++c) {
                    short s = this.bb.getShort(idx + 2 * c);
                    if (s == 0) continue;
                    val = s;
                }
                if (val == 0) {
                    if (!this.processZeroValue) continue;
                    this.unaryProcess.process(x, y, val);
                    continue;
                }
                this.unaryProcess.process(x, y, val);
            }
        }
    }

    private void iterateOverIntBuffer(int x1, int x2, int y1, int y2, int channels) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int idx = 4 * (this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (y * this.imageWidth + x) * channels);
                int val = 0;
                for (int c = 0; c < channels; ++c) {
                    int i = this.bb.getInt(idx + 4 * c);
                    if (i == 0) continue;
                    val = i;
                }
                if (val == 0) {
                    if (!this.processZeroValue) continue;
                    this.unaryProcess.process(x, y, val);
                    continue;
                }
                this.unaryProcess.process(x, y, val);
            }
        }
    }

    private void iterateOverFloatBuffer(int x1, int x2, int y1, int y2, int channels) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int idx = 4 * (this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (y * this.imageWidth + x) * channels);
                float val = 0.0f;
                for (int c = 0; c < channels; ++c) {
                    float f = this.bb.getFloat(idx + 4 * c);
                    if (f == 0.0f) continue;
                    val = f;
                }
                if (val == 0.0f) {
                    if (!this.processZeroValue) continue;
                    this.unaryProcess.process(x, y, val);
                    continue;
                }
                this.unaryProcess.process(x, y, val);
            }
        }
    }

    private void iterateOverDoubleBuffer(int x1, int x2, int y1, int y2, int channels) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int idx = 8 * (this.sMatOffsetZ * this.imageWidth * this.imageHeight * channels + (y * this.imageWidth + x) * channels);
                double val = 0.0;
                for (int c = 0; c < channels; ++c) {
                    double d = this.bb.getDouble(idx + 8 * c);
                    if (d == 0.0) continue;
                    val = d;
                }
                if (val == 0.0) {
                    if (!this.processZeroValue) continue;
                    this.unaryProcess.process(x, y, val);
                    continue;
                }
                this.unaryProcess.process(x, y, val);
            }
        }
    }
}

