/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.utils;

import com.siams.stare.utils.Rect;
import com.siams.stare.utils.SMatIterator;
import com.siams.stare.utils.SMatUnaryProcess;
import net.algart.executors.api.data.SMat;

public class SMatPackNonZeroIterator
extends SMatIterator {
    protected int startOffset;
    protected int endOffset;
    private int imageX;
    private int imageY;
    private boolean processZeroValue = false;

    public void setProcessZeroValue(boolean processZeroValue) {
        this.processZeroValue = processZeroValue;
    }

    public SMatPackNonZeroIterator(SMat sMat, Rect viewRect, SMatUnaryProcess unaryProcess) {
        super(sMat, viewRect, unaryProcess);
        this.startByteIndex = this.toByteIndex((int)viewRect.getX(), (int)viewRect.getY(), this.imageWidth);
        this.startOffset = this.toByteOffset((int)viewRect.getX(), (int)viewRect.getY(), this.imageWidth);
        this.endByteIndex = this.toByteIndex((int)viewRect.getX2(), (int)viewRect.getY2(), this.imageWidth);
        this.endOffset = this.toByteOffset((int)viewRect.getX2(), (int)viewRect.getY2(), this.imageWidth);
        this.byteIndex = this.startByteIndex;
    }

    private int toByteIndex(int x, int y, int width) {
        return (y * width + x) / 8;
    }

    private int toByteOffset(int x, int y, int width) {
        return (y * width + x) % 8;
    }

    @Override
    void iterate() {
        if (this.isAbsolutePosition) {
            this.iterateOverAbsolutePosition();
        } else {
            this.iterateOverRelativePosition();
        }
    }

    @Override
    void iterateOverAbsolutePosition() {
        boolean isZeroVal;
        byte bit;
        byte bVal;
        if (this.byteIndex == this.startByteIndex) {
            bVal = this.bb.get(this.byteIndex);
            int maxOffset = Math.min(8, this.imageWidth);
            for (int offset = this.startOffset; offset < maxOffset; ++offset) {
                bit = (byte)(bVal >> offset & 1);
                boolean bl = isZeroVal = bit == 0;
                if (this.processZeroValue != isZeroVal) continue;
                this.imageY = (this.byteIndex * 8 + offset) / this.imageWidth;
                this.imageX = (this.byteIndex * 8 + offset) % this.imageWidth;
                this.unaryProcess.process(this.imageX, this.imageY, bit);
            }
            ++this.byteIndex;
        }
        while (this.byteIndex < this.endByteIndex) {
            bVal = this.bb.get(this.byteIndex);
            boolean bl = isZeroVal = bVal == 0;
            if (this.processZeroValue == isZeroVal) {
                bit = (byte)(bVal & 1);
                boolean bl2 = isZeroVal = bit == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = this.byteIndex * 8 / this.imageWidth;
                    this.imageX = this.byteIndex * 8 % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl3 = isZeroVal = (bit = (byte)(bVal >> 1 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 1) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 1) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl4 = isZeroVal = (bit = (byte)(bVal >> 2 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 2) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 2) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl5 = isZeroVal = (bit = (byte)(bVal >> 3 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 3) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 3) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl6 = isZeroVal = (bit = (byte)(bVal >> 4 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 4) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 4) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl7 = isZeroVal = (bit = (byte)(bVal >> 5 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 5) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 5) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl8 = isZeroVal = (bit = (byte)(bVal >> 6 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 6) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 6) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
                boolean bl9 = isZeroVal = (bit = (byte)(bVal >> 7 & 1)) == 0;
                if (this.processZeroValue == isZeroVal) {
                    this.imageY = (this.byteIndex * 8 + 7) / this.imageWidth;
                    this.imageX = (this.byteIndex * 8 + 7) % this.imageWidth;
                    this.unaryProcess.process(this.imageX, this.imageY, bit);
                }
            }
            ++this.byteIndex;
        }
        if (this.startByteIndex != this.endByteIndex && this.byteIndex == this.endByteIndex) {
            bVal = this.bb.get(this.byteIndex);
            for (int offset = 0; offset <= this.endOffset; ++offset) {
                bit = (byte)(bVal >> offset & 1);
                boolean bl = isZeroVal = bit == 0;
                if (this.processZeroValue != isZeroVal) continue;
                this.imageY = (this.byteIndex * 8 + offset) / this.imageWidth;
                this.imageX = (this.byteIndex * 8 + offset) % this.imageWidth;
                this.unaryProcess.process(this.imageX, this.imageY, bit);
            }
            ++this.byteIndex;
        }
    }

    @Override
    void iterateOverRelativePosition() {
        throw new IllegalArgumentException("Not implemented yet");
    }
}

