/*
 * Decompiled with CFR 0.152.
 */
package com.siams.window;

import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.preferences.UIPreference;
import com.siams.window.OnCloseStareStage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public abstract class StareStage<C extends Parent, D>
extends Stage
implements UIPreference {
    public static final String BUTTON_ID_OK = "btnOk";
    public static final String BUTTON_ID_CANCEL = "btnCancel";
    public static final String BUTTON_ID_WINDOW_CLOSE = "btnWindowClose";
    protected C contentRoot;
    protected D data;
    protected Scene scene;
    protected StareStageContainer root;
    protected final String keyIsMaximized = this.createPreferenceName(this.getClass(), "stage.isMaximized");
    protected final String keyWidth = this.createPreferenceName(this.getClass(), "stage.width");
    protected final String keyHeight = this.createPreferenceName(this.getClass(), "stage.height");
    protected final String keyX = this.createPreferenceName(this.getClass(), "stage.x");
    protected final String keyY = this.createPreferenceName(this.getClass(), "stage.y");
    protected List<Button> buttons = new ArrayList<Button>();
    private OnCloseStareStage closeHandler;

    protected StareStage() {
        this.initializeContainer();
    }

    private void initializeContainer() {
        try {
            this.root = new StareStageContainer(this);
            CustomFXMLLoader.loadElement((Object)this.root, StareStageContainer.class.getResource("/com/siams/window/StareStageContainer.fxml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.root.btnOK.setUserData((Object)BUTTON_ID_OK);
        this.root.btnCancel.setUserData((Object)BUTTON_ID_CANCEL);
        this.buttons.add(this.root.btnOK);
        this.buttons.add(this.root.btnCancel);
        this.setMinHeight(450.0);
        this.setMinWidth(450.0);
    }

    protected abstract void initialize();

    protected abstract C createRootNode();

    protected void initializeDefaultRoot() {
        try {
            this.contentRoot = this.createRootNode();
            CustomFXMLLoader.loadElement(this.contentRoot, this.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.root.apContent.getChildren().add(this.contentRoot);
        PaneHelper.setAnchorZero(this.contentRoot);
    }

    protected void initializeDefaultScene() {
        this.scene = new Scene((Parent)this.root);
    }

    protected void initializeDefaultCloseRequest() {
        this.addEventFilter(WindowEvent.WINDOW_HIDING, event -> this.savePreference());
        this.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, event -> {
            if (this.closeHandler != null) {
                this.closeHandler.handle(BUTTON_ID_WINDOW_CLOSE);
            } else {
                this.close();
            }
        });
    }

    public List<String> initializeButtons(String ... captions) {
        this.buttons.clear();
        ArrayList<String> ids = new ArrayList<String>(captions.length);
        for (int i = 0; i < captions.length; ++i) {
            Button btn = new Button(captions[i]);
            String id = String.format("btn-%d", i);
            btn.setUserData((Object)id);
            ids.add(id);
            this.buttons.add(btn);
        }
        this.root.hBoxButtons.getChildren().clear();
        this.root.hBoxButtons.getChildren().addAll(this.buttons);
        return ids;
    }

    public void setOnCloseAction(OnCloseStareStage closeHandler) {
        Objects.requireNonNull(closeHandler, "Close handler required");
        this.closeHandler = closeHandler;
        this.buttons.forEach(button -> button.setOnAction(e -> this.closeHandler.handle((String)button.getUserData())));
    }

    @Override
    public void savePreference() {
        this.putPreferredBoolean(this.keyIsMaximized, this.isMaximized());
        this.putPreferredDouble(this.keyWidth, this.getWidth());
        this.putPreferredDouble(this.keyHeight, this.getHeight());
        this.putPreferredDouble(this.keyX, this.getX());
        this.putPreferredDouble(this.keyY, this.getY());
    }

    @Override
    public void restorePreference() {
        boolean isMaximized = this.getPreferredBoolean(this.keyIsMaximized, false);
        if (isMaximized) {
            this.setMaximized(true);
        } else {
            this.setWidth(this.getPreferredDouble(this.keyWidth, 600.0));
            this.setHeight(this.getPreferredDouble(this.keyHeight, 800.0));
            this.setX(this.getPreferredDouble(this.keyX, 0.0));
            this.setY(this.getPreferredDouble(this.keyY, 0.0));
        }
    }

    private class StareStageContainer
    extends VBox {
        @FXML
        private AnchorPane apContent;
        @FXML
        private HBox hBoxButtons;
        @FXML
        private Button btnOK;
        @FXML
        private Button btnCancel;

        private StareStageContainer(StareStage stareStage) {
        }
    }
}

