/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io.helpers;

import java.nio.file.Path;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.matrices.io.MatReader;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.io.UnsupportedImageFormatException;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public class DefaultMatReaderHelper
implements MatReader {
    public void readMat(SMat result, Path path) throws UnsupportedImageFormatException {
        String file = path.toAbsolutePath().toString();
        Executor.LOG.log(System.Logger.Level.DEBUG, () -> "Java image I/O failed; reading " + file + " by OpenCV");
        Mat mat = opencv_imgcodecs.imread((String)file);
        if (mat == null || mat.data() == null) {
            throw new UnsupportedImageFormatException("OpenCV does not recognize " + file);
        }
        O2SMat.setTo(result, mat);
    }
}

