/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import java.util.Locale;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.multimatrix.MultiMatrix;

public final class StrictMorphology
extends MorphologyFilter {
    public static final String INPUT_MASK = "mask";
    private MorphologyOperation operation = MorphologyOperation.DILATION;
    private boolean optimizeSpeedForLargePatterns = true;
    private boolean invertSource = false;
    private Pattern pattern;

    public StrictMorphology() {
        this.addInputMat(INPUT_MASK);
    }

    public final MorphologyOperation getOperation() {
        return this.operation;
    }

    public StrictMorphology setOperation(MorphologyOperation operation) {
        this.operation = (MorphologyOperation)((Object)StrictMorphology.nonNull((Object)((Object)operation)));
        return this;
    }

    public boolean isOptimizeSpeedForLargePatterns() {
        return this.optimizeSpeedForLargePatterns;
    }

    public StrictMorphology setOptimizeSpeedForLargePatterns(boolean optimizeSpeedForLargePatterns) {
        this.optimizeSpeedForLargePatterns = optimizeSpeedForLargePatterns;
        return this;
    }

    public boolean isInvertSource() {
        return this.invertSource;
    }

    public StrictMorphology setInvertSource(boolean invertSource) {
        this.invertSource = invertSource;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        MultiMatrix mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix();
        long t1 = StrictMorphology.debugTime();
        MultiMatrix result = super.process(source);
        long t2 = StrictMorphology.debugTime();
        if (mask != null) {
            result = result.min(mask);
        }
        long t3 = StrictMorphology.debugTime();
        StrictMorphology.logDebug(() -> String.format(Locale.US, "Strict %s with %s%s for %s: %.3f ms morphology operation + %.3f ms masking ", new Object[]{this.operation, this.pattern, this.continuationMode == null ? "" : ", " + String.valueOf(this.continuationMode), this.sourceMultiMatrix(), (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6}));
        return result;
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (this.invertSource) {
            m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)m.maxPossibleValue(), (double[])new double[]{-1.0}), (Class)m.type(PArray.class), m).clone();
        }
        this.pattern = this.getPattern(m, this.optimizeSpeedForLargePatterns);
        return this.operation.perform(this.createMorphology(m), (Matrix<? extends PArray>)m, this.pattern, (Executor)this);
    }
}

