/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import java.util.Objects;
import net.algart.executors.modules.opencv.common.SeveralUMatOperation;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class VoidResultTwoUMatFilter
extends SeveralUMatOperation {
    private final String firstInputPort;
    private final String secondInputPort;

    protected VoidResultTwoUMatFilter() {
        this("input_1", "input_2");
    }

    protected VoidResultTwoUMatFilter(String firstInputPort, String secondInputPort) {
        this.firstInputPort = firstInputPort;
        this.secondInputPort = Objects.requireNonNull(secondInputPort, "Null second port name");
        this.addInputMat(firstInputPort == null ? DEFAULT_INPUT_PORT : firstInputPort);
        this.addInputMat(secondInputPort);
    }

    @Override
    public Mat process(Mat[] sources) {
        Mat source = sources[0];
        Mat secondMat = sources[1] != null ? sources[1] : source;
        Mat result = new Mat();
        this.process(result, source, secondMat);
        return result;
    }

    @Override
    public UMat process(UMat[] sources) {
        UMat source = sources[0];
        UMat secondMat = sources[1] != null ? sources[1] : source;
        UMat result = new UMat();
        this.process(result, source, secondMat);
        return result;
    }

    public abstract void process(Mat var1, Mat var2, Mat var3);

    public abstract void process(UMat var1, UMat var2, UMat var3);

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return false;
    }

    @Override
    protected String inputPortName(int inputIndex) {
        switch (inputIndex) {
            case 0: {
                return this.firstInputPort == null ? this.defaultInputPortName() : this.firstInputPort;
            }
            case 1: {
                return this.secondInputPort;
            }
        }
        throw new AssertionError((Object)"requiredNumberOfInputs() method returns invalid number of ports");
    }
}

