/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.arithmetic;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import net.algart.executors.modules.opencv.util.enums.ODepthOrUnchanged;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Multiply
extends VoidResultTwoUMatFilter
implements ReadOnlyExecutionInput {
    private ODepthOrUnchanged resultDepth = ODepthOrUnchanged.UNCHANGED;
    private double scale = 1.0;

    public Multiply() {
        super("x", "y");
    }

    public ODepthOrUnchanged getResultDepth() {
        return this.resultDepth;
    }

    public Multiply setResultDepth(ODepthOrUnchanged resultDepth) {
        this.resultDepth = (ODepthOrUnchanged)((Object)Multiply.nonNull((Object)((Object)resultDepth)));
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public Multiply setScale(double scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        opencv_core.multiply((Mat)source, (Mat)secondMat, (Mat)result, (double)this.scale, (int)this.resultDepth.code());
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        opencv_core.multiply((UMat)source, (UMat)secondMat, (UMat)result, (double)this.scale, (int)this.resultDepth.code());
    }
}

