/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import net.algart.executors.modules.opencv.util.enums.OMorphShape;
import net.algart.executors.modules.opencv.util.enums.OMorphType;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Morphology
extends UMatFilter {
    private OMorphType operation = OMorphType.DILATE;
    private OMorphShape patternShape = OMorphShape.CIRCLE;
    private int patternSize = 15;
    private int numberOfIterations = 1;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public OMorphType getOperation() {
        return this.operation;
    }

    public Morphology setOperation(OMorphType operation) {
        this.operation = (OMorphType)((Object)Morphology.nonNull((Object)((Object)operation)));
        return this;
    }

    public OMorphShape getPatternShape() {
        return this.patternShape;
    }

    public Morphology setPatternShape(OMorphShape patternShape) {
        this.patternShape = (OMorphShape)((Object)Morphology.nonNull((Object)((Object)patternShape)));
        return this;
    }

    public int getPatternSize() {
        return this.patternSize;
    }

    public Morphology setPatternSize(int patternSize) {
        this.patternSize = Morphology.nonNegative((int)patternSize);
        return this;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public Morphology setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = Morphology.positive((int)numberOfIterations);
        return this;
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public Morphology setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)Morphology.nonNull((Object)((Object)borderType)));
        return this;
    }

    @Override
    public Mat process(Mat source) {
        Morphology.logDebug(() -> "Morphology " + String.valueOf((Object)this.operation) + " with shape " + String.valueOf((Object)this.patternShape) + " " + this.patternSize + "x" + this.patternSize + " (source: " + String.valueOf(source) + ")");
        if (this.patternSize > 0) {
            try (Size size = new Size(this.patternSize, this.patternSize);
                 Mat element = opencv_imgproc.getStructuringElement((int)this.patternShape.code(), (Size)size);){
                opencv_imgproc.morphologyEx((Mat)source, (Mat)source, (int)this.operation.code(), (Mat)element, null, (int)this.numberOfIterations, (int)this.borderType.code(), null);
            }
        }
        return source;
    }

    @Override
    public UMat process(UMat source) {
        Morphology.logDebug(() -> "Morphology " + String.valueOf((Object)this.operation) + " (GPU) with shape " + String.valueOf((Object)this.patternShape) + " " + this.patternSize + "x" + this.patternSize + " (source: " + String.valueOf(source) + ")");
        if (this.patternSize > 0) {
            try (Size size = new Size(this.patternSize, this.patternSize);
                 Mat element = opencv_imgproc.getStructuringElement((int)this.patternShape.code(), (Size)size);
                 UMat elementUMat = OTools.toUMat(element);){
                opencv_imgproc.morphologyEx((UMat)source, (UMat)source, (int)this.operation.code(), (UMat)elementUMat, null, (int)this.numberOfIterations, (int)this.borderType.code(), null);
            }
        }
        return source;
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }
}

