/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSuperpixel;
import net.algart.executors.modules.opencv.matrices.segmentation.BoundariesExtractor;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class GraphSegmentation
extends AbstractSuperpixel {
    private double sigma = 0.5;
    private double k = 1.5;
    private int minSize = 100;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = GraphSegmentation.nonNegative((int)minSize);
    }

    @Override
    public Mat process(Mat source) {
        Mat result = new Mat();
        try (org.bytedeco.opencv.opencv_ximgproc.GraphSegmentation graphSegmentation = opencv_ximgproc.createGraphSegmentation((double)this.sigma, (float)((float)(this.k * OTools.maxPossibleValue(source))), (int)this.minSize);){
            GraphSegmentation.logDebug(() -> "GraphSegmentation: sigma " + this.sigma + ", K " + this.k + ", minSize " + this.minSize + " (source: " + String.valueOf(source) + ")");
            graphSegmentation.processImage(source, result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries(BoundariesExtractor.DEFAULT, source, result);
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        UMat result = new UMat();
        try (org.bytedeco.opencv.opencv_ximgproc.GraphSegmentation graphSegmentation = opencv_ximgproc.createGraphSegmentation((double)this.sigma, (float)((float)(this.k * OTools.maxPossibleValue(source))), (int)this.minSize);){
            GraphSegmentation.logDebug(() -> "GraphSegmentation: sigma " + this.sigma + ", K " + this.k + ", minSize " + this.minSize + " (source: " + String.valueOf(source) + ")");
            graphSegmentation.processImage(source, result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries(BoundariesExtractor.DEFAULT, source, result);
        }
        return result;
    }
}

