/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.algart.matrices.tiff.TiffIO;
import net.algart.matrices.tiff.TiffReader;
import org.scijava.io.handle.BytesHandle;
import org.scijava.io.handle.DataHandle;

@FunctionalInterface
public interface TempTiffFileCreator {
    public DataHandle<?> createTempFile(TiffReader var1) throws IOException;

    public static class Default
    implements TempTiffFileCreator {
        private long maxTiffFileSizeForMemory = 0x40000000L;

        public long getMaxTiffFileSizeForMemory() {
            return this.maxTiffFileSizeForMemory;
        }

        public Default setMaxTiffFileSizeForMemory(long maxTiffFileSizeForMemory) {
            if (maxTiffFileSizeForMemory < 0L) {
                throw new IllegalArgumentException("Negative maxTiffFileSizeForMemory = " + maxTiffFileSizeForMemory);
            }
            this.maxTiffFileSizeForMemory = maxTiffFileSizeForMemory;
            return this;
        }

        @Override
        public DataHandle<?> createTempFile(TiffReader existingTiffReader) throws IOException {
            if (existingTiffReader.fileLength() < this.maxTiffFileSizeForMemory) {
                return new BytesHandle();
            }
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            return TiffIO.getFileHandle(tempFile);
        }
    }
}

