/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.io.awt.ImageToMatrix;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.TooLargeTiffImageException;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;
import net.algart.matrices.tiff.tags.TagPredictor;
import net.algart.matrices.tiff.tags.TagRational;
import net.algart.matrices.tiff.tags.TagTypes;
import net.algart.matrices.tiff.tags.Tags;

public class TiffIFD {
    public static final int MAX_NUMBER_OF_IFD_ENTRIES = 10000000;
    public static final int TIFF_FILE_HEADER_LENGTH = 8;
    public static final int BIG_TIFF_FILE_HEADER_LENGTH = 16;
    public static final int BYTES_PER_ENTRY = 12;
    public static final int BIG_TIFF_BYTES_PER_ENTRY = 20;
    public static final int MAX_NUMBER_OF_CHANNELS = 128;
    public static final int MAX_BITS_PER_SAMPLE = 256;
    public static final long MAX_NUMBER_OF_BITS_IN_BYTE_ARRAY = 0x3FFFFFFFFL;
    private static final boolean USE_LONG_IMAGE_DIMENSIONS = true;
    private static final long MAX_LONG_DIV_MAX_BITS_PER_PIXEL = 0xFFFFFFFFFFFFL;
    public static final int LAST_IFD_OFFSET = 0;
    public static final int DEFAULT_TILE_SIZE_X = 512;
    public static final int DEFAULT_TILE_SIZE_Y = 512;
    public static final int DEFAULT_STRIP_SIZE = 128;
    public static final int COMPRESSION_NONE = 1;
    public static final int COMPRESSION_CCITT_MODIFIED_HUFFMAN_RLE = 2;
    public static final int COMPRESSION_CCITT_T4 = 3;
    public static final int COMPRESSION_CCITT_T6 = 4;
    public static final int COMPRESSION_LZW = 5;
    public static final int COMPRESSION_OLD_JPEG = 6;
    public static final int COMPRESSION_JPEG = 7;
    public static final int COMPRESSION_DEFLATE = 8;
    public static final int COMPRESSION_DEFLATE_PROPRIETARY = 32946;
    public static final int COMPRESSION_PACK_BITS = 32773;
    public static final int PLANAR_CONFIGURATION_CHUNKED = 1;
    public static final int PLANAR_CONFIGURATION_SEPARATE = 2;
    public static final int FILL_ORDER_NORMAL = 1;
    public static final int FILL_ORDER_REVERSED = 2;
    public static final int SAMPLE_FORMAT_UINT = 1;
    public static final int SAMPLE_FORMAT_INT = 2;
    public static final int SAMPLE_FORMAT_IEEEFP = 3;
    public static final int SAMPLE_FORMAT_VOID = 4;
    public static final int SAMPLE_FORMAT_COMPLEX_INT = 5;
    public static final int SAMPLE_FORMAT_COMPLEX_IEEEFP = 6;
    public static final int FILETYPE_REDUCED_IMAGE = 1;
    private final Map<Integer, Object> map;
    private TagCompression detailedCompression = null;
    private final LinkedHashMap<Integer, TiffEntry> detailedEntries;
    private boolean loadedFromFile = false;
    private boolean littleEndian = false;
    private boolean bigTiff = false;
    private long fileOffsetForReading = -1L;
    private long fileOffsetForWriting = -1L;
    private long nextIFDOffset = -1L;
    private Integer subIFDType = null;
    private volatile boolean frozen = false;
    private volatile long[] cachedTileOrStripByteCounts = null;
    private volatile long[] cachedTileOrStripOffsets = null;

    public TiffIFD() {
        this(new LinkedHashMap<Integer, Object>());
    }

    public TiffIFD(TiffIFD ifd) {
        this.loadedFromFile = ifd.loadedFromFile;
        this.fileOffsetForReading = ifd.fileOffsetForReading;
        this.fileOffsetForWriting = ifd.fileOffsetForWriting;
        this.nextIFDOffset = ifd.nextIFDOffset;
        this.map = new LinkedHashMap<Integer, Object>(ifd.map);
        this.detailedCompression = ifd.detailedCompression;
        this.detailedEntries = ifd.detailedEntries == null ? null : new LinkedHashMap<Integer, TiffEntry>(ifd.detailedEntries);
        this.subIFDType = ifd.subIFDType;
        this.frozen = false;
    }

    public TiffIFD(Map<Integer, Object> ifdEntries) {
        this(ifdEntries, null);
    }

    TiffIFD(Map<Integer, Object> ifdEntries, LinkedHashMap<Integer, TiffEntry> detailedEntries) {
        Objects.requireNonNull(ifdEntries);
        this.map = new LinkedHashMap<Integer, Object>(ifdEntries);
        this.detailedEntries = detailedEntries;
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public TiffIFD setLoadedFromFile(boolean loadedFromFile) {
        this.loadedFromFile = loadedFromFile;
        return this;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public TiffIFD setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
        return this;
    }

    public ByteOrder getByteOrder() {
        return this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public TiffIFD setByteOrder(ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        return this.setLittleEndian(byteOrder == ByteOrder.LITTLE_ENDIAN);
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public TiffIFD setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
        return this;
    }

    public boolean hasFileOffsetForReading() {
        return this.fileOffsetForReading >= 0L;
    }

    public long getFileOffsetForReading() {
        if (this.fileOffsetForReading < 0L) {
            throw new IllegalStateException("IFD offset of the TIFF tile is not set while reading");
        }
        return this.fileOffsetForReading;
    }

    public TiffIFD setFileOffsetForReading(long fileOffsetForReading) {
        if (fileOffsetForReading < 0L) {
            throw new IllegalArgumentException("Negative IFD offset in the file: " + fileOffsetForReading);
        }
        this.fileOffsetForReading = fileOffsetForReading;
        return this;
    }

    public TiffIFD removeFileOffsetForReading() {
        this.fileOffsetForReading = -1L;
        return this;
    }

    public boolean hasFileOffsetForWriting() {
        return this.fileOffsetForWriting >= 0L;
    }

    public long getFileOffsetForWriting() {
        if (this.fileOffsetForWriting < 0L) {
            throw new IllegalStateException("IFD offset of the TIFF tile for writing is not set");
        }
        return this.fileOffsetForWriting;
    }

    public TiffIFD setFileOffsetForWriting(long fileOffsetForWriting) {
        if (fileOffsetForWriting < 0L) {
            throw new IllegalArgumentException("Negative IFD file offset: " + fileOffsetForWriting);
        }
        if ((fileOffsetForWriting & 1L) != 0L) {
            throw new IllegalArgumentException("Odd IFD file offset " + fileOffsetForWriting + " is prohibited for writing valid TIFF");
        }
        this.fileOffsetForWriting = fileOffsetForWriting;
        return this;
    }

    public TiffIFD removeFileOffsetForWriting() {
        this.fileOffsetForWriting = -1L;
        return this;
    }

    public boolean hasNextIFDOffset() {
        return this.nextIFDOffset >= 0L;
    }

    public boolean isLastIFD() {
        return this.nextIFDOffset == 0L;
    }

    public long getNextIFDOffset() {
        if (this.nextIFDOffset < 0L) {
            throw new IllegalStateException("Next IFD offset is not set");
        }
        return this.nextIFDOffset;
    }

    public TiffIFD setNextIFDOffset(long nextIFDOffset) {
        if (nextIFDOffset < 0L) {
            throw new IllegalArgumentException("Negative next IFD offset: " + nextIFDOffset);
        }
        this.nextIFDOffset = nextIFDOffset;
        return this;
    }

    public TiffIFD setLastIFD() {
        return this.setNextIFDOffset(0L);
    }

    public TiffIFD removeNextIFDOffset() {
        this.nextIFDOffset = -1L;
        return this;
    }

    public boolean isMainIFD() {
        return this.subIFDType == null;
    }

    public Integer getSubIFDType() {
        return this.subIFDType;
    }

    public TiffIFD setSubIFDType(Integer subIFDType) {
        this.subIFDType = subIFDType;
        return this;
    }

    public static int sizeOfFileHeader(boolean bigTiff) {
        return bigTiff ? 16 : 8;
    }

    public OptionalLong sizeOfAll(long tiffFileLength) throws IOException {
        OptionalLong sizeOfIFD = this.sizeOfIFD(tiffFileLength);
        return sizeOfIFD.isEmpty() ? OptionalLong.empty() : OptionalLong.of(Math.addExact(sizeOfIFD.getAsLong(), this.sizeOfImageData(tiffFileLength)));
    }

    public long sizeOfIFDTable() throws TiffException {
        return TiffIFD.sizeOfIFDTable(this.numberOfEntries(), this.bigTiff, this.isMainIFD());
    }

    public OptionalLong sizeOfIFD(long tiffFileLength) {
        if (tiffFileLength < 0L) {
            throw new IllegalArgumentException("Negative TIFF file length");
        }
        if (this.detailedEntries == null) {
            return OptionalLong.empty();
        }
        long result = TiffIFD.sizeOfIFDTableExcludingEntries(this.bigTiff, this.isMainIFD());
        ArrayList<TiffEntry> entries = new ArrayList<TiffEntry>(this.detailedEntries.values());
        entries.sort(Comparator.comparingLong(TiffEntry::valueOffset));
        long lastOffsetAfter = -9223372036854775807L;
        long lastOffset = 0L;
        for (TiffEntry entry : entries) {
            if (((lastOffset | entry.valueOffset) & 1L) == 0L && lastOffsetAfter + 1L == entry.valueOffset) {
                ++result;
            }
            long size = entry.sizeOf();
            result += size;
            lastOffset = entry.valueOffset;
            lastOffsetAfter = entry.offsetAfter();
        }
        return OptionalLong.of(result);
    }

    public long sizeOfImageData(long tiffFileLength) throws TiffException {
        return this.sizeOfImageData(tiffFileLength, null);
    }

    public long sizeOfImageData(long tiffFileLength, AtomicBoolean wasAligned) throws TiffException {
        long[] byteCounts;
        if (tiffFileLength < 0L) {
            throw new IllegalArgumentException("Negative TIFF file length");
        }
        long[] offsets = (long[])this.cachedTileOrStripOffsets().clone();
        int n = Math.min(offsets.length, (byteCounts = (long[])this.cachedTileOrStripByteCounts().clone()).length);
        if (n == 0) {
            return 0L;
        }
        ArraySorter.getQuickSorter().sort(0, n, (first, second) -> offsets[first] < offsets[second], (first, second) -> {
            long temp = offsets[first];
            offsets[first] = offsets[second];
            offsets[second] = temp;
            temp = byteCounts[first];
            byteCounts[first] = byteCounts[second];
            byteCounts[second] = temp;
        });
        long sum = 0L;
        if (!this.isBigTiff() && offsets[0] == 16L) {
            sum = 8L;
        }
        for (int i = 0; i < n; ++i) {
            if (i == 0 || offsets[i] != offsets[i - 1]) {
                sum = Math.addExact(sum, byteCounts[i]);
            }
            if (offsets[i] + byteCounts[i] <= tiffFileLength) continue;
            throw new TiffException("IFD tile/strip is outside the file length " + tiffFileLength + ": offset " + offsets[i] + ", length " + byteCounts[i]);
        }
        long lastEnd = offsets[n - 1] + byteCounts[n - 1];
        if ((lastEnd & 1L) != 0L && !this.offsetCannotBeCorrectFreeSpace(lastEnd, tiffFileLength)) {
            if (wasAligned != null) {
                wasAligned.set(true);
            }
            sum = Math.addExact(sum, 1L);
        }
        return sum;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public TiffIFD freeze() {
        this.frozen = true;
        return this;
    }

    public Map<Integer, Object> map() {
        return Collections.unmodifiableMap(this.map);
    }

    public int numberOfEntries() {
        return this.map.size();
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public Object get(int key) {
        return this.map.get(key);
    }

    public <R> Optional<R> optValue(int tag, Class<? extends R> requiredClass) {
        Objects.requireNonNull(requiredClass, "Null requiredClass");
        Object value = this.get(tag);
        if (!requiredClass.isInstance(value)) {
            return Optional.empty();
        }
        return Optional.of(requiredClass.cast(value));
    }

    public <R> Optional<R> getValue(int tag, Class<? extends R> requiredClass) throws TiffException {
        Objects.requireNonNull(requiredClass, "Null requiredClass");
        Object value = this.get(tag);
        if (value == null) {
            return Optional.empty();
        }
        if (!requiredClass.isInstance(value)) {
            throw new TiffException("TIFF tag " + Tags.tiffTagName(tag, true) + " has wrong type: " + value.getClass().getSimpleName() + " instead of expected " + requiredClass.getSimpleName());
        }
        return Optional.of(requiredClass.cast(value));
    }

    public <R> R reqValue(int tag, Class<? extends R> requiredClass) throws TiffException {
        return this.getValue(tag, requiredClass).orElseThrow(() -> new TiffException("TIFF tag " + Tags.tiffTagName(tag, true) + " is required, but it is absent"));
    }

    public OptionalInt optType(int tag) {
        TiffEntry entry = this.detailedEntries == null ? null : this.detailedEntries.get(tag);
        return entry == null ? OptionalInt.empty() : OptionalInt.of(entry.type());
    }

    public boolean optBoolean(int tag, boolean defaultValue) {
        return this.optValue(tag, Boolean.class).orElse(defaultValue);
    }

    public int reqInt(int tag) throws TiffException {
        return TiffIFD.checkedIntValue(this.reqValue(tag, Number.class), tag);
    }

    public int getInt(int tag, int defaultValue) throws TiffException {
        return TiffIFD.checkedIntValue(this.getValue(tag, Number.class).orElse(defaultValue), tag);
    }

    public int optInt(int tag, int defaultValue) {
        return TiffIFD.truncatedIntValue(this.optValue(tag, Number.class).orElse(defaultValue));
    }

    public long reqLong(int tag) throws TiffException {
        return this.reqValue(tag, Number.class).longValue();
    }

    public long getLong(int tag, int defaultValue) throws TiffException {
        return this.getValue(tag, Number.class).orElse(defaultValue).longValue();
    }

    public long optLong(int tag, long defaultValue) {
        return this.optValue(tag, Number.class).orElse(defaultValue).longValue();
    }

    public long[] getLongArray(int tag) throws TiffException {
        Object value = this.get(tag);
        long[] results = null;
        if (value instanceof long[]) {
            long[] v = (long[])value;
            results = (long[])v.clone();
        } else if (value instanceof Number) {
            Number v = (Number)value;
            results = new long[]{v.longValue()};
        } else if (value instanceof Number[]) {
            Number[] v = (Number[])value;
            results = new long[v.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = v[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            results = new long[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = v[i];
            }
        } else if (value != null) {
            throw new TiffException("TIFF tag " + Tags.tiffTagName(tag, true) + " has wrong type: " + value.getClass().getSimpleName() + " instead of expected Number, Number[], long[] or int[]");
        }
        return results;
    }

    public int[] getIntArray(int tag) throws TiffException {
        Object value = this.get(tag);
        int[] results = null;
        if (value instanceof int[]) {
            int[] v = (int[])value;
            results = (int[])v.clone();
        } else if (value instanceof Number) {
            Number v = (Number)value;
            results = new int[]{TiffIFD.checkedIntValue(v, tag)};
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            results = new int[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = TiffIFD.checkedIntValue(v[i], tag);
            }
        } else if (value instanceof Number[]) {
            Number[] v = (Number[])value;
            results = new int[v.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = TiffIFD.checkedIntValue(v[i].longValue(), tag);
            }
        } else if (value != null) {
            throw new TiffException("TIFF tag " + Tags.tiffTagName(tag, true) + " has wrong type: " + value.getClass().getSimpleName() + " instead of expected Number, Number[], long[] or int[]");
        }
        return results;
    }

    public int getSamplesPerPixel() throws TiffException {
        int compressionValue = this.optInt(259, 0);
        if (compressionValue == 6) {
            return 3;
        }
        int samplesPerPixel = this.getInt(277, 1);
        if (samplesPerPixel < 1) {
            throw new TiffException("TIFF tag SamplesPerPixel contains illegal zero or negative value: " + samplesPerPixel);
        }
        if (samplesPerPixel > 128) {
            throw new TiffException("TIFF tag SamplesPerPixel contains too large value: " + samplesPerPixel + " (maximal support number of channels is 128)");
        }
        return samplesPerPixel;
    }

    public int[] getBitsPerSample() throws TiffException {
        int[] bitsPerSample = this.getIntArray(258);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        if (bitsPerSample.length == 0) {
            throw new TiffException("Zero length of BitsPerSample array");
        }
        for (int i = 0; i < bitsPerSample.length; ++i) {
            int bits = bitsPerSample[i];
            if (bits <= 0) {
                throw new TiffException("Zero or negative BitsPerSample[" + i + "] = " + bits);
            }
            if (bits <= 256) continue;
            throw new TiffException("Too large BitsPerSample[" + i + "] = " + bits + " > 256");
        }
        int samplesPerPixel = this.getSamplesPerPixel();
        if (bitsPerSample.length < samplesPerPixel) {
            int[] newBitsPerSample = new int[samplesPerPixel];
            for (int i = 0; i < newBitsPerSample.length; ++i) {
                newBitsPerSample[i] = bitsPerSample[i < bitsPerSample.length ? i : 0];
            }
            bitsPerSample = newBitsPerSample;
        }
        return bitsPerSample;
    }

    public int[] getBytesPerSample() throws TiffException {
        int[] bitsPerSample = this.getBitsPerSample();
        int[] result = new int[bitsPerSample.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bitsPerSample[i] + 7 >>> 3;
            assert (result[i] >= 0);
        }
        return result;
    }

    public TiffSampleType sampleType() throws TiffException {
        TiffSampleType result = this.sampleType(true);
        assert (result != null);
        return result;
    }

    public TiffSampleType sampleType(boolean requireNonNullResult) throws TiffException {
        int alignedBitDepth;
        if (requireNonNullResult) {
            alignedBitDepth = this.alignedBitDepth();
        } else {
            try {
                alignedBitDepth = this.alignedBitDepth();
            }
            catch (TiffException e) {
                return null;
            }
        }
        if (alignedBitDepth == 1) {
            return TiffSampleType.BIT;
        }
        int[] sampleFormats = this.getIntArray(339);
        if (sampleFormats == null) {
            sampleFormats = new int[]{1};
        }
        if (sampleFormats.length == 0) {
            throw new TiffException("Zero length of SampleFormat array");
        }
        for (int v : sampleFormats) {
            if (v == sampleFormats[0]) continue;
            if (requireNonNullResult) {
                throw new UnsupportedTiffFormatException("Unsupported TIFF IFD: different sample format for different samples (" + Arrays.toString(sampleFormats) + ")");
            }
            return null;
        }
        int bytesPerSample = alignedBitDepth + 7 >>> 3;
        TiffSampleType result = null;
        switch (sampleFormats[0]) {
            case 1: {
                switch (bytesPerSample) {
                    case 1: {
                        result = TiffSampleType.UINT8;
                        break;
                    }
                    case 2: {
                        result = TiffSampleType.UINT16;
                        break;
                    }
                    case 3: 
                    case 4: {
                        result = TiffSampleType.UINT32;
                    }
                }
                if (result != null || !requireNonNullResult) break;
                throw new UnsupportedTiffFormatException("Unsupported TIFF bit depth: " + Arrays.toString(this.getBitsPerSample()) + " bits/sample, or " + bytesPerSample + " bytes/sample for unsigned integers, but only 1..4 bytes/sample are supported for integers");
            }
            case 2: {
                switch (bytesPerSample) {
                    case 1: {
                        result = TiffSampleType.INT8;
                        break;
                    }
                    case 2: {
                        result = TiffSampleType.INT16;
                        break;
                    }
                    case 3: 
                    case 4: {
                        result = TiffSampleType.INT32;
                    }
                }
                if (result != null || !requireNonNullResult) break;
                throw new UnsupportedTiffFormatException("Unsupported TIFF bit depth: " + Arrays.toString(this.getBitsPerSample()) + " bits/sample, or " + bytesPerSample + " bytes/sample for signed integers, but only 1..4 bytes/sample are supported for integers");
            }
            case 3: {
                switch (bytesPerSample) {
                    case 2: 
                    case 3: 
                    case 4: {
                        result = TiffSampleType.FLOAT;
                        break;
                    }
                    case 8: {
                        result = TiffSampleType.DOUBLE;
                    }
                }
                if (result != null || !requireNonNullResult) break;
                throw new UnsupportedTiffFormatException("Unsupported TIFF bit depth: " + Arrays.toString(this.getBitsPerSample()) + " bits/sample, or " + bytesPerSample + " bytes/sample for floating point values, but only 2, 3, 4 bytes/sample cases are supported");
            }
            case 4: {
                if (bytesPerSample == 1) {
                    result = TiffSampleType.UINT8;
                    break;
                }
                if (!requireNonNullResult) break;
                throw new UnsupportedTiffFormatException("Unsupported TIFF bit depth: " + Arrays.toString(this.getBitsPerSample()) + " bits/sample, or " + bytesPerSample + " bytes/sample for void values (only 1 byte/sample is supported for unknown data type)");
            }
            default: {
                if (!requireNonNullResult) break;
                throw new UnsupportedTiffFormatException("Unsupported TIFF data type: SampleFormat=" + Arrays.toString(sampleFormats));
            }
        }
        assert (result == null || result.bitsPerSample() >= alignedBitDepth);
        return result;
    }

    public long[] getTileOrStripByteCounts() throws TiffException {
        boolean tiled = this.hasTileInformation();
        int tag = tiled ? 325 : 279;
        long[] counts = this.getLongArray(tag);
        if (tiled && counts == null) {
            counts = this.getLongArray(279);
        }
        if (counts == null) {
            throw new TiffException("Invalid IFD: no required StripByteCounts/TileByteCounts tag");
        }
        long numberOfTiles = (long)this.getTileCountX() * (long)this.getTileCountY();
        if ((long)counts.length < numberOfTiles) {
            throw new TiffException("StripByteCounts/TileByteCounts length (" + counts.length + ") does not match expected number of strips/tiles (" + numberOfTiles + ")");
        }
        return counts;
    }

    public long[] cachedTileOrStripByteCounts() throws TiffException {
        long[] result = this.cachedTileOrStripByteCounts;
        if (result == null) {
            this.cachedTileOrStripByteCounts = result = this.getTileOrStripByteCounts();
        }
        return result;
    }

    public int cachedTileOrStripByteCountLength() throws TiffException {
        return this.cachedTileOrStripByteCounts().length;
    }

    public int cachedTileOrStripByteCount(int index) throws TiffException {
        long[] byteCounts = this.cachedTileOrStripByteCounts();
        if (index < 0) {
            throw new IllegalArgumentException("Negative index = " + index);
        }
        if (index >= byteCounts.length) {
            throw new TiffException((this.hasTileInformation() ? "Tile index is too big for TileByteCounts" : "Strip index is too big for StripByteCounts") + "array: it contains only " + byteCounts.length + " elements");
        }
        long result = byteCounts[index];
        if (result < 0L) {
            throw new TiffException("Negative value " + result + " in " + (this.hasTileInformation() ? "TileByteCounts" : "StripByteCounts") + " array");
        }
        if (result > Integer.MAX_VALUE) {
            throw new TiffException("Too large tile/strip #" + index + ": " + result + " bytes > 2^31-1");
        }
        return (int)result;
    }

    public long[] getTileOrStripOffsets() throws TiffException {
        boolean tiled = this.hasTileInformation();
        int tag = tiled ? 324 : 273;
        long[] offsets = this.getLongArray(tag);
        if (tiled && offsets == null) {
            offsets = this.getLongArray(273);
        }
        if (offsets == null) {
            throw new TiffException("Invalid IFD: no required StripOffsets/TileOffsets tag");
        }
        long numberOfTiles = (long)this.getTileCountX() * (long)this.getTileCountY();
        if ((long)offsets.length < numberOfTiles) {
            throw new TiffException("StripByteCounts/TileByteCounts length (" + offsets.length + ") does not match expected number of strips/tiles (" + numberOfTiles + ")");
        }
        return offsets;
    }

    public long[] cachedTileOrStripOffsets() throws TiffException {
        long[] result = this.cachedTileOrStripOffsets;
        if (result == null) {
            this.cachedTileOrStripOffsets = result = this.getTileOrStripOffsets();
        }
        return result;
    }

    public long cachedTileOrStripOffset(int index) throws TiffException {
        long[] offsets = this.cachedTileOrStripOffsets();
        if (index < 0) {
            throw new IllegalArgumentException("Negative index = " + index);
        }
        if (index >= offsets.length) {
            throw new TiffException((this.hasTileInformation() ? "Tile index is too big for TileOffsets" : "Strip index is too big for StripOffsets") + "array: it contains only " + offsets.length + " elements");
        }
        long result = offsets[index];
        if (result < 0L) {
            throw new TiffException("Negative value " + result + " in " + (this.hasTileInformation() ? "TileOffsets" : "StripOffsets") + " array");
        }
        return result;
    }

    public Optional<String> optDescription() {
        return this.optValue(270, String.class);
    }

    public int getCompressionCode() throws TiffException {
        return this.getInt(259, 1);
    }

    public TagCompression optCompression() {
        int code = this.optInt(259, -1);
        if (code == -1) {
            return null;
        }
        if (this.detailedCompression != null && this.detailedCompression.code() == code) {
            return this.detailedCompression;
        }
        return TagCompression.ofOrNull(code);
    }

    public int optPredictorCode() {
        return this.optInt(317, TagPredictor.NONE.code());
    }

    public TagPredictor getPredictor() {
        return TagPredictor.ofOrUnknown(this.optPredictorCode());
    }

    public String compressionPrettyName() {
        int code = this.optInt(259, -1);
        if (code == -1) {
            return "unspecified compression";
        }
        TagCompression compression = this.optCompression();
        return compression == null ? "unsupported compression " + code : compression.prettyName();
    }

    public int getPhotometricInterpretationCode() throws TiffException {
        return this.getInt(262, -1);
    }

    public TagPhotometricInterpretation getPhotometricInterpretation() throws TiffException {
        if (!this.containsKey(262) && this.getInt(259, 0) == 6) {
            return TagPhotometricInterpretation.RGB;
        }
        int code = this.getPhotometricInterpretationCode();
        return TagPhotometricInterpretation.ofOrUnknown(code);
    }

    public int[] getYCbCrSubsampling() throws TiffException {
        int[] result;
        Object value = this.get(530);
        if (value == null) {
            return new int[]{2, 2};
        }
        if (value instanceof int[]) {
            int[] ints;
            result = ints = (int[])value;
        } else if (value instanceof short[]) {
            short[] shorts = (short[])value;
            result = new int[shorts.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = shorts[k];
            }
        } else {
            throw new TiffException("TIFF tag YCbCrSubSampling has the wrong type " + value.getClass().getSimpleName() + ": must be int[] or short[]");
        }
        if (result.length < 2) {
            throw new TiffException("TIFF tag YCbCrSubSampling contains only " + result.length + " elements: " + Arrays.toString(result) + "; it must contain at least 2 numbers");
        }
        for (int v : result) {
            if (v == 1 || v == 2 || v == 4) continue;
            throw new TiffException("TIFF tag YCbCrSubSampling must contain only values 1, 2 or 4, but it is " + Arrays.toString(result));
        }
        return Arrays.copyOf(result, 2);
    }

    public int[] getYCbCrSubsamplingLogarithms() throws TiffException {
        int[] result = this.getYCbCrSubsampling();
        for (int k = 0; k < result.length; ++k) {
            int v = result[k];
            result[k] = 31 - Integer.numberOfLeadingZeros(v);
            assert (1 << result[k] == v);
        }
        return result;
    }

    public int getPlanarConfiguration() throws TiffException {
        int result = this.getInt(284, 1);
        if (result != 1 && result != 2) {
            throw new TiffException("TIFF tag PlanarConfiguration must contain only values 1 or 2, but it is " + result);
        }
        return result;
    }

    public boolean isPlanarSeparated() throws TiffException {
        return this.getPlanarConfiguration() == 2;
    }

    public boolean isChunked() throws TiffException {
        return this.getPlanarConfiguration() == 1;
    }

    public boolean isReversedFillOrder() throws TiffException {
        int result = this.getInt(266, 1);
        if (result != 1 && result != 2) {
            throw new TiffException("TIFF tag FillOrder must contain only values 1 or 2, but it is " + result);
        }
        return result == 2;
    }

    public boolean hasImageDimensions() {
        return this.containsKey(256) && this.containsKey(257);
    }

    public int getImageDimX() throws TiffException {
        int imageWidth = this.reqInt(256);
        if (imageWidth == 0) {
            throw new TiffException("Zero image width");
        }
        if (imageWidth < 0) {
            throw new TiffException("Very large TIFF image width " + ((long)imageWidth & 0xFFFFFFFFL) + " >= 2^31 is not supported");
        }
        return imageWidth;
    }

    public int getImageDimY() throws TiffException {
        int imageLength = this.reqInt(257);
        if (imageLength == 0) {
            throw new TiffException("Zero image height");
        }
        if (imageLength < 0) {
            throw new TiffException("Very large TIFF image height " + ((long)imageLength & 0xFFFFFFFFL) + " >= 2^31 is not supported");
        }
        return imageLength;
    }

    public int getRowsPerStrip() throws TiffException {
        long[] rowsPerStrip = this.getLongArray(278);
        int imageDimY = this.getImageDimY();
        if (rowsPerStrip == null || rowsPerStrip.length == 0) {
            return imageDimY == 0 ? 1 : imageDimY;
        }
        for (int i = 0; i < rowsPerStrip.length; ++i) {
            int rows = (int)Math.min(rowsPerStrip[i], (long)imageDimY);
            if (rows <= 0) {
                throw new TiffException("Zero or negative RowsPerStrip[" + i + "] = " + rows);
            }
            rowsPerStrip[i] = rows;
        }
        int result = (int)rowsPerStrip[0];
        assert (result > 0) : result + " was not checked in the loop above?";
        for (int i = 1; i < rowsPerStrip.length; ++i) {
            if ((long)result == rowsPerStrip[i]) continue;
            throw new TiffException("Non-uniform RowsPerStrip is not supported");
        }
        return result;
    }

    public int getTileSizeX() throws TiffException {
        if (this.hasTileInformation()) {
            int tileWidth = this.reqInt(322);
            if (tileWidth <= 0) {
                throw new TiffException("Zero or negative tile width = " + tileWidth);
            }
            return tileWidth;
        }
        int imageDimX = this.getImageDimX();
        return imageDimX == 0 ? 1 : imageDimX;
    }

    public int getTileSizeY() throws TiffException {
        if (this.hasTileInformation()) {
            int tileLength = this.reqInt(323);
            if (tileLength <= 0) {
                throw new TiffException("Zero or negative tile length (height) = " + tileLength);
            }
            return tileLength;
        }
        int stripRows = this.getRowsPerStrip();
        assert (stripRows > 0) : "getStripRows() did not check non-positive result";
        return stripRows;
    }

    public int getTileCountX() throws TiffException {
        int tileSizeX = this.getTileSizeX();
        if (tileSizeX <= 0) {
            throw new TiffException("Zero or negative tile width = " + tileSizeX);
        }
        long imageWidth = this.getImageDimX();
        long n = (imageWidth + (long)tileSizeX - 1L) / (long)tileSizeX;
        assert (n <= Integer.MAX_VALUE) : "ceil(" + imageWidth + "/" + tileSizeX + ") > Integer.MAX_VALUE";
        return (int)n;
    }

    public int getTileCountY() throws TiffException {
        int tileSizeY = this.getTileSizeY();
        if (tileSizeY <= 0) {
            throw new TiffException("Zero or negative tile height = " + tileSizeY);
        }
        long imageLength = this.getImageDimY();
        long n = (imageLength + (long)tileSizeY - 1L) / (long)tileSizeY;
        assert (n <= Integer.MAX_VALUE) : "ceil(" + imageLength + "/" + tileSizeY + ") > Integer.MAX_VALUE";
        return (int)n;
    }

    public OptionalInt tryEqualBitDepth() throws TiffException {
        int[] bitsPerSample = this.getBitsPerSample();
        return TiffIFD.tryEqualBitDepth(bitsPerSample);
    }

    public static OptionalInt tryEqualBitDepth(int[] bitsPerSample) {
        int bits0 = bitsPerSample[0];
        for (int i = 1; i < bitsPerSample.length; ++i) {
            if (bitsPerSample[i] == bits0) continue;
            return OptionalInt.empty();
        }
        return OptionalInt.of(bits0);
    }

    public OptionalInt tryEqualBitDepthAlignedByBytes() throws TiffException {
        OptionalInt result = this.tryEqualBitDepth();
        return result.isPresent() && (result.getAsInt() & 7) == 0 ? result : OptionalInt.empty();
    }

    public int alignedBitDepth() throws TiffException {
        int[] bitsPerSample = this.getBitsPerSample();
        return TiffIFD.alignedBitDepth(bitsPerSample);
    }

    public static int alignedBitDepth(int[] bitsPerSample) throws TiffException {
        if (bitsPerSample.length == 1 && bitsPerSample[0] == 1) {
            return 1;
        }
        int bytes0 = bitsPerSample[0] + 7 >>> 3;
        assert (bytes0 > 0);
        for (int k = 1; k < bitsPerSample.length; ++k) {
            if (bitsPerSample[k] + 7 >>> 3 == bytes0) continue;
            throw new UnsupportedTiffFormatException("Unsupported TIFF IFD: different number of bytes per samples, based on the following number of bits: " + Arrays.toString(bitsPerSample));
        }
        return bytes0 << 3;
    }

    public int checkSupportedBitDepth() throws TiffException {
        int[] bitsPerSample = this.getBitsPerSample();
        if (!TiffIFD.isSupportedPrecisionWithCheckingEquality(bitsPerSample)) {
            throw new UnsupportedTiffFormatException("The number of bits per sample " + bitsPerSample[0] + " bits per sample for " + bitsPerSample.length + " samples is not supported: " + Arrays.toString(bitsPerSample) + " bits/samples");
        }
        return bitsPerSample[0];
    }

    public boolean isStandardYCbCrNonJpeg() throws TiffException {
        TagCompression compression = this.optCompression();
        return compression != null && compression.isStandard() && !compression.isJpegOrOldJpeg() && this.getPhotometricInterpretation() == TagPhotometricInterpretation.Y_CB_CR;
    }

    public boolean isStandardCompression() {
        TagCompression compression = this.optCompression();
        return compression != null && compression.isStandard();
    }

    public boolean isJpegOrOldJpeg() {
        TagCompression compression = this.optCompression();
        return compression != null && compression.isJpegOrOldJpeg();
    }

    public boolean isStandardInvertedCompression() throws TiffException {
        TagCompression compression = this.optCompression();
        return compression != null && compression.isStandard() && !compression.isJpegOrOldJpeg() && this.getPhotometricInterpretation().isInvertedBrightness();
    }

    public boolean isThumbnail() {
        return (this.optInt(254, 0) & 1) != 0;
    }

    public TiffIFD putMatrixInformation(Matrix<? extends PArray> matrix) {
        return this.putMatrixInformation(matrix, false, false);
    }

    public TiffIFD putMatrixInformation(Matrix<? extends PArray> matrix, boolean signedIntegers) {
        return this.putMatrixInformation(matrix, signedIntegers, false);
    }

    public TiffIFD putMatrixInformation(Matrix<? extends PArray> matrix, boolean signedIntegers, boolean interleaved) {
        Objects.requireNonNull(matrix, "Null matrix");
        int dimChannelsIndex = interleaved ? 0 : 2;
        long numberOfChannels = matrix.dim(dimChannelsIndex);
        TiffIFD.checkNumberOfChannels(numberOfChannels);
        assert (numberOfChannels == (long)((int)numberOfChannels)) : "must be checked in checkNumberOfChannels";
        long dimX = matrix.dim(interleaved ? 1 : 0);
        long dimY = matrix.dim(interleaved ? 2 : 1);
        this.putImageDimensions(dimX, dimY);
        this.putPixelInformation((int)numberOfChannels, TiffSampleType.of(matrix.elementType(), signedIntegers));
        return this;
    }

    public TiffIFD putChannelsInformation(List<? extends Matrix<? extends PArray>> channels) {
        return this.putChannelsInformation(channels, false);
    }

    public TiffIFD putChannelsInformation(List<? extends Matrix<? extends PArray>> channels, boolean signedIntegers) {
        Objects.requireNonNull(channels, "Null channels");
        Matrices.checkDimensionEquality(channels, (boolean)true);
        int numberOfChannels = channels.size();
        if (numberOfChannels == 0) {
            throw new IllegalArgumentException("Empty channels list");
        }
        Matrix<? extends PArray> matrix = channels.get(0);
        TiffIFD.checkNumberOfChannels(numberOfChannels);
        long dimX = matrix.dimX();
        long dimY = matrix.dimY();
        Class elementType = matrix.elementType();
        this.putImageDimensions(dimX, dimY);
        this.putPixelInformation(numberOfChannels, TiffSampleType.of(elementType, signedIntegers));
        return this;
    }

    public TiffIFD putImageInformation(BufferedImage bufferedImage) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        int numberOfChannels = ImageToMatrix.defaultNumberOfChannels((BufferedImage)bufferedImage);
        Class elementType = ImageToMatrix.defaultElementType((BufferedImage)bufferedImage);
        int dimX = bufferedImage.getWidth();
        int dimY = bufferedImage.getHeight();
        this.putImageDimensions(dimX, dimY);
        this.putPixelInformation(numberOfChannels, TiffSampleType.of(elementType, false));
        return this;
    }

    public TiffIFD putImageDimensions(int dimX, int dimY) {
        return this.putImageDimensions((long)dimX, (long)dimY);
    }

    public TiffIFD putImageDimensions(long dimX, long dimY) {
        this.putImageDimensions(dimX, dimY, true);
        return this;
    }

    public TiffIFD putImageDimensions(long dimX, long dimY, boolean forceUpdate) {
        this.checkImmutable();
        this.updateImageDimensions(dimX, dimY, forceUpdate);
        return this;
    }

    public TiffIFD removeImageDimensions() {
        this.remove(256);
        this.remove(257);
        return this;
    }

    public TiffIFD putPixelInformation(int numberOfChannels, Class<?> elementType) {
        return this.putPixelInformation(numberOfChannels, TiffSampleType.of(elementType, false));
    }

    public TiffIFD putPixelInformation(int numberOfChannels, TiffSampleType sampleType) {
        Objects.requireNonNull(sampleType, "Null sampleType");
        this.putNumberOfChannels(numberOfChannels);
        this.putSampleType(sampleType);
        return this;
    }

    public TiffIFD putNumberOfChannels(int numberOfChannels) {
        TiffIFD.checkNumberOfChannels(numberOfChannels);
        this.put(277, numberOfChannels);
        return this;
    }

    public TiffIFD putBitsPerSample(int bitsPerSample) {
        return this.putBitsPerSample(bitsPerSample, false, false);
    }

    public TiffIFD putBitsPerSample(int bitsPerSample, boolean signed, boolean floatingPoint) {
        int samplesPerPixel;
        TiffIFD.checkBitsPerSample(bitsPerSample);
        try {
            samplesPerPixel = this.getSamplesPerPixel();
        }
        catch (TiffException e) {
            throw new IllegalStateException("Cannot set TIFF samples type: SamplesPerPixel tag is invalid", e);
        }
        this.put(258, TiffIFD.nInts(samplesPerPixel, bitsPerSample));
        if (floatingPoint) {
            this.put(339, TiffIFD.nInts(samplesPerPixel, 3));
        } else if (signed) {
            this.put(339, TiffIFD.nInts(samplesPerPixel, 2));
        } else {
            this.remove(339);
        }
        return this;
    }

    public TiffIFD putSampleType(TiffSampleType sampleType) {
        Objects.requireNonNull(sampleType, "Null sampleType");
        int bitsPerSample = sampleType.bitsPerSample();
        boolean signed = sampleType.isSigned();
        boolean floatingPoint = sampleType.isFloatingPoint();
        return this.putBitsPerSample(bitsPerSample, signed, floatingPoint);
    }

    public TiffIFD putCompression(TagCompression compression) {
        return this.putCompression(compression, false);
    }

    public TiffIFD putCompression(TagCompression compression, boolean putAlsoDefaultUncompressed) {
        if (compression == null && putAlsoDefaultUncompressed) {
            compression = TagCompression.NONE;
        }
        if (compression == null) {
            this.remove(259);
        } else {
            this.putCompressionCode(compression.code());
        }
        this.detailedCompression = compression;
        return this;
    }

    public TiffIFD putCompressionCode(int compression) {
        this.put(259, compression);
        assert (this.detailedCompression == null) : "must be cleared in put method";
        return this;
    }

    public TiffIFD putPhotometricInterpretation(TagPhotometricInterpretation photometricInterpretation) {
        Objects.requireNonNull(photometricInterpretation, "Null photometricInterpretation");
        if (!photometricInterpretation.isUnknown()) {
            this.put(262, photometricInterpretation.code());
        }
        return this;
    }

    public TiffIFD putPredictor(TagPredictor predictor) {
        Objects.requireNonNull(predictor, "Null predictor");
        if (predictor == TagPredictor.NONE) {
            this.removePredictor();
        } else if (!predictor.isUnknown()) {
            this.put(317, predictor.code());
        }
        return this;
    }

    public TiffIFD removePredictor() {
        this.remove(317);
        return this;
    }

    public TiffIFD putPlanarSeparated(boolean planarSeparated) {
        if (planarSeparated) {
            this.put(284, 2);
        } else {
            this.remove(284);
        }
        return this;
    }

    public boolean hasTileInformation() throws TiffException {
        boolean hasLength;
        boolean hasWidth = this.containsKey(322);
        if (hasWidth != (hasLength = this.containsKey(323))) {
            throw new TiffException("Inconsistent tiling information: tile width (TileWidth tag) is " + (hasWidth ? "" : "NOT ") + "specified, but tile height (TileLength tag) is " + (hasLength ? "" : "NOT ") + "specified");
        }
        return hasWidth;
    }

    public TiffIFD putTileSizes(int tileSizeX, int tileSizeY) {
        if (tileSizeX <= 0) {
            throw new IllegalArgumentException("Zero or negative tile x-size");
        }
        if (tileSizeY <= 0) {
            throw new IllegalArgumentException("Zero or negative tile y-size");
        }
        if ((tileSizeX & 0xF) != 0 || (tileSizeY & 0xF) != 0) {
            throw new IllegalArgumentException("Illegal tile sizes " + tileSizeX + "x" + tileSizeY + ": they must be multiples of 16");
        }
        this.put(322, tileSizeX);
        this.put(323, tileSizeY);
        return this;
    }

    public TiffIFD defaultTileSizes() {
        return this.putTileSizes(512, 512);
    }

    public TiffIFD removeTileInformation() {
        this.remove(322);
        this.remove(323);
        return this;
    }

    public boolean hasStripInformation() {
        return this.containsKey(278);
    }

    public TiffIFD putOrRemoveStripSize(Integer stripSizeY) {
        if (stripSizeY == null) {
            this.remove(278);
        } else {
            this.putStripSize(stripSizeY);
        }
        return this;
    }

    public TiffIFD putStripSize(int stripSizeY) {
        if (stripSizeY <= 0) {
            throw new IllegalArgumentException("Zero or negative strip y-size");
        }
        this.put(278, new long[]{stripSizeY});
        return this;
    }

    public TiffIFD defaultStripSize() {
        return this.putStripSize(128);
    }

    public TiffIFD removeStripInformation() {
        this.remove(278);
        return this;
    }

    public TiffIFD putDescription(String imageDescription) {
        Objects.requireNonNull(imageDescription, "Null image description");
        this.put(270, imageDescription);
        return this;
    }

    public TiffIFD removeImageDescription() {
        this.remove(270);
        return this;
    }

    public void removeDataPositioning() {
        this.remove(273);
        this.remove(279);
        this.remove(324);
        this.remove(325);
    }

    public TiffIFD updateImageDimensions(long dimX, long dimY, boolean forceUpdate) {
        if (dimX <= 0L) {
            throw new IllegalArgumentException("Zero or negative image width (x-dimension): " + dimX);
        }
        if (dimY <= 0L) {
            throw new IllegalArgumentException("Zero or negative image height (y-dimension): " + dimY);
        }
        if (dimX > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large image width = " + dimX + " (>2^31-1)");
        }
        if (dimY > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large image height = " + dimY + " (>2^31-1)");
        }
        if (!this.containsKey(322) || !this.containsKey(323)) {
            this.checkImmutable("Image dimensions cannot be updated in non-tiled TIFF");
        }
        this.clearCache();
        this.removeEntries(256, 257);
        assert (dimX == (long)((int)dimX));
        assert (dimY == (long)((int)dimY));
        if (!forceUpdate && (long)this.optInt(256, -1) == dimX && (long)this.optInt(257, -1) == dimY) {
            return this;
        }
        this.map.put(256, dimX);
        this.map.put(257, dimY);
        return this;
    }

    public void updateDataPositioning(long[] offsets, long[] byteCounts) {
        int numberOfSeparatedPlanes;
        long tileCountY;
        long tileCountX;
        boolean tiled;
        Objects.requireNonNull(offsets, "Null offsets");
        Objects.requireNonNull(byteCounts, "Null byte counts");
        try {
            tiled = this.hasTileInformation();
            tileCountX = this.getTileCountX();
            tileCountY = this.getTileCountY();
            numberOfSeparatedPlanes = this.isPlanarSeparated() ? this.getSamplesPerPixel() : 1;
        }
        catch (TiffException e) {
            throw new IllegalStateException("Illegal IFD: " + e.getMessage(), e);
        }
        long totalCount = tileCountX * tileCountY * (long)numberOfSeparatedPlanes;
        if (tileCountX * tileCountY > Integer.MAX_VALUE || totalCount > Integer.MAX_VALUE || (long)offsets.length != totalCount || (long)byteCounts.length != totalCount) {
            throw new IllegalArgumentException("Incorrect offsets array (" + offsets.length + " values) or byte-counts array (" + byteCounts.length + " values) not equal to " + totalCount + " - actual number of " + (tiled ? "tiles, " + tileCountX + " x " + tileCountY : "strips, " + tileCountY) + (String)(numberOfSeparatedPlanes == 1 ? "" : " x " + numberOfSeparatedPlanes + " separated channels"));
        }
        this.clearCache();
        this.removeEntries(324, 273, 325, 279);
        this.map.put(tiled ? 324 : 273, offsets);
        this.map.put(tiled ? 325 : 279, byteCounts);
        this.map.remove(tiled ? 273 : 324);
        this.map.remove(tiled ? 279 : 325);
    }

    public Object put(int key, Object value) {
        this.checkImmutable();
        this.removeEntries(key);
        if (key == 259) {
            this.detailedCompression = null;
        }
        this.clearCache();
        return this.map.put(key, value);
    }

    public Object remove(int key) {
        this.checkImmutable();
        this.removeEntries(key);
        this.clearCache();
        return this.map.remove(key);
    }

    public void clear() {
        this.checkImmutable();
        this.clearCache();
        if (this.detailedEntries != null) {
            this.detailedEntries.clear();
        }
        this.map.clear();
    }

    public String toString() {
        return this.toString(StringFormat.BRIEF);
    }

    public String toString(StringFormat format) {
        TiffSampleType sampleType;
        Objects.requireNonNull(format, "Null format");
        boolean json = format.isJson();
        StringBuilder sb = new StringBuilder();
        sb.append(json ? "{\n" : "IFD");
        String ifdTypeName = this.subIFDType == null ? "main" : Tags.tiffTagName(this.subIFDType, false);
        sb.append((json ? "  \"ifdType\" : \"%s\",\n" : " (%s)").formatted(ifdTypeName));
        int dimX = 0;
        int dimY = 0;
        int tileSizeX = 1;
        int tileSizeY = 1;
        try {
            sampleType = this.sampleType(false);
            sb.append((json ? "  \"elementType\" : \"%s\",\n" : " %s").formatted(sampleType == null ? "???" : (sampleType.isBinary() ? "bit" : sampleType.elementType().getSimpleName())));
            int channels = this.getSamplesPerPixel();
            if (this.hasImageDimensions()) {
                dimX = this.getImageDimX();
                dimY = this.getImageDimY();
                tileSizeX = this.getTileSizeX();
                tileSizeY = this.getTileSizeY();
                sb.append((json ? "  \"dimX\" : %d,\n  \"dimY\" : %d,\n  \"channels\" : %d,\n" : "[%dx%dx%d], ").formatted(dimX, dimY, channels));
            } else {
                sb.append((json ? "  \"channels\" : %d,\n" : "[?x?x%d], ").formatted(channels));
            }
        }
        catch (Exception e) {
            sb.append((String)(json ? "  \"exceptionBasic\" : \"%s\",\n".formatted(TiffIFD.escapeJsonString(e.getMessage())) : " [cannot detect basic information: " + e.getMessage() + "] "));
        }
        try {
            sampleType = this.sampleType(false);
            long tileCountX = ((long)dimX + (long)tileSizeX - 1L) / (long)tileSizeX;
            long tileCountY = ((long)dimY + (long)tileSizeY - 1L) / (long)tileSizeY;
            sb.append(json ? "  \"precision\" : \"%s\",\n  \"byteOrder\" : \"%s\",\n  \"bigTiff\" : %s,\n  \"tiled\" : %s,\n".formatted(sampleType.prettyName(), this.getByteOrder(), this.isBigTiff(), this.hasTileInformation()) : "%s, precision %s%s, %s, ".formatted(this.isLittleEndian() ? "little-endian" : "big-endian", sampleType == null ? "???" : sampleType.prettyName(), this.isBigTiff() ? " [BigTIFF]" : "", this.compressionPrettyName()));
            if (this.hasTileInformation()) {
                sb.append(json ? "  \"tiles\" : {\n    \"sizeX\" : %d,\n    \"sizeY\" : %d,\n    \"countX\" : %d,\n    \"countY\" : %d,\n    \"count\" : %d\n  },\n".formatted(tileSizeX, tileSizeY, tileCountX, tileCountY, tileCountX * tileCountY) : "%dx%d=%d tiles %dx%d (last tile %sx%s)".formatted(tileCountX, tileCountY, tileCountX * tileCountY, tileSizeX, tileSizeY, TiffIFD.remainderToString(dimX, tileSizeX), TiffIFD.remainderToString(dimY, tileSizeY)));
            } else {
                sb.append(json ? "  \"strips\" : {\n    \"sizeY\" : %d,\n    \"countY\" : %d\n  },\n".formatted(tileSizeY, tileCountY) : "%d strips per %d lines (last strip %s, virtual \"tiles\" %dx%d)".formatted(tileCountY, tileSizeY, (long)dimY == tileCountY * (long)tileSizeY ? "full" : TiffIFD.remainderToString(dimY, tileSizeY) + " lines", tileSizeX, tileSizeY));
            }
            sb.append(json ? "  \"chunked\" : %s,\n".formatted(this.isChunked()) : (this.isChunked() ? ", chunked (interleaved)" : ", planar (separated)"));
        }
        catch (Exception e) {
            sb.append((String)(json ? "  \"exceptionAdditional\" : \"%s\",\n".formatted(TiffIFD.escapeJsonString(e.getMessage())) : " [cannot detect additional information: " + e.getMessage() + "]"));
        }
        if (!json) {
            if (this.hasFileOffsetForReading()) {
                sb.append(", reading offset @%d=0x%X".formatted(this.fileOffsetForReading, this.fileOffsetForReading));
            }
            if (this.hasFileOffsetForWriting()) {
                sb.append(", writing offset @%d=0x%X".formatted(this.fileOffsetForWriting, this.fileOffsetForWriting));
            }
            if (this.hasNextIFDOffset()) {
                sb.append(this.isLastIFD() ? ", LAST" : ", next IFD at @%d=0x%X".formatted(this.nextIFDOffset, this.nextIFDOffset));
            }
        }
        if (format == StringFormat.BRIEF) {
            assert (!json);
            return sb.toString();
        }
        if (json) {
            sb.append("  \"map\" : {\n");
        } else {
            sb.append("; ").append(this.numberOfEntries()).append(" entries:");
        }
        LinkedHashMap<Integer, TiffEntry> entries = this.detailedEntries;
        Set<Integer> keySequence = format.sorted ? new TreeSet<Integer>(this.map.keySet()) : this.map.keySet();
        boolean firstEntry = true;
        for (Integer tag : keySequence) {
            TiffEntry tiffEntry;
            Object v = this.get(tag);
            boolean manyValues = v != null && v.getClass().isArray();
            String tagName = Tags.tiffTagName(tag, !json);
            if (json) {
                sb.append(firstEntry ? "" : ",\n");
                firstEntry = false;
                sb.append("    \"%s\" : ".formatted(TiffIFD.escapeJsonString(tagName)));
                if (manyValues) {
                    sb.append("[");
                    TiffIFD.appendIFDArray(sb, v, false, true);
                    sb.append("]");
                    continue;
                }
                if (v instanceof TagRational) {
                    sb.append("\"").append(v).append("\"");
                    continue;
                }
                if (v instanceof Number || v instanceof Boolean) {
                    sb.append(v);
                    continue;
                }
                sb.append("\"");
                TiffIFD.escapeJsonString(sb, String.valueOf(v));
                sb.append("\"");
                continue;
            }
            sb.append("%n".formatted(new Object[0]));
            Object additional = null;
            try {
                block3 : switch (tag) {
                    case 262: {
                        additional = this.getPhotometricInterpretation().prettyName();
                        break;
                    }
                    case 259: {
                        additional = this.compressionPrettyName();
                        break;
                    }
                    case 284: {
                        Number number;
                        if (v instanceof Number) {
                            number = (Number)v;
                            switch (number.intValue()) {
                                case 1: {
                                    additional = "chunky";
                                    break block3;
                                }
                                case 2: {
                                    additional = "rarely-used planar";
                                }
                            }
                        }
                        break;
                    }
                    case 339: {
                        Number number;
                        if (v instanceof Number) {
                            number = (Number)v;
                            switch (number.intValue()) {
                                case 1: {
                                    additional = "unsigned integer";
                                    break block3;
                                }
                                case 2: {
                                    additional = "signed integer";
                                    break block3;
                                }
                                case 3: {
                                    additional = "IEEE float";
                                    break block3;
                                }
                                case 4: {
                                    additional = "undefined";
                                    break block3;
                                }
                                case 5: {
                                    additional = "complex integer";
                                    break block3;
                                }
                                case 6: {
                                    additional = "complex float";
                                }
                            }
                        }
                        break;
                    }
                    case 266: {
                        additional = !this.isReversedFillOrder() ? "default bits order: highest first (big-endian, 7-6-5-4-3-2-1-0)" : "reversed bits order: lowest first (little-endian, 0-1-2-3-4-5-6-7)";
                        break;
                    }
                    case 317: {
                        TagPredictor predictor;
                        Number number;
                        if (!(v instanceof Number) || (predictor = TagPredictor.ofOrUnknown((number = (Number)v).intValue())) == TagPredictor.UNKNOWN) break;
                        additional = predictor.prettyName();
                    }
                }
            }
            catch (Exception e) {
                additional = e;
            }
            sb.append("    ").append(tagName).append(" = ");
            if (manyValues) {
                sb.append(v.getClass().getComponentType().getSimpleName());
                sb.append("[").append(Array.getLength(v)).append("]");
                sb.append(" {");
                TiffIFD.appendIFDArray(sb, v, format.compactArrays, false);
                sb.append("}");
            } else if (v instanceof String) {
                sb.append("\"").append(v).append("\"");
            } else {
                sb.append(v);
            }
            if (entries != null && (tiffEntry = (TiffEntry)entries.get(tag)) != null) {
                int tagType = tiffEntry.type();
                sb.append(" : ").append(TagTypes.typeToString(tagType));
                int valueCount = tiffEntry.valueCount();
                if (valueCount != 1) {
                    sb.append("[").append(valueCount).append("]");
                }
                if (!tiffEntry.builtInData()) {
                    long offset = tiffEntry.valueOffset();
                    long length = tiffEntry.valueLength();
                    sb.append(" at @").append(offset).append("..").append(offset + length - 1L).append(" (").append(length).append(" bytes)");
                }
            }
            if (additional == null) continue;
            sb.append("   [it means: ").append(additional).append("]");
        }
        if (json) {
            sb.append("\n  }\n}");
        }
        return sb.toString();
    }

    public static int sizeOfIFDTableExcludingEntries(boolean bigTiff, boolean mainIFD) {
        int result;
        int n = result = bigTiff ? 8 : 2;
        if (mainIFD) {
            result += bigTiff ? 8 : 4;
        }
        return result;
    }

    public static int sizeOfIFDTable(long numberOfEntries, boolean bigTiff, boolean mainIFD) throws TiffException {
        int bytesPerEntry = TiffEntry.bytesPerEntry(bigTiff);
        int n = TiffIFD.checkNumberOfEntries(numberOfEntries, bigTiff);
        return TiffIFD.sizeOfIFDTableExcludingEntries(bigTiff, mainIFD) + bytesPerEntry * n;
    }

    public static int checkNumberOfEntries(long numberOfEntries, boolean bigTiff) throws TiffException {
        int numberOfEntriesLimit;
        if (numberOfEntries < 0L) {
            throw new TiffException("Negative number of IFD entries: " + numberOfEntries);
        }
        int n = numberOfEntriesLimit = bigTiff ? 10000000 : 65535;
        if (numberOfEntries > (long)numberOfEntriesLimit) {
            throw new TiffException("Too many IFD entries: " + numberOfEntries + " > " + numberOfEntriesLimit);
        }
        return (int)numberOfEntries;
    }

    public static void checkNumberOfChannels(long numberOfChannels) {
        if (numberOfChannels <= 0L) {
            throw new IllegalArgumentException("Zero or negative numberOfChannels = " + numberOfChannels);
        }
        if (numberOfChannels > 128L) {
            throw new IllegalArgumentException("Very large number of channels " + numberOfChannels + " > 128 is not supported");
        }
    }

    public static void checkBitsPerSample(long bitsPerSample) {
        if (bitsPerSample <= 0L) {
            throw new IllegalArgumentException("Zero or negative bitsPerSample = " + bitsPerSample);
        }
        if (bitsPerSample > 256L) {
            throw new IllegalArgumentException("Very large number of bits per sample " + bitsPerSample + " > 256 is not supported");
        }
    }

    public static long multiplySizes(long sizeX, long sizeY) {
        if (sizeX < 0L) {
            throw new IllegalArgumentException("Negative sizeX = " + sizeX);
        }
        if (sizeY < 0L) {
            throw new IllegalArgumentException("Negative sizeY = " + sizeY);
        }
        if (sizeX > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large sizeX = " + sizeX + " >2^31-1");
        }
        if (sizeY > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large sizeY = " + sizeY + " >2^31-1");
        }
        long result = sizeX * sizeY;
        if (result > 0xFFFFFFFFFFFFL) {
            throw new TooLargeArrayException("Extremely large area " + sizeX + "x" + sizeY + ": number of pixel bits may exceed the limit 2^63 for too large number of channels 128 and too many bits per sample 256 (" + sizeX + " * " + sizeY + " * 128 * 256 = " + (double)result * 32768.0 + " > 2^63-1 = 9.223372036854776E18)");
        }
        return result;
    }

    public static int sizeOfRegionInBytes(long sizeX, long sizeY, int numberOfChannels, int bitsPerSample) throws TiffException {
        long n = TiffIFD.multiplySizes(sizeX, sizeY);
        TiffIFD.checkNumberOfChannels(numberOfChannels);
        TiffIFD.checkBitsPerSample(bitsPerSample);
        long size = n * (long)numberOfChannels * (long)bitsPerSample;
        if (size > 0x3FFFFFFFFL) {
            throw new TooLargeTiffImageException("Too large requested image " + sizeX + "x" + sizeY + " (" + numberOfChannels + " samples/pixel, " + bitsPerSample + " bits/sample): it requires > 2 GB to store (2147483647 bytes)");
        }
        assert (size >= 0L);
        return (int)(size + 7L >>> 3);
    }

    private void clearCache() {
        this.cachedTileOrStripByteCounts = null;
        this.cachedTileOrStripOffsets = null;
    }

    private void checkImmutable() {
        this.checkImmutable("IFD cannot be modified");
    }

    private void checkImmutable(String nameOfPart) {
        if (this.frozen) {
            throw new IllegalStateException(nameOfPart + ": it is frozen for future writing TIFF");
        }
    }

    private void removeEntries(int ... tags) {
        if (this.detailedEntries != null) {
            for (int tag : tags) {
                this.detailedEntries.remove(tag);
            }
        }
    }

    private boolean offsetCannotBeCorrectFreeSpace(long offset, long tiffFileLength) {
        if (offset == tiffFileLength || offset + 1L == tiffFileLength) {
            return true;
        }
        if (this.detailedEntries == null) {
            return false;
        }
        for (TiffEntry entry : this.detailedEntries.values()) {
            if (offset != entry.valueOffset()) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupportedPrecisionWithCheckingEquality(int[] bitsPerSample) throws UnsupportedTiffFormatException {
        int bits = bitsPerSample[0];
        for (int i = 1; i < bitsPerSample.length; ++i) {
            if (bitsPerSample[i] == bits) continue;
            throw new UnsupportedTiffFormatException("The number of bits per samples is unequal for different channels: " + Arrays.toString(bitsPerSample) + " (this variant is not supported, in particular for writing)");
        }
        boolean binary = bitsPerSample.length == 1 && bits == 1;
        return binary || bits == 8 || bits == 16 || bits == 32 || bits == 64;
    }

    private static int truncatedIntValue(Number value) {
        Objects.requireNonNull(value);
        long result = value.longValue();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (result < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }

    private static int checkedIntValue(Number value, int tag) throws TiffException {
        Objects.requireNonNull(value);
        long result = value.longValue();
        if (result > Integer.MAX_VALUE) {
            throw new TiffException("Very large " + Tags.tiffTagName(tag, true) + " = " + String.valueOf(value) + " >= 2^31 is not supported");
        }
        if (result < Integer.MIN_VALUE) {
            throw new TiffException("Very large (by absolute value) negative " + Tags.tiffTagName(tag, true) + " = " + String.valueOf(value) + " < -2^31 is not supported");
        }
        return (int)result;
    }

    private static int[] nInts(int count, int filler) {
        int[] result = new int[count];
        Arrays.fill(result, filler);
        return result;
    }

    private static String remainderToString(long a, long b) {
        long r = a / b;
        if (r * b == a) {
            return String.valueOf(b);
        }
        return String.valueOf(a - r * b);
    }

    private static void appendIFDArray(StringBuilder sb, Object v, boolean compact, boolean jsonMode) {
        boolean numeric;
        boolean bl = numeric = v instanceof byte[] || v instanceof short[] || v instanceof int[] || v instanceof long[] || v instanceof float[] || v instanceof double[] || v instanceof Number[];
        if (!numeric && jsonMode) {
            return;
        }
        if (!jsonMode && v instanceof byte[]) {
            byte[] bytes = (byte[])v;
            TiffIFD.appendIFDHexBytesArray(sb, bytes, compact);
            return;
        }
        int len = Array.getLength(v);
        int left = v instanceof short[] ? 25 : 10;
        int right = v instanceof short[] ? 10 : 5;
        int mask = v instanceof short[] ? 65535 : 0;
        for (int k = 0; k < len; ++k) {
            if (compact && k == left && len >= left + 5 + right) {
                sb.append(", ...");
                k = len - right - 1;
                continue;
            }
            if (k > 0) {
                sb.append(", ");
            }
            Object o = Array.get(v, k);
            if (mask != 0) {
                o = ((Number)o).intValue() & mask;
            }
            if (o instanceof String || jsonMode && o instanceof TagRational) {
                sb.append("\"").append(o).append("\"");
                continue;
            }
            sb.append(o);
        }
    }

    private static void appendIFDHexBytesArray(StringBuilder sb, byte[] v, boolean compact) {
        int len = v.length;
        for (int k = 0; k < len; ++k) {
            if (compact && k == 20 && len >= 35) {
                sb.append(", ...");
                k = len - 11;
                continue;
            }
            if (k > 0) {
                sb.append(", ");
            }
            TiffIFD.appendHexByte(sb, v[k] & 0xFF);
        }
    }

    private static void appendHexByte(StringBuilder sb, int v) {
        if (v < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(v));
    }

    private static String escapeJsonString(CharSequence string) {
        StringBuilder result = new StringBuilder();
        TiffIFD.escapeJsonString(result, string);
        return result.toString();
    }

    private static void escapeJsonString(StringBuilder result, CharSequence string) {
        int len = string.length();
        block8: for (int i = 0; i < len; ++i) {
            int begin = i;
            int end = i;
            char c = string.charAt(i);
            while (c >= ' ' && c != '\"' && c != '\\') {
                end = ++i;
                if (i >= len) break;
                c = string.charAt(i);
            }
            if (begin < end) {
                result.append(string, begin, end);
                if (i == len) break;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    result.append('\\');
                    result.append(c);
                    continue block8;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    continue block8;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block8;
                }
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block8;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block8;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block8;
                }
                default: {
                    String hex = "000" + Integer.toHexString(c);
                    result.append("\\u").append(hex.substring(hex.length() - 4));
                }
            }
        }
    }

    record TiffEntry(int tag, int type, int valueCount, long valueOffset, boolean bigTiff) {
        TiffEntry {
            if (valueCount < 0) {
                throw new IllegalArgumentException("Negative valueCount = " + valueCount);
            }
            if (valueOffset < 0L) {
                throw new IllegalArgumentException("Negative valueOffset = " + valueOffset);
            }
        }

        long valueLength() {
            return (long)this.valueCount * (long)TagTypes.sizeOfType(this.type);
        }

        long offsetAfter() {
            return this.valueOffset + this.valueLength();
        }

        boolean builtInData() {
            return TiffEntry.builtInData(this.valueLength(), this.bigTiff);
        }

        int bytesPerEntry() {
            return TiffEntry.bytesPerEntry(this.bigTiff);
        }

        long sizeOf() {
            int builtInLength = this.bytesPerEntry();
            if (this.builtInData()) {
                return builtInLength;
            }
            long valueLength = this.valueLength();
            return (long)builtInLength + valueLength;
        }

        @Override
        public String toString() {
            return "TiffEntry: tag " + Tags.tiffTagName(this.tag, true) + ", type " + TagTypes.typeToString(this.type) + ", valueCount " + this.valueCount + ", valueOffset " + this.valueOffset + (this.bigTiff ? ", bigTiff" : "");
        }

        static boolean builtInData(long valueLength, boolean bigTiff) {
            return valueLength <= (long)(bigTiff ? 8 : 4);
        }

        static int bytesPerEntry(boolean bigTiff) {
            return bigTiff ? 20 : 12;
        }
    }

    public static enum StringFormat {
        BRIEF(true, false),
        NORMAL(true, false),
        NORMAL_SORTED(true, true),
        DETAILED(false, false),
        JSON(false, false);

        private final boolean compactArrays;
        private final boolean sorted;

        private StringFormat(boolean compactArrays, boolean sorted) {
            this.compactArrays = compactArrays;
            this.sorted = sorted;
        }

        public boolean isJson() {
            return this == JSON;
        }
    }

    public record UnsupportedTypeValue(int type, int count, long valueOrOffset) {
        public UnsupportedTypeValue {
            if (count < 0) {
                throw new IllegalArgumentException("Negative count of values");
            }
        }

        @Override
        public String toString() {
            return "Unsupported TIFF value (unknown type code " + this.type + ", " + this.count + " elements)";
        }
    }
}

