/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.matrices.tiff.SCIFIOBridge;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.tags.TagCompression;
import org.scijava.Context;
import org.scijava.io.handle.BytesHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.FileHandle;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;

public abstract sealed class TiffIO
implements Closeable
permits TiffReader, TiffWriter {
    public static final int FILE_USUAL_MAGIC_NUMBER = 42;
    public static final int FILE_BIG_TIFF_MAGIC_NUMBER = 43;
    public static final int FILE_PREFIX_LITTLE_ENDIAN = 73;
    public static final int FILE_PREFIX_BIG_ENDIAN = 77;
    static final System.Logger LOG = System.getLogger(TiffIO.class.getName());
    static final boolean LOGGABLE_DEBUG = LOG.isLoggable(System.Logger.Level.DEBUG);
    static final boolean BUILT_IN_TIMING = TiffIO.getBooleanProperty("net.algart.matrices.tiff.timing");
    final DataHandle<?> stream;
    final Object fileLock = new Object();
    volatile Context context = null;
    volatile Object scifio = null;

    public TiffIO(DataHandle<?> stream) {
        this.stream = Objects.requireNonNull(stream, "Null data handle (input/output stream)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandle<?> stream() {
        Object object = this.fileLock;
        synchronized (object) {
            return this.stream;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.scifio = null;
        this.context = context;
    }

    public long fileLength() {
        try {
            return this.stream.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.stream.close();
        }
    }

    public static Context newSCIFIOContext() {
        return SCIFIOBridge.getDefaultScifioContext();
    }

    public static long copyFile(DataHandle<?> inputStream, DataHandle<?> outputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Null input stream");
        Objects.requireNonNull(outputStream, "Null output stream");
        inputStream.seek(0L);
        outputStream.seek(0L);
        long inputLength = inputStream.length();
        long result = TiffIO.copyData(inputStream, outputStream, inputLength);
        outputStream.setLength(outputStream.offset());
        if (result != inputLength) {
            throw new EOFException("Copied only " + result + " bytes from all " + inputLength + " bytes");
        }
        return result;
    }

    static long copyData(DataHandle<?> in, DataHandle<?> out, long length) throws IOException {
        int len;
        long result;
        int actuallyRead;
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length: " + length);
        }
        byte[] buffer = new byte[262144];
        for (result = 0L; result < length && (actuallyRead = in.read(buffer, 0, len = (int)Math.min(length - result, (long)buffer.length))) > 0; result += (long)actuallyRead) {
            out.write(buffer, 0, actuallyRead);
        }
        return result;
    }

    Object scifio() {
        Object scifio = this.scifio;
        if (scifio == null) {
            this.scifio = scifio = SCIFIOBridge.createScifioFromContext(this.context);
        }
        return scifio;
    }

    Object requireScifio(TiffIFD ifd) throws UnsupportedTiffFormatException {
        Object scifio = this.scifio();
        if (scifio == null) {
            throw new UnsupportedTiffFormatException("Reading with TIFF compression " + TagCompression.toPrettyString(ifd.optInt(259, 1)) + " is not supported without external codecs");
        }
        return scifio;
    }

    static DataHandle<?> getExistingFileHandle(Path file) throws FileNotFoundException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new FileNotFoundException("File " + String.valueOf(file) + (Files.exists(file, new LinkOption[0]) ? " is not a regular file" : " does not exist"));
        }
        return TiffIO.getFileHandle(file);
    }

    static DataHandle<?> getFileHandle(Path file) {
        Objects.requireNonNull(file, "Null file");
        FileHandle fileHandle = new FileHandle(new FileLocation(file.toFile()));
        fileHandle.setLittleEndian(false);
        return fileHandle;
    }

    static BytesHandle getBytesHandle(byte[] data) {
        Objects.requireNonNull(data, "Null data");
        return new BytesHandle(new BytesLocation(data));
    }

    static BytesHandle getBytesHandle(BytesLocation bytesLocation) {
        Objects.requireNonNull(bytesLocation, "Null bytesLocation");
        return new BytesHandle(bytesLocation);
    }

    static DataHandle<?> getFileHandle(FileLocation fileLocation) {
        Objects.requireNonNull(fileLocation, "Null fileLocation");
        FileHandle fileHandle = new FileHandle(fileLocation);
        fileHandle.setLittleEndian(false);
        return fileHandle;
    }

    static long debugTime() {
        return BUILT_IN_TIMING && LOGGABLE_DEBUG ? System.nanoTime() : 0L;
    }

    static String prettyFileName(String format, DataHandle<?> handle) {
        if (handle == null) {
            return "";
        }
        Location location = (Location)handle.get();
        if (location == null) {
            return "";
        }
        URI uri = location.getURI();
        if (uri == null) {
            return "";
        }
        return format.formatted(uri);
    }

    static boolean getBooleanProperty(String propertyName) {
        try {
            return Boolean.getBoolean(propertyName);
        }
        catch (Exception e) {
            return false;
        }
    }
}

