/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.nio.ByteOrder;
import java.util.Objects;
import java.util.OptionalInt;
import net.algart.arrays.Array;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.UpdatablePArray;

public enum TiffSampleType {
    BIT(0, "bit", 1, (Class)Boolean.TYPE, false){

        @Override
        public Object javaArray(byte[] bytes, ByteOrder byteOrder) {
            return PackedBitArraysPer8.toLongArray((byte[])bytes);
        }
    }
    ,
    INT8(0, "int8", 8, Byte.TYPE, true),
    UINT8(1, "uint8", 8, Byte.TYPE, false),
    INT16(2, "int16", 16, Short.TYPE, true),
    UINT16(3, "uint16", 16, Short.TYPE, false),
    INT32(4, "int32", 32, Integer.TYPE, true),
    UINT32(5, "uint32", 32, Integer.TYPE, false),
    FLOAT(6, "float", 32, Float.TYPE, true),
    DOUBLE(7, "double", 64, Double.TYPE, true);

    private final int code;
    private final String prettyName;
    private final int bitsPerSample;
    private final Class<?> elementType;
    private final boolean signed;

    private TiffSampleType(int code, String prettyName, int bitsPerSample, Class<?> elementType, boolean signed) {
        this.code = code;
        this.prettyName = prettyName;
        this.bitsPerSample = bitsPerSample;
        this.elementType = elementType;
        this.signed = signed;
    }

    public int code() {
        return this.code;
    }

    public String prettyName() {
        return this.prettyName;
    }

    public int bitsPerSample() {
        return this.bitsPerSample;
    }

    public OptionalInt bytesPerSample() {
        return this.isWholeBytes() ? OptionalInt.of(this.bitsPerSample >>> 3) : OptionalInt.empty();
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public long maxNumberOfSamplesInArray() {
        return this == BIT ? 0x3FFFFFFF8L : Integer.MAX_VALUE;
    }

    public boolean isBinary() {
        return this == BIT;
    }

    public boolean isWholeBytes() {
        return this != BIT;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public Object javaArray(byte[] bytes, ByteOrder byteOrder) {
        return this.elementType == Byte.TYPE ? bytes : (byte[])JArrays.bytesToArray((byte[])bytes, this.elementType, (ByteOrder)byteOrder);
    }

    public static byte[] bytes(PArray array, ByteOrder byteOrder) {
        Object object;
        Objects.requireNonNull(array, "Null array");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (array instanceof BitArray) {
            BitArray bitArray = (BitArray)array;
            object = bitArray.jaBit();
        } else {
            object = array.ja();
        }
        Object javaArray = object;
        return TiffSampleType.bytes(javaArray, array.length(), byteOrder);
    }

    public static byte[] bytes(Object javaArray, long numberOfElements, ByteOrder byteOrder) {
        Objects.requireNonNull(javaArray, "Null javaArray");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (javaArray instanceof byte[]) {
            byte[] a = (byte[])javaArray;
            if (numberOfElements > (long)a.length) {
                throw new IllegalArgumentException("Too short array: " + a.length + "<" + numberOfElements);
            }
            return a;
        }
        if (javaArray instanceof boolean[]) {
            boolean[] a = (boolean[])javaArray;
            return PackedBitArraysPer8.packBits((boolean[])a, (long)0L, (long)numberOfElements);
        }
        if (javaArray instanceof long[]) {
            long[] a = (long[])javaArray;
            return PackedBitArraysPer8.toByteArray((long[])a, (long)numberOfElements);
        }
        return JArrays.arrayToBytes((Object)javaArray, (long)numberOfElements, (ByteOrder)byteOrder);
    }

    public static TiffSampleType ofJavaArray(Object javaArray, boolean signedIntegers) {
        Objects.requireNonNull(javaArray, "Null Java array");
        Class<?> elementType = javaArray.getClass().getComponentType();
        if (elementType == null) {
            throw new IllegalArgumentException("The specified javaArray is not actual an array: it is " + String.valueOf(javaArray.getClass()));
        }
        return javaArray instanceof long[] ? BIT : TiffSampleType.of(elementType, signedIntegers);
    }

    public static TiffSampleType of(PArray array, boolean signedIntegers) {
        Objects.requireNonNull(array, "Null array");
        return TiffSampleType.of(array.elementType(), signedIntegers);
    }

    public static TiffSampleType of(Class<?> elementType, boolean signedIntegers) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (elementType == Boolean.TYPE) {
            return BIT;
        }
        if (elementType == Byte.TYPE) {
            return signedIntegers ? INT8 : UINT8;
        }
        if (elementType == Short.TYPE) {
            return signedIntegers ? INT16 : UINT16;
        }
        if (elementType == Integer.TYPE) {
            return signedIntegers ? INT32 : UINT32;
        }
        if (elementType == Float.TYPE) {
            return FLOAT;
        }
        if (elementType == Double.TYPE) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Element type " + String.valueOf(elementType) + " is not a supported TIFF sample type");
    }

    public static Matrix<UpdatablePArray> asMatrix(Object javaArray, int sizeX, int sizeY, int numberOfChannels, boolean interleavedSamples) {
        UpdatablePArray updatablePArray;
        TiffSampleType.ofJavaArray(javaArray, false);
        if (sizeX < 0 || sizeY < 0) {
            throw new IllegalArgumentException("Negative sizeX = " + sizeX + " or sizeY = " + sizeY);
        }
        if (numberOfChannels <= 0) {
            throw new IllegalArgumentException("Zero or negative numberOfChannels = " + numberOfChannels);
        }
        if (javaArray instanceof boolean[]) {
            throw new IllegalArgumentException("boolean[] array cannot be converted to AlgART matrix; binary matrix should be packed into long[] array");
        }
        if (javaArray instanceof long[]) {
            long[] packedBisArray = (long[])javaArray;
            updatablePArray = BitArray.as((long[])packedBisArray, (long)((long)sizeX * (long)sizeY * (long)numberOfChannels));
        } else {
            updatablePArray = PArray.as((Object)javaArray);
        }
        UpdatablePArray array = updatablePArray;
        return interleavedSamples ? Matrices.matrix((Array)array, (long[])new long[]{numberOfChannels, sizeX, sizeY}) : Matrices.matrix((Array)array, (long[])new long[]{sizeX, sizeY, numberOfChannels});
    }
}

