/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.awt;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.algart.matrices.tiff.awt.JPEGDecoding;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;

public class JPEGEncoding {
    private JPEGEncoding() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJPEG(BufferedImage image, OutputStream out, TagPhotometricInterpretation colorSpace, double quality) throws IOException {
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(out, "Null output stream");
        Objects.requireNonNull(colorSpace, "Null color space");
        if (colorSpace != TagPhotometricInterpretation.Y_CB_CR && colorSpace != TagPhotometricInterpretation.RGB) {
            throw new IllegalArgumentException("Unsupported color space: " + String.valueOf((Object)colorSpace));
        }
        boolean enforceRGB = colorSpace == TagPhotometricInterpretation.RGB;
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(out);
        ImageWriter jpegWriter = JPEGEncoding.getJPEGWriter();
        jpegWriter.setOutput(ios);
        ImageWriteParam writeParam = jpegWriter.getDefaultWriteParam();
        writeParam.setCompressionMode(2);
        writeParam.setCompressionType("JPEG");
        writeParam.setCompressionQuality((float)quality);
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(image);
        if (enforceRGB) {
            writeParam.setDestinationType(imageTypeSpecifier);
        }
        IIOMetadata metadata = jpegWriter.getDefaultImageMetadata(enforceRGB ? null : imageTypeSpecifier, writeParam);
        IIOImage iioImage = new IIOImage(image, null, metadata);
        try {
            jpegWriter.write(null, iioImage, writeParam);
        }
        finally {
            jpegWriter.dispose();
        }
    }

    public static ImageWriter getJPEGWriter() throws IIOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter result = JPEGDecoding.findAWTCodec(writers);
        if (result == null) {
            throw new IIOException("Cannot write JPEG: no necessary registered plugin");
        }
        return result;
    }
}

