/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.IOException;
import java.io.OutputStream;
import net.algart.matrices.tiff.codecs.CCITTFaxDecoderStreamAdapted;
import net.algart.matrices.tiff.codecs.TinyTwelveMonkey;

final class CCITTFaxEncoderStreamAdapted
extends OutputStream {
    private int currentBufferLength = 0;
    private final byte[] inputBuffer;
    private final int inputBufferLength;
    private final int columns;
    private final int rows;
    private int[] changesCurrentRow;
    private int[] changesReferenceRow;
    private int currentRow = 0;
    private int changesCurrentRowLength = 0;
    private int changesReferenceRowLength = 0;
    private byte outputBuffer = 0;
    private byte outputBufferBitLength = 0;
    private final int type;
    private final int fillOrder;
    private boolean optionG32D;
    private boolean optionG3Fill;
    private boolean optionUncompressed;
    private final OutputStream stream;
    public static final Code[] WHITE_TERMINATING_CODES;
    public static final Code[] WHITE_NONTERMINATING_CODES;
    public static final Code[] BLACK_TERMINATING_CODES;
    public static final Code[] BLACK_NONTERMINATING_CODES;

    public CCITTFaxEncoderStreamAdapted(OutputStream stream, int columns, int rows, int type, int fillOrder, long options) {
        this.stream = stream;
        this.type = type;
        this.columns = columns;
        this.rows = rows;
        this.fillOrder = fillOrder;
        this.changesReferenceRow = new int[columns];
        this.changesCurrentRow = new int[columns];
        switch (type) {
            case 3: {
                this.optionG32D = (options & 1L) != 0L;
                this.optionG3Fill = (options & 4L) != 0L;
                this.optionUncompressed = (options & 2L) != 0L;
                break;
            }
            case 4: {
                this.optionUncompressed = (options & 2L) != 0L;
            }
        }
        this.inputBufferLength = (columns + 7) / 8;
        this.inputBuffer = new byte[this.inputBufferLength];
        TinyTwelveMonkey.isTrue(!this.optionUncompressed, this.optionUncompressed, "CCITT GROUP 3/4 OPTION UNCOMPRESSED is not supported");
    }

    @Override
    public void write(int b) throws IOException {
        this.inputBuffer[this.currentBufferLength] = (byte)b;
        ++this.currentBufferLength;
        if (this.currentBufferLength == this.inputBufferLength) {
            this.encodeRow();
            this.currentBufferLength = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private void encodeRow() throws IOException {
        ++this.currentRow;
        int[] tmp = this.changesReferenceRow;
        this.changesReferenceRow = this.changesCurrentRow;
        this.changesCurrentRow = tmp;
        this.changesReferenceRowLength = this.changesCurrentRowLength;
        this.changesCurrentRowLength = 0;
        boolean white = true;
        for (int index = 0; index < this.columns; ++index) {
            int byteIndex = index / 8;
            int bit = index % 8;
            if ((this.inputBuffer[byteIndex] >> 7 - bit & 1) == 1 != white) continue;
            this.changesCurrentRow[this.changesCurrentRowLength] = index;
            ++this.changesCurrentRowLength;
            white = !white;
        }
        switch (this.type) {
            case 2: {
                this.encodeRowType2();
                break;
            }
            case 3: {
                this.encodeRowType4();
                break;
            }
            case 4: {
                this.encodeRowType6();
            }
        }
        if (this.currentRow == this.rows) {
            if (this.type == 4) {
                this.writeEOL();
                this.writeEOL();
            }
            this.fill();
        }
    }

    private void encodeRowType2() throws IOException {
        this.encode1D();
        this.fill();
    }

    private void encodeRowType4() throws IOException {
        this.writeEOL();
        if (this.optionG32D) {
            if (this.changesReferenceRowLength == 0) {
                this.write(1, 1);
                this.encode1D();
            } else {
                this.write(0, 1);
                this.encode2D();
            }
        } else {
            this.encode1D();
        }
        if (this.optionG3Fill) {
            this.fill();
        }
    }

    private void encodeRowType6() throws IOException {
        this.encode2D();
    }

    private void encode1D() throws IOException {
        int runLength;
        boolean white = true;
        for (int index = 0; index < this.columns; index += runLength) {
            int[] nextChanges = this.getNextChanges(index, white);
            runLength = nextChanges[0] - index;
            this.writeRun(runLength, white);
            white = !white;
        }
    }

    private int[] getNextChanges(int pos, boolean white) {
        int[] result = new int[]{this.columns, this.columns};
        for (int i = 0; i < this.changesCurrentRowLength; ++i) {
            if (pos >= this.changesCurrentRow[i] && (pos != 0 || !white)) continue;
            result[0] = this.changesCurrentRow[i];
            if (i + 1 >= this.changesCurrentRowLength) break;
            result[1] = this.changesCurrentRow[i + 1];
            break;
        }
        return result;
    }

    private void writeRun(int runLength, boolean white) throws IOException {
        Code[] codes;
        int nonterm = runLength / 64;
        Code[] codeArray = codes = white ? WHITE_NONTERMINATING_CODES : BLACK_NONTERMINATING_CODES;
        while (nonterm > 0) {
            if (nonterm >= codes.length) {
                this.write(codes[codes.length - 1].code, codes[codes.length - 1].length);
                nonterm -= codes.length;
                continue;
            }
            this.write(codes[nonterm - 1].code, codes[nonterm - 1].length);
            nonterm = 0;
        }
        Code c = white ? WHITE_TERMINATING_CODES[runLength % 64] : BLACK_TERMINATING_CODES[runLength % 64];
        this.write(c.code, c.length);
    }

    private void encode2D() throws IOException {
        boolean white = true;
        int index = 0;
        while (index < this.columns) {
            int[] nextChanges = this.getNextChanges(index, white);
            int[] nextRefs = this.getNextRefChanges(index, white);
            int difference = nextChanges[0] - nextRefs[0];
            if (nextChanges[0] > nextRefs[1]) {
                this.write(1, 4);
                index = nextRefs[1];
                continue;
            }
            if (difference > 3 || difference < -3) {
                this.write(1, 3);
                this.writeRun(nextChanges[0] - index, white);
                this.writeRun(nextChanges[1] - nextChanges[0], !white);
                index = nextChanges[1];
                continue;
            }
            switch (difference) {
                case 0: {
                    this.write(1, 1);
                    break;
                }
                case 1: {
                    this.write(3, 3);
                    break;
                }
                case 2: {
                    this.write(3, 6);
                    break;
                }
                case 3: {
                    this.write(3, 7);
                    break;
                }
                case -1: {
                    this.write(2, 3);
                    break;
                }
                case -2: {
                    this.write(2, 6);
                    break;
                }
                case -3: {
                    this.write(2, 7);
                }
            }
            white = !white;
            index = nextRefs[0] + difference;
        }
    }

    private int[] getNextRefChanges(int a0, boolean white) {
        int i;
        int[] result = new int[]{this.columns, this.columns};
        int n = i = white ? 0 : 1;
        while (i < this.changesReferenceRowLength) {
            if (this.changesReferenceRow[i] > a0 || a0 == 0 && i == 0) {
                result[0] = this.changesReferenceRow[i];
                if (i + 1 >= this.changesReferenceRowLength) break;
                result[1] = this.changesReferenceRow[i + 1];
                break;
            }
            i += 2;
        }
        return result;
    }

    private void write(int code, int codeLength) throws IOException {
        for (int i = 0; i < codeLength; ++i) {
            boolean codeBit;
            boolean bl = codeBit = (code >> codeLength - i - 1 & 1) == 1;
            this.outputBuffer = this.fillOrder == 1 ? (byte)(this.outputBuffer | (codeBit ? (byte)(1 << 7 - this.outputBufferBitLength % 8) : (byte)0)) : (byte)(this.outputBuffer | (codeBit ? (byte)(1 << this.outputBufferBitLength % 8) : (byte)0));
            this.outputBufferBitLength = (byte)(this.outputBufferBitLength + 1);
            if (this.outputBufferBitLength != 8) continue;
            this.stream.write(this.outputBuffer);
            this.clearOutputBuffer();
        }
    }

    private void writeEOL() throws IOException {
        if (this.optionG3Fill) {
            while (this.outputBufferBitLength != 4) {
                this.write(0, 1);
            }
        }
        this.write(1, 12);
    }

    private void fill() throws IOException {
        if (this.outputBufferBitLength != 0) {
            this.stream.write(this.outputBuffer);
        }
        this.clearOutputBuffer();
    }

    private void clearOutputBuffer() {
        this.outputBuffer = 0;
        this.outputBufferBitLength = 0;
    }

    static {
        short code;
        short value;
        int j;
        int bitLength;
        int i;
        WHITE_TERMINATING_CODES = new Code[64];
        WHITE_NONTERMINATING_CODES = new Code[40];
        for (i = 0; i < CCITTFaxDecoderStreamAdapted.WHITE_CODES.length; ++i) {
            bitLength = i + 4;
            for (j = 0; j < CCITTFaxDecoderStreamAdapted.WHITE_CODES[i].length; ++j) {
                value = CCITTFaxDecoderStreamAdapted.WHITE_RUN_LENGTHS[i][j];
                code = CCITTFaxDecoderStreamAdapted.WHITE_CODES[i][j];
                if (value < 64) {
                    CCITTFaxEncoderStreamAdapted.WHITE_TERMINATING_CODES[value] = new Code(code, bitLength);
                    continue;
                }
                CCITTFaxEncoderStreamAdapted.WHITE_NONTERMINATING_CODES[value / 64 - 1] = new Code(code, bitLength);
            }
        }
        BLACK_TERMINATING_CODES = new Code[64];
        BLACK_NONTERMINATING_CODES = new Code[40];
        for (i = 0; i < CCITTFaxDecoderStreamAdapted.BLACK_CODES.length; ++i) {
            bitLength = i + 2;
            for (j = 0; j < CCITTFaxDecoderStreamAdapted.BLACK_CODES[i].length; ++j) {
                value = CCITTFaxDecoderStreamAdapted.BLACK_RUN_LENGTHS[i][j];
                code = CCITTFaxDecoderStreamAdapted.BLACK_CODES[i][j];
                if (value < 64) {
                    CCITTFaxEncoderStreamAdapted.BLACK_TERMINATING_CODES[value] = new Code(code, bitLength);
                    continue;
                }
                CCITTFaxEncoderStreamAdapted.BLACK_NONTERMINATING_CODES[value / 64 - 1] = new Code(code, bitLength);
            }
        }
    }

    public static class Code {
        final int code;
        final int length;

        private Code(int code, int length) {
            this.code = code;
            this.length = length;
        }
    }
}

