/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.codecs.TiffCodec;

public class DeflateCodec
implements TiffCodec {
    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) {
        Deflater deflater;
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        Double compressionLevel = options.getLosslessCompressionLevel();
        if (compressionLevel != null) {
            int level;
            int n = level = compressionLevel <= 0.0 ? 0 : Math.max(1, (int)Math.round(9.0 * Math.min(compressionLevel, 1.0)));
            assert (level <= 9);
            deflater = new Deflater(level);
        } else {
            deflater = new Deflater();
        }
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while (!deflater.finished()) {
            int compressedSize = deflater.deflate(buffer);
            outputStream.write(buffer, 0, compressedSize);
        }
        return outputStream.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] data, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        try {
            while (!inflater.finished()) {
                int decompressedSize = inflater.inflate(buffer);
                outputStream.write(buffer, 0, decompressedSize);
            }
        }
        catch (DataFormatException e) {
            throw new TiffException("Invalid TIFF format: broken compressed data in ZIP (Deflate) block", e);
        }
        return outputStream.toByteArray();
    }
}

