/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.awt.AWTImages;
import net.algart.matrices.tiff.awt.JPEGDecoding;
import net.algart.matrices.tiff.awt.JPEGEncoding;
import net.algart.matrices.tiff.codecs.LosslessJPEGCodec;
import net.algart.matrices.tiff.codecs.StreamTiffCodec;
import net.algart.matrices.tiff.codecs.TiffCodec;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleInputStream;

public class JPEGCodec
extends StreamTiffCodec
implements TiffCodec.Timing {
    private long timeMain = 0L;
    private long timeBridge = 0L;
    private long timeAdditional = 0L;
    private boolean timing = false;

    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        TagPhotometricInterpretation tagPhotometricInterpretation;
        long t2;
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        if (options.floatingPoint) {
            throw new TiffException("JPEG compression cannot be used for floating-point values");
        }
        if (options.numberOfChannels != 1 && options.numberOfChannels != 3) {
            throw new TiffException("JPEG compression for " + options.numberOfChannels + " channels is not supported");
        }
        if (options.bitsPerSample != 8) {
            throw new TiffException("JPEG compression for " + options.bitsPerSample + "-bit samples is not supported (only unsigned 8-bit samples allowed)");
        }
        if (options.signed) {
            throw new TiffException("JPEG compression for signed " + options.bitsPerSample + "-bit samples is not supported (only unsigned 8-bit samples allowed)");
        }
        if (data.length == 0) {
            return data;
        }
        long t1 = this.timing ? System.nanoTime() : 0L;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedImage image = AWTImages.makeImage(data, options.width, options.height, options.numberOfChannels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, false);
        long l = t2 = this.timing ? System.nanoTime() : 0L;
        if (options instanceof JPEGOptions) {
            JPEGOptions extended = (JPEGOptions)options;
            tagPhotometricInterpretation = extended.getPhotometricInterpretation();
        } else {
            tagPhotometricInterpretation = TagPhotometricInterpretation.Y_CB_CR;
        }
        TagPhotometricInterpretation colorSpace = tagPhotometricInterpretation;
        double jpegQuality = Math.min(options.compressionQuality(), 1.0);
        try {
            JPEGEncoding.writeJPEG(image, output, colorSpace, jpegQuality);
        }
        catch (IOException e) {
            throw new TiffException("Cannot compress JPEG data", e);
        }
        byte[] result = output.toByteArray();
        long t3 = this.timing ? System.nanoTime() : 0L;
        this.timeBridge += t2 - t1;
        this.timeMain += t3 - t2;
        return result;
    }

    @Override
    public byte[] decompress(DataHandle<?> in, TiffCodec.Options options) throws IOException {
        byte[] result;
        long t3;
        JPEGDecoding.ImageInformation info;
        Objects.requireNonNull(in, "Null input handle");
        long offset = in.offset();
        long t1 = this.timing ? System.nanoTime() : 0L;
        try (BufferedInputStream input = new BufferedInputStream((InputStream)new DataHandleInputStream(in), 8192);){
            info = JPEGDecoding.readJPEG(input);
        }
        catch (IOException exc) {
            in.seek(offset);
            return new LosslessJPEGCodec().decompress(in, options);
        }
        if (info == null) {
            throw new TiffException("Cannot read JPEG image: unknown format");
        }
        if (options == null) {
            options = new JPEGOptions();
        }
        boolean completeDecoding = false;
        TagPhotometricInterpretation declaredColorSpace = null;
        int[] declaredSubsampling = null;
        if (options instanceof JPEGOptions) {
            JPEGOptions extended = (JPEGOptions)options;
            declaredColorSpace = extended.getPhotometricInterpretation();
            declaredSubsampling = extended.getYCbCrSubsampling();
            completeDecoding = JPEGDecoding.isCompleteDecodingYCbCrNecessary(info, declaredColorSpace, declaredSubsampling);
        }
        BufferedImage bi = info.bufferedImage();
        long t2 = this.timing ? System.nanoTime() : 0L;
        this.timeMain += t2 - t1;
        byte[][] data = AWTImages.getPixelBytes(bi, options.littleEndian);
        long l = t3 = this.timing ? System.nanoTime() : 0L;
        if (completeDecoding) {
            JPEGDecoding.completeDecodingYCbCr(data, info, declaredColorSpace, declaredSubsampling);
        }
        this.timeBridge += t3 - t2;
        int bandSize = data[0].length;
        if (data.length == 1) {
            result = data[0];
        } else {
            result = new byte[data.length * bandSize];
            if (options.interleaved) {
                int next = 0;
                for (int i = 0; i < bandSize; ++i) {
                    for (byte[] bytes : data) {
                        result[next++] = bytes[i];
                    }
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    System.arraycopy(data[i], 0, result, i * bandSize, bandSize);
                }
            }
        }
        long t4 = this.timing ? System.nanoTime() : 0L;
        this.timeAdditional += t4 - t3;
        return result;
    }

    @Override
    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    @Override
    public void clearTiming() {
        this.timeMain = 0L;
        this.timeBridge = 0L;
        this.timeAdditional = 0L;
    }

    @Override
    public long timeMain() {
        return this.timeMain;
    }

    @Override
    public long timeBridge() {
        return this.timeBridge;
    }

    @Override
    public long timeAdditional() {
        return this.timeAdditional;
    }

    public static class JPEGOptions
    extends TiffCodec.Options {
        private TagPhotometricInterpretation photometricInterpretation = TagPhotometricInterpretation.Y_CB_CR;
        private int[] yCbCrSubsampling = new int[]{2, 2};

        public JPEGOptions() {
            this.setCompressionQuality(1.0);
        }

        public TagPhotometricInterpretation getPhotometricInterpretation() {
            return this.photometricInterpretation;
        }

        public JPEGOptions setPhotometricInterpretation(TagPhotometricInterpretation photometricInterpretation) {
            this.photometricInterpretation = Objects.requireNonNull(photometricInterpretation, "Null photometricInterpretation");
            return this;
        }

        public int[] getYCbCrSubsampling() {
            return (int[])this.yCbCrSubsampling.clone();
        }

        public JPEGOptions setYCbCrSubsampling(int[] yCbCrSubsampling) {
            this.yCbCrSubsampling = (int[])Objects.requireNonNull(yCbCrSubsampling, "Null yCbCrSubsampling").clone();
            return this;
        }

        @Override
        public JPEGOptions setTo(TiffCodec.Options options) {
            super.setTo(options);
            if (options instanceof JPEGOptions) {
                JPEGOptions o = (JPEGOptions)options;
                this.photometricInterpretation = o.photometricInterpretation;
                this.yCbCrSubsampling = (int[])o.yCbCrSubsampling.clone();
            } else {
                Double quality = this.getCompressionQuality();
                if (quality == null) {
                    this.setCompressionQuality(1.0);
                } else if (quality > 1.0) {
                    this.setCompressionQuality(1.0);
                }
            }
            return this;
        }

        @Override
        public String toString() {
            return super.toString() + ", photometricInterpretation=" + String.valueOf((Object)this.photometricInterpretation) + ", yCbCrSubsampling=" + Arrays.toString(this.yCbCrSubsampling);
        }
    }
}

