/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.IOException;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.MutableShortArray;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.codecs.HuffmanCodecAdaptedAndReduced;
import net.algart.matrices.tiff.codecs.StreamTiffCodec;
import net.algart.matrices.tiff.codecs.TiffCodec;
import org.scijava.io.handle.DataHandle;

public class LosslessJPEGCodec
extends StreamTiffCodec {
    public static final int SOF0 = 65472;
    public static final int SOF1 = 65473;
    public static final int SOF2 = 65474;
    public static final int SOF3 = 65475;
    public static final int SOF5 = 65477;
    public static final int SOF6 = 65478;
    public static final int SOF7 = 65479;
    public static final int JPG = 65480;
    public static final int SOF9 = 65481;
    public static final int SOF10 = 65482;
    public static final int SOF11 = 65483;
    public static final int SOF13 = 65485;
    public static final int SOF14 = 65486;
    public static final int SOF15 = 65487;
    public static final int DHT = 65476;
    public static final int DAC = 65484;
    public static final int RST_0 = 65488;
    public static final int RST_1 = 65489;
    public static final int RST_2 = 65490;
    public static final int RST_3 = 65491;
    public static final int RST_4 = 65492;
    public static final int RST_5 = 65493;
    public static final int RST_6 = 65494;
    public static final int RST_7 = 65495;
    public static final int SOI = 65496;
    public static final int EOI = 65497;
    public static final int SOS = 65498;
    public static final int DQT = 65499;
    public static final int DNL = 65500;
    public static final int DRI = 65501;
    public static final int DHP = 65502;
    public static final int EXP = 65503;
    public static final int COM = 65534;

    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        throw new UnsupportedTiffFormatException("Lossless JPEG compression not supported");
    }

    @Override
    public byte[] decompress(DataHandle<?> in, TiffCodec.Options options) throws IOException {
        int i;
        Objects.requireNonNull(in, "Null input handle");
        if (options == null) {
            options = new TiffCodec.Options();
        }
        byte[] buf = new byte[]{};
        short width = 0;
        int bitsPerSample = 0;
        int nComponents = 0;
        int bytesPerSample = 0;
        short[][] huffmanTables = null;
        while (in.offset() < in.length() - 1L) {
            int code = in.readShort() & 0xFFFF;
            int length = in.readShort() & 0xFFFF;
            long fp = in.offset();
            if (length > 65280) {
                length = 0;
                in.seek(fp - 2L);
                continue;
            }
            if (code == 65498) {
                nComponents = in.read();
                int[] dcTable = new int[nComponents];
                int[] acTable = new int[nComponents];
                for (int i2 = 0; i2 < nComponents; ++i2) {
                    in.read();
                    int tableSelector = in.read();
                    dcTable[i2] = (tableSelector & 0xF0) >> 4;
                    acTable[i2] = tableSelector & 0xF;
                }
                int startPredictor = in.read();
                in.read();
                in.read();
                byte[] toDecode = new byte[(int)(in.length() - in.offset())];
                in.read(toDecode);
                HuffmanCodecAdaptedAndReduced.ByteVector b = new HuffmanCodecAdaptedAndReduced.ByteVector();
                for (int i3 = 0; i3 < toDecode.length; ++i3) {
                    b.add(toDecode[i3]);
                    if (toDecode[i3] != -1 || toDecode[i3 + 1] != 0) continue;
                    ++i3;
                }
                toDecode = b.toByteArray();
                HuffmanCodecAdaptedAndReduced.BitBuffer bb = new HuffmanCodecAdaptedAndReduced.BitBuffer(toDecode);
                HuffmanCodecAdaptedAndReduced huffman = new HuffmanCodecAdaptedAndReduced();
                HuffmanCodecAdaptedAndReduced.HuffmanCodecOptions huffmanOptions = new HuffmanCodecAdaptedAndReduced.HuffmanCodecOptions();
                huffmanOptions.bitsPerSample = bitsPerSample;
                huffmanOptions.maxBytes = buf.length / nComponents;
                for (int nextSample = 0; nextSample < buf.length / nComponents; nextSample += bytesPerSample) {
                    for (int i4 = 0; i4 < nComponents; ++i4) {
                        int sampleC;
                        int v;
                        if (huffmanTables != null) {
                            huffmanOptions.table = huffmanTables[dcTable[i4]];
                        }
                        if (huffmanOptions.table != null) {
                            v = huffman.getSample(bb, huffmanOptions);
                            if (nextSample == 0) {
                                v += (int)Math.pow(2.0, bitsPerSample - 1);
                            }
                        } else {
                            throw new UnsupportedTiffFormatException("Arithmetic coding not supported");
                        }
                        int predictor = startPredictor;
                        if (nextSample < width * bytesPerSample) {
                            predictor = 1;
                        } else if (nextSample % (width * bytesPerSample) == 0) {
                            predictor = 2;
                        }
                        int componentOffset = i4 * (buf.length / nComponents);
                        int indexA = nextSample - bytesPerSample + componentOffset;
                        int indexB = nextSample - width * bytesPerSample + componentOffset;
                        int indexC = nextSample - (width + 1) * bytesPerSample + componentOffset;
                        int sampleA = indexA < 0 ? 0 : (int)JArrays.getBytes8InBigEndianOrder((byte[])buf, (int)indexA, (int)bytesPerSample);
                        int sampleB = indexB < 0 ? 0 : (int)JArrays.getBytes8InBigEndianOrder((byte[])buf, (int)indexB, (int)bytesPerSample);
                        int n = sampleC = indexC < 0 ? 0 : (int)JArrays.getBytes8InBigEndianOrder((byte[])buf, (int)indexC, (int)bytesPerSample);
                        if (nextSample > 0) {
                            int pred = switch (predictor) {
                                case 1 -> sampleA;
                                case 2 -> sampleB;
                                case 3 -> sampleC;
                                case 4 -> sampleA + sampleB + sampleC;
                                case 5 -> sampleA + (sampleB - sampleC) / 2;
                                case 6 -> sampleB + (sampleA - sampleC) / 2;
                                case 7 -> (sampleA + sampleB) / 2;
                                default -> 0;
                            };
                            v += pred;
                        }
                        int offset = componentOffset + nextSample;
                        JArrays.setBytes8InBigEndianOrder((byte[])buf, (int)offset, (long)v, (int)bytesPerSample);
                    }
                }
                continue;
            }
            if ((length -= 2) == 0) continue;
            if (code != 65497) {
                if (code == 65475) {
                    bitsPerSample = in.read();
                    short height = in.readShort();
                    width = in.readShort();
                    nComponents = in.read();
                    int[] horizontalSampling = new int[nComponents];
                    int[] verticalSampling = new int[nComponents];
                    int[] quantizationTable = new int[nComponents];
                    for (int i5 = 0; i5 < nComponents; ++i5) {
                        in.skipBytes(1);
                        int s = in.read();
                        horizontalSampling[i5] = (s & 0xF0) >> 4;
                        verticalSampling[i5] = s & 0xF;
                        quantizationTable[i5] = in.read();
                    }
                    bytesPerSample = bitsPerSample / 8;
                    if (bitsPerSample % 8 != 0) {
                        ++bytesPerSample;
                    }
                    buf = new byte[width * height * nComponents * bytesPerSample];
                } else {
                    if (code == 65483) {
                        throw new UnsupportedTiffFormatException("Arithmetic coding is not yet supported");
                    }
                    if (code == 65476) {
                        if (huffmanTables == null) {
                            huffmanTables = new short[4][];
                        }
                        int s = in.read();
                        byte destination = (byte)(s & 0xF);
                        int[] nCodes = new int[16];
                        MutableShortArray table = MutableShortArray.newArray();
                        for (int i6 = 0; i6 < nCodes.length; ++i6) {
                            nCodes[i6] = in.read();
                            table.pushShort((short)nCodes[i6]);
                        }
                        for (int nCode : nCodes) {
                            for (int j = 0; j < nCode; ++j) {
                                table.pushShort((short)(in.read() & 0xFF));
                            }
                        }
                        huffmanTables[destination] = new short[table.length32()];
                        for (int i7 = 0; i7 < huffmanTables[destination].length; ++i7) {
                            huffmanTables[destination][i7] = (short)table.getShort((long)i7);
                        }
                    }
                }
            }
            in.seek(fp + (long)length);
        }
        if (options.interleaved && nComponents > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += nComponents * bytesPerSample) {
                for (int c = 0; c < nComponents; ++c) {
                    int src = c * (buf.length / nComponents) + i / nComponents;
                    int dst = i + c * bytesPerSample;
                    System.arraycopy(buf, src, newBuf, dst, bytesPerSample);
                }
            }
            buf = newBuf;
        }
        if (options.littleEndian && bytesPerSample > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += bytesPerSample) {
                for (int q = 0; q < bytesPerSample; ++q) {
                    newBuf[i + bytesPerSample - q - 1] = buf[i + q];
                }
            }
            buf = newBuf;
        }
        return buf;
    }
}

