/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.codecs.TiffCodec;

public class PackBitsCodec
implements TiffCodec {
    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        return PackBitsCodec.packImage(data, options.width, options.height, options.numberOfChannels, options.bitsPerSample);
    }

    @Override
    public byte[] decompress(byte[] data, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        byte[] result = new byte[options.maxSizeInBytes];
        PackBitsCodec.unpackBytes(result, data, data.length);
        return result;
    }

    public static byte[] packImage(byte[] data, int width, int height, int numberOfChannels, int bitsPerSample) {
        Objects.requireNonNull(data, "Null data");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int bitsPerPixel = numberOfChannels * bitsPerSample;
        int bytesPerRow = (bitsPerPixel * width + 7) / 8;
        int bufSize = bytesPerRow + (bytesPerRow + 127) / 128;
        byte[] buffer = new byte[bufSize];
        int disp = 0;
        for (int i = 0; i < height; ++i) {
            int packedLength = PackBitsCodec.packBytes(buffer, data, disp, bytesPerRow);
            disp += bytesPerRow;
            stream.write(buffer, 0, packedLength);
        }
        return stream.toByteArray();
    }

    public static int packBytes(byte[] dest, byte[] src, int srcPos, int numberOfUnpackedBytes) {
        int destPos = 0;
        int srcPosMax = srcPos + numberOfUnpackedBytes - 1;
        int srcPosMaxMinus1 = srcPosMax - 1;
        while (srcPos <= srcPosMax) {
            int run;
            byte replicate = src[srcPos];
            for (run = 1; run < 127 && srcPos < srcPosMax && src[srcPos] == src[srcPos + 1]; ++run, ++srcPos) {
            }
            if (run > 1) {
                ++srcPos;
                dest[destPos++] = (byte)(-(run - 1));
                dest[destPos++] = replicate;
            }
            int saveOffset = destPos;
            for (run = 0; run < 128 && (srcPos < srcPosMax && src[srcPos] != src[srcPos + 1] || srcPos < srcPosMaxMinus1 && src[srcPos] != src[srcPos + 2]); ++run) {
                dest[++destPos] = src[srcPos++];
            }
            if (run > 0) {
                dest[saveOffset] = (byte)(run - 1);
                ++destPos;
            }
            if (srcPos != srcPosMax) continue;
            if (run > 0 && run < 128) {
                int n = saveOffset;
                dest[n] = (byte)(dest[n] + 1);
            } else {
                dest[destPos++] = 0;
            }
            dest[destPos++] = src[srcPos++];
        }
        return destPos;
    }

    public static int unpackBytes(byte[] dest, byte[] src, int numberOfPackedBytes) {
        if (numberOfPackedBytes < 0 || numberOfPackedBytes > src.length) {
            throw new IllegalArgumentException("Invalid numberOfPackedBytes: " + numberOfPackedBytes);
        }
        int srcPos = 0;
        int destPos = 0;
        int maxSrcPos = numberOfPackedBytes - 1;
        while (destPos < dest.length && srcPos < maxSrcPos) {
            byte b;
            if ((b = src[srcPos++]) >= 0) {
                int n = b + 1;
                if (srcPos + n > numberOfPackedBytes || destPos + n > dest.length) break;
                System.arraycopy(src, srcPos, dest, destPos, n);
                srcPos += n;
                destPos += n;
                continue;
            }
            if (b == -128) continue;
            byte repeat = src[srcPos++];
            int n = Math.min(-b + 1, dest.length - destPos);
            for (int i = 0; i < n; ++i) {
                dest[destPos++] = repeat;
            }
        }
        return destPos;
    }
}

